#!/usr/bin/bash
# 
# Copyright 2003-2019 Broadcom. All Rights Reserved.
# The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
# 

PRODUCT_STRING="Emulex HBA Manager"
platform_os=`uname -s`

if [ "$platform_os" = "Linux" ];then
    INSTALL_DIR="usr/sbin/ocmanager"
else
    INSTALL_DIR="opt/ELXocm"
fi

#  Kill parent elxdiscoveryd
ppid=`ps -ea | grep elxdisc | grep -v grep | grep -v start | grep -v elx-discoveryd | awk '{ print $1 }' | sort -n | head -n 1`
if [ ! -z "$ppid" ]; then
    if [ "$platform_os" = "Linux" ]; then
        echo "Stopping elxdiscoveryd (via systemctl):"
        systemctl stop elxdiscoveryd.service
    else
        svcadm disable -t application/elxdiscoveryd
    fi
fi

#  Verify that the discovery daemon has indeed stopped
ppid=`ps -ea | grep elxdisc | grep -v grep | grep -v start | grep -v elx-discoveryd | awk '{ print $1 }' | sort -n | head -n 1`
trycount=0;
while [ ! -z "$ppid" ] && [ $trycount -lt 60 ]
do
    sleep 1
    ppid=`ps -ea | grep elxdisc | grep -v grep | grep -v start | grep -v elx-discoveryd | awk '{ print $1 }' | sort -n | head -n 1`
    trycount=`expr $trycount + 1`
done

# Verify that the daemon has indeed been stopped
if [ $trycount -eq 60 ]; then
    echo "Unable to stop the $PRODUCT_STRING Discovery Server"
fi

if [ "$platform_os" = "Linux" ];then   
    #  Start the discovery daemon
    echo "Starting elxdiscoveryd (via systemctl):"
    systemctl start elxdiscoveryd.service
else
    # Solaris
    # Temporarily (until the next reboot) start the elxdiscoveryd daemon.
    svcadm enable -t application/elxdiscoveryd
fi
