#/bin/sh
DELETE_RETRY_COUNT=5
DELETE_RETRY_SLEEP=5
node_host=$1
unset REMOVE_PORTS
unset HOST_PORT

usage() {
    echo "Usage: $0 -h <scsi_host> ; removes all ports on a scsi_host"
    echo "Usage: $0 -r ; removes all ports on all hosts"
    echo "Usage: $0 <scsi_host> ; removes port for that scsi_host"
    echo "Usage: $0 <wwpn wwnn> ; remove port given explicit wwpn wwnn pair"
}

show_exclusive_usage() {
    usage 
    cat <<EOF
   
   Please donot specify both -h and -r options together. They are mutually exclusive.
   AVAILABLE OPTIONS:
      -r : Removes all vports on all hosts
      -h <host> : Removes all vports on associed with a host 

   EXAMPLE :
       rmvport.sh -r   
             -This command will remove all vports on all hosts

       - OR -

       rmvport.sh -h host10   
             -This command will remove all vports on host10.
   
EOF
    exit 1
}

while getopts ":h:r" options; do
  case $options in
    r ) REMOVE_SPECIFIED=1
        REMOVE_PORTS=1
   	  ;;
    h ) 
        HOST_SPECIFIED=1
	HOST_PORT=$OPTARG
	  ;;
    ? ) 
        HOST_SPECIFIED=1
	HOST_PORT=$OPTARG
	  ;;
  esac
done

vhosts() {
    p_host=$1
    if [ -z "${p_host}" ] ; then
	hsts=$(ls /sys/class/scsi_host/host*/npiv_info |\
	    sed -e 's:/sys/class/scsi_host/::; s:/.*::' |\
	    sed -e 's:host:& :' | sort -n -k 2 | sed -e 's: ::g')
    else
	hsts=$(ls /sys/class/scsi_host/${p_host}/device 2> /dev/null \
	    |grep ^host 2> /dev/null)
	if [ -z "${hsts}" ] ; then
	    num=$(echo $p_host|sed "s/[^0-9]//g")
	    hsts=$(ls /sys/class/scsi_host/${p_host}/device/vport* 2> /dev/null \
		|grep ^host)
	fi
    fi

    for hst in $hsts; do
        virt="$(cat /sys/class/scsi_host/$hst/npiv_info | grep Virt)"
        if [ "$virt" != "" ]; then
            echo $hst
        fi
    done
}

enumerate_vhosts() {
    hosts=$(vhosts)

    if [ "$hosts" = "" ]; then
	echo $1 There do not appear to be any NPIV SCSI hosts at all.
    else
	echo "The following name(s) represent SCSI adapter(s) in this system (and, if available their"
	echo "Fibre Channel World Wide Port Names):"
	echo
	for i in $hosts; do
        wwnn="$(cat /sys/class/fc_host/$i/node_name | sed -e 's:0x::')"
        wwpn="$(cat /sys/class/fc_host/$i/port_name | sed -e 's:0x::')"
        echo "    $i" "$wwpn:$wwnn"
	done
	echo
    fi
}

locate_vport_by_wwn() {
				# normalize wwn.  convert :n: to :0n:, then
				# strip any colons, remove leading 0x if
				# present, and fold to lower case.
    wwpn=$(echo $1 | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')
    wwnn=$(echo $2 | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')
    
    vp=$(ls /sys/class/fc_vports)
    if [ "$vp" = "" ]; then
	echo $1 there do not appear to be any vports at all.
    else
	for i in $vp; do
	    if [[ $(cat /sys/class/fc_vports/$i/node_name) == 0x$wwnn &&
		  $(cat /sys/class/fc_vports/$i/port_name) == 0x$wwpn ]]; then
		echo $i
		break
	    fi
	done
    fi
}

locate_parent_host() {
    phost=$(ls -d /sys/bus/pci/*/*/host*/$1 2> /dev/null | sed -e s:/$1:: | sed -e s:.*/host::)
    if [ "$phost" == "" ]; then
        echo ""
    else
        echo host$phost
    fi
}

locate_host_by_wwn() {
				# normalize wwn.  convert :n: to :0n:, then
				# strip any colons, remove leading 0x if
				# present, and fold to lower case.
    wwpn=$(echo $1 | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')
    wwnn=$(echo $2 | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')
    
    hosts=$(vhosts)
    if [ "$hosts" = "" ]; then
	echo $1 there do not appear to be any SCSI hosts at all.
    else
	for i in $hosts; do
	    if [[ $(cat /sys/class/fc_host/$i/node_name) == 0x$wwnn &&
		  $(cat /sys/class/fc_host/$i/port_name) == 0x$wwpn ]]; then
		echo $i
		break
	    fi
	done
    fi
}

#
# get the wwnn and wwpn associated with host
#

locate_wwn_by_vhost() {
    n_host=$1
    wnn=$(cat /sys/class/fc_host/${n_host}/node_name 2> /dev/null )
    wpn=$(cat /sys/class/fc_host/${n_host}/port_name 2> /dev/null )

    if [ -z "${wnn}" ] || [ -z "${wpn}" ] ; then
	echo "No wwnn or wwpn found for host $host"
	exit 1
    fi
    wwpn=$(echo $wpn | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')
    wwnn=$(echo $wnn | sed -e 's/:\(.\):/:0\1:/g' -e s/://g -e s/^0x// | 
	tr '[A-Z]' '[a-z]')

}

delete_vport() {
    new=$(ls /sys/class/fc_host/host*/vport_create 2> /dev/null)
    if [ ! -e /sys/class/scsi_host/$host/info ]; then
	echo $host does not appear to be a valid SCSI host name.
	if [ -n "${vh}" ] ; then
	    enumerate_vhosts
	fi
	exit 1
    else
	if [ "$new" = "" ]; then
	    phost=$(locate_parent_host $host)
	    if [[ $phost == "" ]]; then
		echo $host does not appear to be a valid npiv host identifier
		usage
		if [ -n "${vh}" ] ; then
		    enumerate_vhosts
		fi
		exit 1
	    fi
	    vport_delete="/sys/class/scsi_host/$phost/vport_delete"
	    in_string="$wwpn:$wwnn"
	else
	    vport=$(locate_vport_by_wwn $wwpn $wwnn)
	    if [[ $vport == "" ]]; then
		echo $wwpn $wwnn does not appear to be a valid vport identifier
		usage
		if [ -n "${vh}" ] ; then
		    enumerate_vhosts
		fi
		exit 1
	    fi
	    vport_delete="/sys/class/fc_vports/$vport/vport_delete"
	    in_string="1"
	fi
	echo "echo $in_string > $vport_delete"
	return_string=`echo $in_string > $vport_delete 2>&1`
	return_string=$(echo $return_string | sed 's/.*write error: //')
	try=0
	while ((try++ < $DELETE_RETRY_COUNT)) && \
	    [ "$return_string" == "Resource temporarily unavailable" ] ; do
	  echo "Warning: $return_string"
	  sleep $DELETE_RETRY_SLEEP
	  echo "echo $in_string > $vport_delete"
	  return_string=`echo "$in_string" > "$vport_delete" 2>&1`
	  return_string=$(echo $return_string | sed 's/.*write error: //')
	done
	if [ "$return_string" != "" ] ; then
	    echo "ERROR: failed to remove vport $wwpn on $vhostnum ($return_string)"
	    exit 1
	fi
    fi
}

delete_all_vports() {
    vport_host=$1

#
# Don't report error messages if no npiv capability is supported
#
    if [ -z "${vport_host}" ] ; then 
	cmd="ls /sys/class/scsi_host/*/lpfc_enable_npiv"
    else
	cmd="ls /sys/class/scsi_host/${vport_host}/lpfc_enable_npiv"
    fi
    npivhosts=$(eval $cmd 2> /dev/null)
#
# Process npiv info only if it is supported
#

    if [ $? -ne 0 ] || [ -z "${npivhosts}" ] ; then
	cat<<EOF
No npiv capable host ${vport_host} found and/or no vports to delete
EOF
	exit 1
    else
	hosts=$(vhosts ${vport_host})
	if [ -n "${hosts}" ] ; then
	    for host in ${hosts} ; do
		locate_wwn_by_vhost $host
		delete_vport
		echo "Removing vports on $host may take several minutes for the kernel to complete"
	    done
	else
	    echo "No vports to delete"
	fi
    fi
}

if [ -n "${REMOVE_SPECIFIED}" ] &&  [ -n "${HOST_SPECIFIED}" ] ; then
    show_exclusive_usage
fi

if [ -n "${REMOVE_PORTS}" ] ; then
    delete_all_vports
    if [ $? -ne 0 ] ; then
	echo "failed to remove ports"
	exit 1
    fi
    exit 0
fi

if [ -n "${HOST_PORT}" ] ; then
    # case where -r option is intrepreted as host name, i.e. host equals -r
    echo "${HOST_PORT}" |grep ^\-  
    if [ $? -eq 0 ] ; then
	show_exclusive_usage
    fi
    delete_all_vports $HOST_PORT
    if [ $? -ne 0 ] ; then
	echo "failed to remove ports for host $HOST_PORT"
	exit 1
    fi
    exit 0
fi

#
# Don't report error messages if no npiv capability is supported
#
cmd="ls /sys/class/scsi_host/host*/lpfc_enable_npiv"
npivhosts=$(eval $cmd 2> /dev/null)
#
# Process npiv info only if it is supported
#

if [ $? -ne 0 ] ; then
    cat<<EOF
No npiv capable hosts found and no vports to delete
EOF
    exit 1
else
    vh=$(vhosts)
    if [ $# -eq 0 ] ; then
	usage
	if [ -n "${vh}" ] ; then
	    enumerate_vhosts
	fi
	exit 1
    fi
fi

if [[ $1 == host* ]]; then
    host=$1
    if [ -e /sys/class/fc_host/$host/node_name ]; then
        wwnn="$(cat /sys/class/fc_host/$host/node_name | sed -e 's:0x::')"
        wwpn="$(cat /sys/class/fc_host/$host/port_name | sed -e 's:0x::')"
    else
        wwpn=""
        wwnn=""
    fi
else
    wwpn=$1
    wwnn=$2
    if [ -n "${wwnn}" ] && [ -n "${wwpn}" ] ; then
	host=$(locate_host_by_wwn $wwpn $wwnn)
	if [ -z "$host" ] ; then
	    echo $wwpn $wwnn does not appear to be a valid SCSI host identifier
	    usage
	    if [ -n "${vh}" ] ; then
		enumerate_vhosts
	    fi
	    exit 1
	fi
    else
        usage
	exit 1
    fi
fi

delete_vport
echo "Removing vports may take several minutes for the kernel to complete"
