#!/usr/bin/sh
#
# dump_all_disc_trc <debugfs_mountpoint>
# dump_all_disc_trc <debugfs_mountpoint lpfcX vportY>
#
# This utility will dump all discovery_trace files (all vports)
# and sort the output by sequence number.
#

if test ! -d $1
then
	echo Cannot open find mountpoint: $1
	exit 1
fi
case $# in
(1)
	for i in `find $1 -name discovery_trace -print`
	do
		cat $i > /tmp/temp1.$$
		prefix=`echo $i | sed "s,.*lpfc/,," | sed "s,.discovery_trace,,"`
		cat /tmp/temp1.$$ | sed "s,^,$prefix: ," >> /tmp/temp2.$$
		rm -f /tmp/temp1.$$
	done
	cat /tmp/temp2.$$ | sort --key=2.1 -n  > /tmp/temp3.$$
	rm -f /tmp/temp2.$$
	;;
(3)
	vfile=/$1/lpfc/$2/$3/discovery_trace
	if test ! -e $vfile
	then
		echo Cannot open trace file: $vfile
		exit 1
	fi
	cat $vfile > /tmp/temp3.$$
	;;
(*)
	echo "Usage: dump_all_disc_trc <debugfs_mountpoint>"
	echo "Usage: dump_all_disc_trc <debugfs_mountpoint lpfcX vportY>"
	exit 2
	;;
esac

cat /tmp/temp3.$$ | sed "/DSM / s/evt:0 /evt:RCV_PLOGI /" |
         sed "/DSM / s/evt:1 /evt:RCV_PRLI /" |
         sed "/DSM / s/evt:2 /evt:RCV_LOGO /" |
         sed "/DSM / s/evt:3 /evt:RCV_ADISC /" |
         sed "/DSM / s/evt:4 /evt:RCV_PDISC /" |
         sed "/DSM / s/evt:5 /evt:RCV_PRLO /" |
         sed "/DSM / s/evt:6 /evt:CMPL_PLOGI /" |
         sed "/DSM / s/evt:7 /evt:CMPL_PRLI /" |
         sed "/DSM / s/evt:8 /evt:CMPL_LOGO /" |
         sed "/DSM / s/evt:9 /evt:CMPL_ADISC /" |
         sed "/DSM / s/evt:10 /evt:CMPL_REGLOG /" |
         sed "/DSM / s/evt:11 /evt:REMOVE /" |
         sed "/DSM / s/evt:12 /evt:RECOVERY /" |
         sed "/DSM / s/ste:0 /ste:UNUSED /" |
         sed "/DSM / s/ste:1 /ste:PLOGI /" |
         sed "/DSM / s/ste:2 /ste:ADISC /" |
         sed "/DSM / s/ste:3 /ste:REGLOG /" |
         sed "/DSM / s/ste:4 /ste:PRLI /" |
         sed "/DSM / s/ste:5 /ste:UNMAP /" |
         sed "/DSM / s/ste:6 /ste:MAP /" |
         sed "/DSM / s/ste:7 /ste:NPR /" |
         sed "/node state/ s/ste:0/ste:UNUSED/" |
         sed "/node state/ s/ste:1/ste:PLOGI/" |
         sed "/node state/ s/ste:2/ste:ADISC/" |
         sed "/node state/ s/ste:3/ste:REGLOG/" |
         sed "/node state/ s/ste:4/ste:PRLI/" |
         sed "/node state/ s/ste:5/ste:UNMAP/" |
         sed "/node state/ s/ste:6/ste:MAP/" |
         sed "/node state/ s/ste:7/ste:NPR/" |
         sed "/node state/ s/old:0 /old:UNUSED /" |
         sed "/node state/ s/old:1 /old:PLOGI /" |
         sed "/node state/ s/old:2 /old:ADISC /" |
         sed "/node state/ s/old:3 /old:REGLOG /" |
         sed "/node state/ s/old:4 /old:PRLI /" |
         sed "/node state/ s/old:5 /old:UNMAP /" |
         sed "/node state/ s/old:6 /old:MAP /" |
         sed "/node state/ s/old:7 /old:NPR /" |
         sed "/MBOX / s/cmd:x5 /cmd:INIT_LINK /" |
         sed "/MBOX / s/cmd:x7 /cmd:CFG_LINK /" |
         sed "/MBOX / s/cmd:x9 /cmd:CFG_RING /" |
         sed "/MBOX / s/cmd:xa /cmd:RESET_RING /" |
         sed "/MBOX / s/cmd:xb /cmd:READ_CFG /" |
         sed "/MBOX / s/cmd:xc /cmd:READ_RCFG /" |
         sed "/MBOX / s/cmd:x11 /cmd:READ_REV /" |
         sed "/MBOX / s/cmd:x12 /cmd:RD_LNK_STAT /" |
         sed "/MBOX / s/cmd:x14 /cmd:UNREG_LOGIN /" |
         sed "/MBOX / s/cmd:x16 /cmd:CLEAR_LA /" |
         sed "/MBOX / s/cmd:x17 /cmd:DUMP_MEM /" |
         sed "/MBOX / s/cmd:x21 /cmd:SET_VAR /" |
         sed "/MBOX / s/cmd:x23 /cmd:UREG_D_ID /" |
         sed "/MBOX / s/cmd:x33 /cmd:ASYNCEVT_ENA /" |
         sed "/MBOX / s/cmd:x7c /cmd:CONFIG_HBQ /" |
         sed "/MBOX / s/cmd:x88 /cmd:CFG_PORT /" |
         sed "/MBOX / s/cmd:x8d /cmd:READ_SPARAM /" |
         sed "/MBOX / s/cmd:x93 /cmd:REG_LOGIN /" |
         sed "/MBOX / s/cmd:x95 /cmd:READ_LA /" |
         sed "/MBOX / s/cmd:x96 /cmd:REG_VPI /" |
         sed "/MBOX / s/cmd:x97 /cmd:UNREG_VPI /" |
         sed "/CT cmd/ s/cmd:x21f/cmd:RFF_ID/" |
         sed "/CT cmd/ s/cmd:x213/cmd:RNN_ID/" |
         sed "/CT cmd/ s/cmd:x239/cmd:RSNN_NN/" |
         sed "/CT cmd/ s/cmd:x218/cmd:RSPN_ID/" |
         sed "/CT cmd/ s/cmd:x217/cmd:RFT_ID/" |
         sed "/CT cmd/ s/cmd:x171/cmd:GID_FT/" |
         sed "/CT cmd/ s/cmd:x117/cmd:GFT_ID/" |
         sed "/CT cmd/ s/cmd:x11f/cmd:GFF_ID/"
rm -f /tmp/temp3.$$
