#!/usr/bin/bash
# 
# Copyright 2003-2020 Broadcom. All Rights Reserved.
# The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
# 

platform_os=`uname -s`

if [ "$platform_os" = "Linux" ]; then
    INSTALL_DIR="usr/sbin/ocmanager"
else
    INSTALL_DIR="opt/ELXocm"
fi

if [ "$platform_os" = "Linux" ]; then

    ARCH=$(uname -r)
    ioctl_driver="lpfc"

    if [[ $ARCH = "ppc64le" || $ARCH = "ppc64" ]]; then
        if [[ `lsmod | grep be2net > /dev/null 2>&1` -eq 0 ]] || \
           [[ `lsmod | grep lpnic > /dev/null 2>&1` -eq 0 ]]; then
            be2="be2drivers"
        fi
    fi

    #  Start the server daemon if module loaded
    lpfc_loaded=`lsmod | awk '{ print $1 }' | grep "$ioctl_driver"`

    if [ "$1" != "-w" ]; then
        # start the ocv sensor daemons if necessary
        if [ -x "/usr/local/elx/ocvsensor/start-sensor" ]; then
            /usr/local/elx/ocvsensor/start-sensor
        fi
    fi

    # start the OneCommand Management Server last
    if [ ! -z "$lpfc_loaded" ] || [ ! -z "$be2" ]; then
        echo "Starting elxhbamgrd (via systemctl):"
        systemctl start elxhbamgrd.service
    #else
        # do not try to start Emulex HBA Manager Remote Management daemon because driver not loaded
        # CR 83380; do not display message because this could be linux guest install on vmware
        #echo ""
        #echo "Not starting Emulex HBA Manager Remote Management daemon because $ioctl_driver driver module not loaded."
        #echo "Load $ioctl_driver driver module and retry."
    fi
else
    # [Solaris]
    if [ "$1" != "-w" ]; then
       # start the ocv sensor daemons if necessary
       if [ -x "/opt/elx/OCVsensor/start-sensor" ]; then
          /opt/elx/OCVsensor/start-sensor
       fi
    fi

    # Start the elxhbamgrd daemons
    svcadm enable -t application/elxhbamgrd
fi


exit 0
