#!/usr/bin/bash
# 
# Copyright 2003-2020 Broadcom. All Rights Reserved.
# The term "Broadcom" refers to Broadcom Inc and/or its subsidiaries.
# 
# This script may be executed as follows:
#
#    stop_ocmanager [-r | -n | -g | -w ]
#
# The following table describes the affect each of these arguments
# has on the the various Emulex HBA Manager related components.
#
#                                  |-----|-----|-----|-----|------|
#                                  | -r  | -n  | -g  | -w  | none |
# |--------------------------------|-----|-----|-----|-----|------|
# | Stop elxdiscoveryd (Discovery) |  N  |  Y  |  Y  |  N  |  Y   |
# |--------------------------------|-----|-----|-----|-----|------|
# | Stop elxhbamgrd (RMServer)     |  Y  |  N  |  Y  |  Y  |  Y   |
# |--------------------------------|-----|-----|-----|-----|------|
# | Stop Emulex HBA Manager GUI    |  N  |  Y  |  N  |  N  |  Y   |
# |--------------------------------|-----|-----|-----|-----|------|
# | Remove Semaphore directory     |  N  |  Y  |  N  |  N  |  Y   |
# |--------------------------------|-----|-----|-----|-----|------|

PRODUCT_STRING="Emulex HBA Manager"
platform_os=`uname -s`

if [ "$platform_os" = "Linux" ];then
    INSTALL_DIR="usr/sbin/ocmanager"
else
    INSTALL_DIR="opt/ELXocm"
fi


# Stop parent elxhbamgrd
# If -n argument was passed to script, then don't kill the elxhbamgrd
if [ "$1" != "-n" ]; then
    if [ "$platform_os" = "Linux" ]; then
        echo "Stopping elxhbamgrd (via systemctl):"
        systemctl stop elxhbamgrd.service
    else
        # Solaris
        # Temporarily (until the next reboot) stop the elxhbamgrd daemons
        svcadm disable -st application/elxhbamgrd
    fi
fi

# If request was to stop elxhbamgrd only, then exit now. 
if [ "$1" = "-r" ] || [ "$1" = "-w" ]; then
    exit
fi


# Kill Emulex HBA Manager GUI
if [ "$1" != "-g" ]; then
    #  Get pid of script that started the Emulex HBA Manager GUI
    script_pid=`ps -eaf | grep ocmanager | grep "/bin/bash" | grep -v grep | head -n 1 | awk '{ print $2 }'`
    #  echo "script pid of "/ocmanager" is $script_pid"
    if [ "$script_pid" != "" ]; then
        gui_pid=`ps -eaf | grep java | grep -v grep | grep "/OCManager.jar" | awk '{ print $2 }'`
        if [ "$gui_pid" != "" ]; then
            echo "Stopping the $PRODUCT_STRING GUI"
            if [ "$platform_os" = "Linux" ];then
                kill -9 $gui_pid > /dev/null 2>&1
            else
                kill $gui_pid > /dev/null 2>&1
            fi
        fi
    fi
fi

if [ "$platform_os" = "Linux" ]; then
    if [ "$1" != "-r" ] && [ "$1" != "-w" ]; then
        # Stop parent elxdiscoveryd
        if [ -f /usr/lib/systemd/system/elxdiscoveryd.service ]; then
            echo "Stopping elxdiscoveryd (via systemctl):"
            systemctl stop elxdiscoveryd.service
        fi
    fi
else
    # Solaris
    # Stop the start-elxdiscoveryd service.  No need to restart it in start_ocmanager 
    # since this service doesn't do anything after boot.
    svcadm disable -t application/start-elxdiscoveryd > /dev/null 2>&1
    # Temporarily (until the next reboot) stop the elxdiscoveryd daemon
    svcadm disable -st application/elxdiscoveryd > /dev/null 2>&1
fi

# remove HBA semaphore (POSIX named semaphores)
if [ "$platform_os" = "Linux" ]; then
    if [ "$1" != "-g" ]; then
        rm -f /dev/shm/sem.ElxHbaSem*
    fi
else
    /opt/ELXocm/freesem > /dev/null 2>&1
fi

# if no arguments were used
if [ $# -eq 0 ]; then    
    if [ "$platform_os" = "Linux" ]; then
        # stop the ocv sensor daemons if necessary
        if [ -x "/usr/local/elx/ocvsensor/stop-sensor" ]; then
            /usr/local/elx/ocvsensor/stop-sensor
        fi
    else
        # Solaris
        # stop the ocv sensor daemons if necessary
        if [ -x "/opt/elx/OCVsensor/stop-sensor" ]; then
            /opt/elx/OCVsensor/stop-sensor
        fi
    fi
fi

exit 0
