#!/usr/bin/bash
#
# Copyright (c) 2003-2021 Broadcom. All Rights Reserved.
# The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
#

SUCCESS=0
FHS_SUPPORT=1
SUPPORT_32BIT=0
if [[ $FHS_SUPPORT -eq 1 ]]; then
    LNX_32BIT="com.emulex.emulexapilibrary32 /opt/emulex/ocmanager/lib/libemulexhbaapi.so"
    LNX_64BIT="com.emulex.emulexapilibrary64 /opt/emulex/ocmanager/lib64/libemulexhbaapi.so"
else
    LNX_32BIT="com.emulex.emulexapilibrary32 /usr/lib/libemulexhbaapi.so"
    LNX_64BIT="com.emulex.emulexapilibrary64 /usr/lib64/libemulexhbaapi.so"
fi

# Function:  add_entries_hba_conf()
#
# Description:
#   add emulex hbaapi entries to /etc/hba.conf
#
add_entries_hba_conf()
{
    arch=`uname -m`

    echo "$LNX_64BIT" >> /etc/hba.conf
    if [[ $SUPPORT_32BIT -eq 1 ]]; then
        echo "$LNX_32BIT" >> /etc/hba.conf
    fi
    return $SUCCESS
}

# determine if this invocation of the script is confirming /etc/hba.conf
if [ $# -gt 0 ]; then
    if [ "$1" = "-hba.conf" ]; then
        if [ ! -r /etc/hba.conf ]; then
            touch /etc/hba.conf
        fi
        if [ ! -w /etc/hba.conf ]; then
            # this is a non-root user (secure mgmnt) with no write privileges on this system file
            exit
        fi
        
        # determine if emulex entries currently exist in file
        NUM=`cat /etc/hba.conf | grep "emulexapilibrary" | wc -l`
        if [ $NUM -eq 0 ]; then
            add_entries_hba_conf
        fi
        exit
    fi
fi
exit

