/*
 * Decompiled with CFR 0.152.
 */
package User;

import Vdb.SD_entry;
import Vdb.SlaveWorker;
import Vdb.common;
import java.util.HashMap;

public class UserDeviceInfo {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String sd_name;
    private String sd_lun;
    private long sd_size;
    private long next_lba;
    private long high_lba;
    private boolean use_block_zero;
    private static HashMap<String, UserDeviceInfo> device_map = new HashMap(32);

    public UserDeviceInfo() {
    }

    public UserDeviceInfo(SD_entry sD_entry) {
        this.sd_name = sD_entry.sd_name;
        this.sd_lun = sD_entry.lun;
        this.sd_size = sD_entry.end_lba;
        this.use_block_zero = sD_entry.canWeUseBlockZero();
        this.next_lba = this.use_block_zero ? 0L : 4096L;
        if (device_map.put(this.sd_name, this) != null) {
            common.failure("DeviceInfo: duplicate created for sd=%s", this.sd_name);
        }
    }

    public boolean canWeUseBlockZero() {
        return this.use_block_zero;
    }

    public static UserDeviceInfo findDeviceInfo(String string) {
        return device_map.get(string);
    }

    public static void clearDeviceList() {
        device_map = new HashMap(32);
    }

    public String getLun() {
        return this.sd_lun;
    }

    public String getSdName() {
        return this.sd_name;
    }

    public long obsolete_getHighLba() {
        return this.high_lba;
    }

    public long getSdSize() {
        return this.sd_size;
    }

    public static int getSdCount() {
        return SlaveWorker.sd_list.size();
    }

    public static int getRelativeSdNumber(String string) {
        for (int i = 0; i < SlaveWorker.sd_list.size(); ++i) {
            SD_entry sD_entry = SlaveWorker.sd_list.elementAt(i);
            if (!sD_entry.sd_name.equals(string)) continue;
            return i;
        }
        common.failure("getRelativeSdNumber(): unknown sd name: " + string);
        return 0;
    }

    public static Object[] getDeviceList() {
        Object[] objectArray = device_map.values().toArray();
        return objectArray;
    }

    public synchronized long getNextSeqLba(long l) {
        if (this.next_lba + l > this.sd_size) {
            this.next_lba = this.use_block_zero ? 0L : l;
        }
        long l2 = this.next_lba;
        this.next_lba += l;
        return l2;
    }

    public synchronized void obsolete_setHighLba(long l, int n) {
        if (l == 0L && !this.use_block_zero) {
            common.failure("WorkloadInfo.setHighLba(): trying to access block zero. sd=%s,lun=%s", this.sd_name, this.sd_lun);
        }
        this.high_lba = Math.max(this.high_lba, l + (long)n);
        if (this.high_lba > this.sd_size) {
            common.failure("WorkloadInfo.setHighLba(): trying to get beyond the end of the lun or file. sd=%s,lun=%s,size=%d", this.sd_name, this.sd_lun, this.sd_size);
        }
    }
}

