/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Fput;
import Utils.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class Editor
extends JFrame
implements ActionListener {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static JEditorPane edit_pane = null;
    private static String edit_file = null;
    static JButton save = new JButton("Save");
    static JButton done = new JButton("Cancel");
    static JButton both = new JButton("Save and exit");
    static JLabel fill = new JLabel();

    public Editor(String string) {
        this.setTitle(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public Editor() {
        super("Editor");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length == 0) {
            System.err.println("Usage: vdbench edit file.name");
            System.exit(-1);
        }
        if (!new File(edit_file = new File(stringArray[0]).getAbsolutePath()).exists()) {
            object = new Fput(edit_file);
            ((Fput)object).println("*Empty file, created by the Vdbench Ultra Cheap Fullscreen Editor");
            ((Fput)object).close();
        }
        object = new JScrollPane();
        ((JComponent)object).setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(178, 178, 178)), "Editing file " + edit_file));
        Editor editor = new Editor("Ultra Cheap Fullscreen Editor");
        editor.setSize(new Dimension(1000, 800));
        Container container = editor.getContentPane();
        container.setLayout(new GridBagLayout());
        edit_pane = new JEditorPane("file:///" + edit_file);
        edit_pane.setFont(new Font("Courier New", 0, 12));
        save.addActionListener(editor);
        done.addActionListener(editor);
        both.addActionListener(editor);
        ((JScrollPane)object).getViewport().add((Component)edit_pane, null);
        container.add((Component)object, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)save, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)done, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)both, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)fill, new GridBagConstraints(3, 1, 1, 1, 0.9, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Message.centerscreen(editor);
        editor.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getActionCommand().equals("Cancel")) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals("Save")) {
            String string2 = edit_pane.getText().trim();
            Fput fput = new Fput(edit_file);
            fput.println(string2);
            fput.close();
        } else if (actionEvent.getSource() == both) {
            String string3 = edit_pane.getText().trim();
            Fput fput = new Fput(edit_file);
            fput.println(string3);
            fput.close();
            System.exit(0);
        } else if (!actionEvent.getActionCommand().equals("Cancel")) {
            System.err.println("bad action: " + string);
            System.exit(0);
        }
    }
}

