/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Format;
import Vdb.common;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class Fget {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private BufferedReader br = null;
    private File fptr = null;
    private long filesize = 0L;
    private long bytesread = 0L;
    private long early_eof = Long.MAX_VALUE;
    private String fname = null;
    static String sep = System.getProperty("file.separator");

    public Fget(String string, String string2) {
        this(string + sep + string2);
    }

    public Fget(String string) {
        this.fname = string;
        if (this.fname.endsWith("-")) {
            this.br = new BufferedReader(new InputStreamReader(System.in));
        } else {
            this.fptr = new File(this.fname);
            try {
                if (this.fptr.getName().toLowerCase().endsWith(".gz")) {
                    this.br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.fptr)))));
                } else if (this.fptr.getName().toLowerCase().endsWith(".jz1")) {
                    this.br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.fptr)))));
                } else if (!this.fname.endsWith("stdin") && !this.fname.endsWith("_")) {
                    this.br = new BufferedReader(new FileReader(this.fptr));
                    this.filesize = this.fptr.length();
                } else {
                    this.br = new BufferedReader(new InputStreamReader(new BufferedInputStream(System.in)));
                }
            }
            catch (Exception exception) {
                common.failure(exception);
            }
        }
    }

    public Fget(File file) {
        try {
            this.fptr = file;
            if (this.fptr.getName().toLowerCase().endsWith(".gz")) {
                this.br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.fptr)))));
            } else if (this.fptr.getName().toLowerCase().endsWith(".jz1")) {
                this.br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.fptr)))));
            } else {
                this.br = new BufferedReader(new FileReader(this.fptr));
                this.filesize = this.fptr.length();
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public void force_eof(long l) {
        this.early_eof = l;
    }

    public String getName() {
        return this.fname;
    }

    public static boolean fileRename(String string, String string2, String string3) {
        File file = new File(string, string2);
        File file2 = new File(string, string3);
        boolean bl = file.renameTo(file2);
        if (!bl) {
            common.ptod("Fget.fileRename(): rename failed. " + file.getName() + " ===> " + file2.getName());
        }
        return bl;
    }

    public static String separator(String string) {
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + sep;
        }
        return string;
    }

    public String get() {
        if (this.br == null) {
            return null;
        }
        try {
            String string = this.br.readLine();
            if (string == null) {
                this.close();
                return null;
            }
            this.bytesread += (long)string.length();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            common.ptod("Exception with file name: " + this.getName());
            common.failure(exception);
            return null;
        }
    }

    public String getNoEof() {
        try {
            String string = this.br.readLine();
            if (string == null) {
                return null;
            }
            this.bytesread += (long)string.length();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            common.ptod("Exception with file name: " + this.getName());
            common.failure(exception);
            return null;
        }
    }

    public static Vector read_file_to_vector(String string, String string2) {
        return Fget.readTextFile(new File(string, string2));
    }

    public static Vector read_file_to_vector(String string) {
        return Fget.readTextFile(new File(string));
    }

    public static String[] readFileToArray(String string, String string2) {
        Vector<String> vector = Fget.readFile(string, string2);
        if (vector == null) {
            return null;
        }
        return vector.toArray(new String[0]);
    }

    public static String[] readFileToArray(String string) {
        Vector<String> vector = Fget.readFile(string);
        if (vector == null) {
            return null;
        }
        return vector.toArray(new String[0]);
    }

    private static String[] obsolete_readFileToArray(File file) {
        Vector<String> vector = Fget.readTextFile(file);
        if (vector == null) {
            return null;
        }
        return vector.toArray(new String[0]);
    }

    private static Vector<String> readFile(String string) {
        if (string.startsWith("http://")) {
            return Fget.readTextUrl(string);
        }
        return Fget.readTextFile(new File(string));
    }

    private static Vector<String> readFile(String string, String string2) {
        if (string.startsWith("http://")) {
            return Fget.readTextUrl(string, string2);
        }
        return Fget.readTextFile(new File(string, string2));
    }

    private static Vector<String> readTextFile(File file) {
        String string;
        Vector<String> vector = new Vector<String>(64, 0);
        if (!file.exists()) {
            return null;
        }
        Fget fget = new Fget(file);
        while ((string = fget.get()) != null) {
            vector.add(string);
        }
        fget.close();
        return vector;
    }

    public static Vector<String> readTextUrl(String string, String string2) {
        if (string.endsWith("/")) {
            return Fget.readTextUrl(string + string2);
        }
        return Fget.readTextUrl(string + "/" + string2);
    }

    public static Vector<String> readTextUrl(String string) {
        Vector<String> vector = new Vector<String>(64);
        try {
            String string2;
            URL uRL = new URL(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return vector;
    }

    public String pct_read() {
        if (this.filesize == 0L) {
            return "n/a";
        }
        return Format.f("%3d", this.bytesread * 100L / this.filesize);
    }

    public String get_parent() {
        return this.fptr.getAbsoluteFile().getParent();
    }

    public static String get_parent(String string) {
        return new File(string).getAbsoluteFile().getParent() + sep;
    }

    public void close() {
        try {
            if (this.br != null) {
                this.br.close();
                this.br = null;
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public static boolean dir_exists(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    public static boolean dir_exists(String string, String string2) {
        File file = new File(string, string2);
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    public static boolean file_exists(String string, String string2) {
        boolean bl = new File(string, string2).exists();
        if (bl) {
            return !Fget.dir_exists(string, string2);
        }
        return bl;
    }

    public static boolean file_exists(String string) {
        boolean bl = new File(string).exists();
        if (bl) {
            return !Fget.dir_exists(string);
        }
        return bl;
    }

    public static void file_delete(String string) {
        new File(string).delete();
    }

    public static void file_delete(String string, String string2) {
        new File(string, string2).delete();
    }

    public static void main(String[] stringArray) {
        String string = "http://sbm-240a.us.oracle.com/shares/export/spp/87micro10/spp02/nfsv3_sbt-fill/output004/summary.html";
        String[] stringArray2 = Fget.readFileToArray(string);
        common.ptod("lines: " + stringArray2.length);
    }
}

