/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Fget;
import Utils.OS_cmd;
import Utils.common;
import Vdb.Native;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;

public class Fput {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private String full_name = null;
    private PrintWriter pw = null;
    private int pw_files_created = 0;
    private ArrayList<String> lines_printed = null;
    private static Vector open_files = new Vector(8, 0);

    public Fput(String string, String string2) {
        this(string + File.separator + string2, false);
    }

    public Fput(String string) {
        this(string, false);
    }

    public Fput(String string, String string2, boolean bl) {
        this(string + File.separator + string2, bl);
    }

    public Fput(String string, boolean bl) {
        this.full_name = string;
        this.full_name = this.full_name.replace(File.separator + File.separator, File.separator);
        open_files.add(this);
        if (string.startsWith("null")) {
            common.failure("null file name");
        }
        try {
            if (!string.endsWith("-")) {
                File file = new File(string);
                boolean bl2 = file.exists();
                FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
                this.pw = new PrintWriter(new BufferedOutputStream(fileOutputStream));
            } else {
                this.pw = new PrintWriter(System.out);
            }
            Fput.chmod(string);
            if (++this.pw_files_created % 50 == 0) {
                common.ptod("Created " + this.pw_files_created + " report files; continue processing.");
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        if (string.indexOf(".html") != -1) {
            this.pw.println("<pre>");
        }
    }

    public void preserveLines() {
        this.lines_printed = new ArrayList(1024);
    }

    public ArrayList<String> getPreserves() {
        return this.lines_printed;
    }

    public void close() {
        if (!open_files.remove(this)) {
            common.failure("Trying to close an Fput() file that is not open");
        }
        try {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public static String getTmpDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static void closeAll() {
        while (open_files.size() > 0) {
            ((Fput)open_files.firstElement()).close();
        }
    }

    public String getName() {
        return this.full_name;
    }

    public void print(String string, Object ... objectArray) {
        String string2 = null;
        string2 = objectArray.length > 0 ? String.format(string, objectArray) : string;
        if (this.lines_printed != null) {
            this.lines_printed.add(string2);
        }
        this.pw.print(string2);
    }

    public String println(String string, Object ... objectArray) {
        return this.println(String.format(string, objectArray));
    }

    public String println(String string) {
        if (this.lines_printed != null) {
            this.lines_printed.add(string);
        }
        if (this.pw == null) {
            common.ptod("");
            common.ptod("Fput.println(): file was closed already.");
            common.ptod("Fput.println(): " + string);
            common.failure("Fput.println(): file was closed already.");
        }
        this.pw.println(string);
        if (this.full_name.endsWith("html")) {
            this.pw.flush();
        }
        return string;
    }

    public void flush() {
        this.pw.flush();
    }

    public static void chmod(String string) {
        if (common.onWindows()) {
            return;
        }
        if (string.endsWith("-")) {
            return;
        }
        if (common.onSolaris()) {
            Native.chmod(string);
        } else {
            OS_cmd.execute("chmod 777 " + string, false);
        }
    }

    public static String createTempFileName(String string, String string2) {
        return Fput.createTempFile(string, string2).getAbsolutePath();
    }

    public static String createTempFileName(String string) {
        return Fput.createTempFile("swat", string).getAbsolutePath();
    }

    public static File createTempFile(String string, String string2) {
        try {
            File file = File.createTempFile(string, string2);
            file.deleteOnExit();
            return file;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public void printFile(String string) {
        if (string != null) {
            Vdb.common.ptod("");
            Vdb.common.ptod("%s: Fput.printFile for %s", string, this.getName());
            for (String string2 : Fget.readFileToArray(this.getName())) {
                Vdb.common.ptod("%s: %s", string, string2);
            }
        } else {
            Vdb.common.ptod("");
            Vdb.common.ptod("Fput.printFile for %s", this.getName());
            for (String string3 : Fget.readFileToArray(this.getName())) {
                Vdb.common.ptod("%s", string3);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
    }
}

