/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.LookupAnchor;
import Utils.common;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Lookup
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String field = null;
    private String title = null;
    private int lookup_index = 0;
    private LookupAnchor anchor = null;
    private long scale = 1L;
    private int order = 999;

    public Lookup(LookupAnchor lookupAnchor, String string) {
        this(lookupAnchor, string, string, 1L);
    }

    public Lookup(LookupAnchor lookupAnchor, String string, String string2) {
        this(lookupAnchor, string, string2, 1L);
    }

    public Lookup(LookupAnchor lookupAnchor, String string, long l) {
        this(lookupAnchor, string, string, l);
    }

    public Lookup(LookupAnchor lookupAnchor, String string, String string2, long l) {
        this.anchor = lookupAnchor;
        this.field = string2.trim();
        this.title = string.trim();
        this.scale = l;
        this.lookup_index = lookupAnchor.storeLookupEntry(this);
        if (this.title.indexOf(" ") != -1) {
            common.failure("Lookup title may not contain embedded blanks: " + this.title);
        }
        if (string.indexOf("\\") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \\");
            if (stringTokenizer.countTokens() != 2) {
                common.ptod("Invalid token while creating Lookup: " + string);
                common.where(8);
            } else {
                this.title = stringTokenizer.nextToken();
                this.order = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
    }

    public void setIndex(int n) {
        this.lookup_index = n;
    }

    public int getIndex() {
        return this.lookup_index;
    }

    public String getFieldName() {
        return this.field;
    }

    public String getTitle() {
        return this.title;
    }

    public void setScale(long l) {
        this.scale = l;
    }

    public int getOrder() {
        return this.order;
    }

    public double getScale() {
        if (this.anchor.useDoubles()) {
            return 1000.0 * (double)this.scale;
        }
        return this.scale;
    }
}

