/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Format;
import Utils.Lookup;
import Utils.common;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class LookupAnchor
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String anchor_label = null;
    private String anchor_type = null;
    private String anchor_name = null;
    private boolean use_doubles = false;
    private int current_list_size = 0;
    private Lookup[] lookup_table = new Lookup[100];
    private static HashMap anchor_name_list = new HashMap(16);

    public LookupAnchor(String string) {
        this(string, null, null);
    }

    public LookupAnchor(String string, String string2, String string3) {
        this.anchor_type = string3;
        this.anchor_label = string2;
        this.anchor_name = string2 == null & string3 == null ? string : string + "/" + string2;
        if (anchor_name_list.get(this.anchor_name) != null) {
            common.failure("New LookupAnchor(): duplicate definition of " + this.anchor_name);
        }
        anchor_name_list.put(this.anchor_name, this);
    }

    public static LookupAnchor findAnchor(String string) {
        LookupAnchor lookupAnchor = (LookupAnchor)anchor_name_list.get(string);
        if (lookupAnchor == null) {
            // empty if block
        }
        return lookupAnchor;
    }

    public static LookupAnchor findAnchor(String string, String string2) {
        LookupAnchor lookupAnchor = (LookupAnchor)anchor_name_list.get(string + "/" + string2);
        return lookupAnchor;
    }

    public String getLabel() {
        return this.anchor_label;
    }

    public String getType() {
        return this.anchor_type;
    }

    public String getAnchorName() {
        return this.anchor_name;
    }

    public void setDoubles() {
        this.use_doubles = true;
    }

    public boolean useDoubles() {
        return this.use_doubles;
    }

    public int getIndexForField(String string) {
        return this.getLookupForField(string).getIndex();
    }

    public Lookup getLookupForField(String string) {
        int n = 0;
        while (this.lookup_table[n] != null) {
            if (this.lookup_table[n].getFieldName().equals(string) || this.lookup_table[n].getTitle().equals(string)) {
                return this.lookup_table[n];
            }
            ++n;
        }
        return null;
    }

    public Lookup getLookupForIndex(int n) {
        return this.lookup_table[n];
    }

    public String[] getFieldTitles() {
        String[] stringArray = new String[this.current_list_size];
        int n = 0;
        while (this.lookup_table[n] != null) {
            stringArray[n] = this.lookup_table[n].getTitle();
            ++n;
        }
        return stringArray;
    }

    public String[] getSortedFieldTitles() {
        Object[] objectArray = new String[this.current_list_size];
        int n = 0;
        while (this.lookup_table[n] != null) {
            objectArray[n] = Format.f("%08d ", this.lookup_table[n].getOrder()) + this.lookup_table[n].getTitle();
            ++n;
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            String[] stringArray = ((String)objectArray[n]).split(" ");
            objectArray[n] = stringArray[1];
        }
        return objectArray;
    }

    public String[] getFieldNames() {
        String[] stringArray = new String[this.current_list_size];
        int n = 0;
        while (this.lookup_table[n] != null) {
            stringArray[n] = this.lookup_table[n].getFieldName();
            ++n;
        }
        return stringArray;
    }

    public int getFieldCount() {
        return this.current_list_size;
    }

    public int storeLookupEntry(Lookup lookup) {
        for (int i = 0; i < this.current_list_size; ++i) {
            Lookup lookup2 = this.lookup_table[i];
            if (!lookup2.getFieldName().equalsIgnoreCase(lookup.getFieldName()) && !lookup2.getTitle().equalsIgnoreCase(lookup.getTitle())) continue;
            common.failure("Duplicate Lookup entry: " + lookup.getFieldName() + " " + lookup.getTitle());
        }
        this.lookup_table[this.current_list_size] = lookup;
        return this.current_list_size++;
    }

    public void validateLookupTable(String[] stringArray) {
        if (stringArray.length == this.getFieldCount()) {
            return;
        }
        String[] stringArray2 = this.getFieldTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getLookupForField(stringArray[i]) != null) continue;
            new Lookup(this, stringArray[i]);
        }
    }

    public long[] parseData(String string) {
        if (string.indexOf("*") == -1) {
            common.failure("Invalid data syntax: " + string);
        }
        String string2 = string.substring(0, string.indexOf("*"));
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = string.substring(string.indexOf("*") + 1);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
        if (stringTokenizer2.countTokens() != stringTokenizer.countTokens()) {
            common.ptod(string2);
            common.ptod(string3);
            common.failure("Unequal token count. Receiving more labels than expected");
        }
        long[] lArray = new long[stringTokenizer2.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer2.nextToken();
            if (this.getLookupForField(string4) == null) {
                common.failure("Lookup missing for new field: " + string4);
                continue;
            }
            int n = this.getIndexForField(string4);
            lArray[n] = Long.parseLong(string5);
        }
        return lArray;
    }

    public Lookup[] getSelectedLookups(String[] stringArray) {
        Lookup[] lookupArray = new Lookup[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lookupArray[i] = this.getLookupForField(stringArray[i]);
        }
        return lookupArray;
    }

    public static void main(String[] stringArray) {
    }
}

