/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.CommandOutput;
import Utils.Get_cmd_stream;
import Utils.Message;
import Utils.common;
import Vdb.Signal;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class OS_cmd {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private String command_line = "";
    private Vector stdout = new Vector(256, 0);
    protected CommandOutput output_method = null;
    private Vector stderr = new Vector(256, 0);
    private PrintWriter stdout_pw = null;
    private PrintWriter stderr_pw = null;
    private boolean ignore = false;
    protected Process lproc = null;
    private boolean wait = false;
    private boolean rc = false;
    protected boolean save_and_print = false;
    private boolean log_command = true;
    private boolean wait_later = false;
    protected boolean wait_for_jvm = false;
    private Get_cmd_stream error_stream;
    private Get_cmd_stream output_stream;
    private static Vector need_to_kill = new Vector(8, 0);
    public boolean killing = false;

    private void killAtEnd() {
        need_to_kill.add(this);
    }

    public void removeKillAtEnd() {
        if (!need_to_kill.remove(this)) {
            common.plog("removeKillAtEnd(): Unable to find " + this.getCmd());
        }
    }

    public static void killAll() {
        for (int i = 0; i < need_to_kill.size(); ++i) {
            OS_cmd oS_cmd = (OS_cmd)need_to_kill.elementAt(i);
            oS_cmd.killCommand();
        }
    }

    public void killCommand() {
        common.plog("killCommand: " + this.getCmd());
        this.killing = true;
        this.removeKillAtEnd();
        try {
            if (this.lproc != null) {
                this.lproc.destroy();
            }
            if (this.error_stream != null) {
                this.error_stream.interrupt();
            }
            if (this.output_stream != null) {
                this.output_stream.interrupt();
            }
        }
        catch (Exception exception) {
            common.ptod("Exception during killCommand: " + this.getCmd() + "; continuing");
            common.ptod(exception);
        }
    }

    public void add(String string, Object ... objectArray) {
        this.addText(String.format(string, objectArray));
    }

    public void addText(long l) {
        this.addText("" + l);
    }

    public void addText(String string) {
        this.command_line = this.command_line + string + " ";
    }

    public void addQuot(String string) {
        String string2 = "\"";
        if (!common.onWindows()) {
            this.command_line = this.command_line + string + " ";
            return;
        }
        if ((string = string.trim()).endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        this.command_line = string.indexOf(" ") == -1 ? this.command_line + string + " " : this.command_line + string2 + string + string2 + " ";
    }

    public void addFile(String string) {
        this.command_line = (string = string.trim()).indexOf(" ") == -1 ? this.command_line + string + " " : this.command_line + "{" + string + "}" + " ";
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public String[] getStdout() {
        return this.stdout.toArray(new String[0]);
    }

    public String[] getStderr() {
        return this.stderr.toArray(new String[0]);
    }

    public void printStdout() {
        for (int i = 0; i < this.stdout.size(); ++i) {
            Vdb.common.ptod("stdout: " + this.stdout.elementAt(i));
        }
    }

    public void printStderr() {
        for (int i = 0; i < this.stderr.size(); ++i) {
            Vdb.common.ptod("stderr: " + this.stderr.elementAt(i));
        }
    }

    public void setCmd(String string) {
        this.command_line = string;
    }

    public String getCmd() {
        return this.command_line;
    }

    public boolean getRC() {
        return this.rc;
    }

    public String getHttpCode() {
        for (String string : this.getStdout()) {
            if (!string.startsWith("HTTP/1.1 ")) continue;
            return string.substring(9);
        }
        return null;
    }

    public boolean isHttpOk() {
        for (String string : this.getStdout()) {
            if (!string.startsWith("HTTP/1.1") || !string.endsWith(" OK")) continue;
            return true;
        }
        return false;
    }

    public static OS_cmd execute(String string) {
        return OS_cmd.execute(string, true);
    }

    public static OS_cmd execute(String string, boolean bl) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.log_command = bl;
        oS_cmd.addText(string);
        oS_cmd.execute();
        return oS_cmd;
    }

    public static OS_cmd executeCmd(String string) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        oS_cmd.execute();
        return oS_cmd;
    }

    public boolean execute(boolean bl) {
        this.log_command = bl;
        return this.execute();
    }

    public boolean execute() {
        this.killAtEnd();
        this.command_line = this.command_line.trim();
        String[] stringArray = null;
        stringArray = common.onWindows() ? new String[]{"cmd", "/q /c", this.command_line} : (common.onSolaris() ? new String[]{"/bin/bash", "-c", this.command_line} : (common.onAix() ? this.command_line.split(" +") : new String[]{"/bin/bash", "-c", this.command_line}));
        if (this.log_command && this.command_line.indexOf("chmod") == -1) {
            Vdb.common.ptod("execute(): " + this.command_line);
        }
        this.lproc = null;
        try {
            if (common.onWindows()) {
                stringArray[2] = this.writeTempFile();
            }
            this.lproc = Runtime.getRuntime().exec(stringArray);
            this.error_stream = this.stderr_pw != null ? new Get_cmd_stream(this, this.lproc.getErrorStream(), "stderr", this.stderr_pw) : new Get_cmd_stream(this, this.lproc.getErrorStream(), "stderr", this.stderr);
            this.output_stream = this.stdout_pw != null ? new Get_cmd_stream(this, this.lproc.getInputStream(), "stdout", this.stdout_pw) : new Get_cmd_stream(this, this.lproc.getInputStream(), "stdout", this.stdout);
            this.error_stream.start();
            this.output_stream.start();
            if (this.wait_later || this.command_line.trim().endsWith("&")) {
                return true;
            }
            this.lproc.waitFor();
            this.rc = this.lproc.exitValue() == 0;
            Signal signal = new Signal(1000);
            while (this.output_stream.isAlive() && !this.command_line.trim().endsWith("&")) {
                common.sleep_some_no_int(2L);
                if (!this.output_stream.isAlive() || !signal.go()) continue;
                common.plog("Waiting for command1 '" + this.command_line + "' completion");
            }
            if (common.onWindows()) {
                new File(stringArray[2]).delete();
            }
        }
        catch (InterruptedException interruptedException) {
            common.ptod("InterruptedException, continuing: " + interruptedException);
            this.stderr.add("InterruptedException, continuing: " + Vdb.common.get_stacktrace(interruptedException));
            this.rc = false;
            this.removeKillAtEnd();
            return false;
        }
        catch (Exception exception) {
            for (int i = 0; this.stderr != null && i < this.stderr.size(); ++i) {
                String string = (String)this.stderr.elementAt(i);
                common.ptod("stderr: " + string);
            }
            if (this.ignore) {
                this.rc = false;
                this.removeKillAtEnd();
                common.ptod("Exception ignored.");
                return false;
            }
            common.ptod("Error occurred in os_command(3) " + this.command_line);
            exception.printStackTrace();
            if (this.command_line.indexOf("chmod") != -1) {
                common.ptod("chmod command failed; error ignored.");
            }
            common.ptod("InterruptedException, continuing: " + exception);
            this.stderr.add("InterruptedException, continuing: " + Vdb.common.get_stacktrace(exception));
            this.rc = false;
            this.removeKillAtEnd();
            common.ptod("Exception ignored.");
            return false;
        }
        if (!this.command_line.trim().endsWith("&")) {
            this.removeKillAtEnd();
        }
        return this.rc;
    }

    protected boolean isWindowsRsh() {
        if (!common.onWindows()) {
            return false;
        }
        return this.command_line.startsWith("rsh");
    }

    public void setStdout() {
        this.stdout = new Vector(256, 0);
    }

    public void setOutputMethod(CommandOutput commandOutput) {
        this.output_method = commandOutput;
    }

    public void setStdout(PrintWriter printWriter) {
        this.stdout_pw = printWriter;
    }

    public void setStderr() {
        this.stderr = new Vector(256, 0);
    }

    public void setStderr(PrintWriter printWriter) {
        this.stderr_pw = printWriter;
    }

    public void setWaitForJvm() {
        this.wait_for_jvm = true;
    }

    public void setNoWait() {
        this.wait_later = true;
    }

    public boolean waitFor() {
        long l = System.currentTimeMillis();
        if (!this.wait_later) {
            common.failure("OS_cmd.waitFor(): Waiting for command that is already done. Oops");
        }
        while (this.output_stream.isAlive()) {
            common.sleep_some_no_int(50L);
            if (!this.output_stream.isAlive() || System.currentTimeMillis() - l <= 5000L) continue;
            common.ptod("OS_cmd.waitFor(); waiting for command: " + this.command_line);
            l = System.currentTimeMillis();
        }
        try {
            this.lproc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rc = this.lproc.exitValue() == 0;
        return this.rc;
    }

    public void setSaveAndPrint() {
        this.save_and_print = true;
    }

    public static boolean cancel_run(String string, String string2) {
        File file = new File(string, "cancel_run");
        if (!file.delete()) {
            Message.infoMsg(string2 + " cancel requested failed. " + "Do you have write access to the trace directory?\n" + "Or is the trace not far along enough yet to recognize this request?");
            return false;
        }
        Message.infoMsg(string2 + " cancel requested by user.\n" + "Run will terminate within 10 seconds.");
        return true;
    }

    public static String getWindowsSystemDrive() {
        String string = "C:\\";
        OS_cmd oS_cmd = OS_cmd.execute("echo %systemdrive%");
        if (oS_cmd.getRC()) {
            string = oS_cmd.getStdout()[0] + "\\";
        }
        return string;
    }

    private String writeTempFile() {
        File file = null;
        try {
            try {
                file = File.createTempFile("vdb", ".bat");
            }
            catch (IOException iOException) {
                common.ptod("Unable to create temporary 'bat' file for windows. ");
                common.failure(iOException);
            }
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(fileOutputStream));
            printWriter.print(this.command_line);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            common.failure(fileNotFoundException);
        }
        return file.getAbsolutePath();
    }

    public static String getShutdownMessage() {
        return "JVM is shutting down";
    }

    public boolean stillRunning() {
        return this.output_stream.isAlive();
    }

    public static void main(String[] stringArray) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("nicstat 1 10");
        oS_cmd.setNoWait();
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                common.ptod("type: " + string2 + " " + string);
                return true;
            }
        });
        oS_cmd.execute();
        common.sleep_some_no_int(3000L);
        oS_cmd.killCommand();
    }
}

