/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Fput;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class common {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private static PrintWriter ptod_output = new PrintWriter(System.out, false);
    private static PrintWriter log_html = null;
    private static boolean[] debug_flags = new boolean[256];
    public static Object ptod_lock = new Object();
    private static DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    static byte[] spare_memory = new byte[0x400000];
    static Object failure_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod() {
        Object object = ptod_lock;
        synchronized (object) {
            if (log_html != null) {
                log_html.println();
            }
            ptod_output.println(common.tod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(PrintWriter printWriter) {
        Object object = ptod_lock;
        synchronized (object) {
            if (log_html != null) {
                log_html.println();
            }
            printWriter.println(common.tod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(Exception exception) {
        Object object = ptod_lock;
        synchronized (object) {
            common.ptod(exception.getClass().getName());
            if (log_html != null) {
                exception.printStackTrace(log_html);
            }
            exception.printStackTrace(ptod_output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptod(String string) {
        Object object = ptod_lock;
        synchronized (object) {
            if (log_html != null) {
                log_html.println(common.tod() + " " + string);
            }
            ptod_output.println(common.tod() + " " + string);
        }
    }

    public static String tod() {
        return df.format(new Date());
    }

    public static void setPlog(PrintWriter printWriter) {
        log_html = printWriter;
    }

    public static synchronized void plog(String string) {
        if (log_html != null) {
            log_html.println(common.tod() + " " + string);
            log_html.flush();
        } else {
            common.ptod("plog(): " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failure(Exception exception) {
        Object object = failure_lock;
        synchronized (object) {
            if (spare_memory != null) {
                spare_memory = null;
            } else {
                common.ptod("common.failure(): System.exit(-99)");
                System.exit(-99);
            }
            System.err.println();
            System.err.println("Abort requested: " + exception.getClass().getName() + " " + exception.getMessage());
            common.ptod("common.failure():");
            exception.printStackTrace();
            if (log_html != null) {
                exception.printStackTrace(log_html);
            }
            Fput.closeAll();
            common.ptod("common.failure(): System.exit(-98)");
            System.exit(-98);
        }
    }

    public static void failure(String string, Object ... objectArray) {
        common.failure(String.format(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failure(String string) {
        Object object = failure_lock;
        synchronized (object) {
            if (spare_memory != null) {
                spare_memory = null;
            } else {
                common.ptod("common.failure(): Recursive call. System.exit(-97)");
                System.exit(-97);
            }
            System.err.println();
            System.err.println("Abort requested: " + string);
            common.ptod("common.failure():");
            RuntimeException runtimeException = new RuntimeException(string);
            runtimeException.printStackTrace();
            if (log_html != null) {
                runtimeException.printStackTrace(log_html);
            }
            Fput.closeAll();
            common.ptod("common.failure(): System.exit(-96)");
            System.exit(-96);
        }
    }

    static Vector assertit(Vector vector) {
        return (Vector)common.assertit((Object)vector);
    }

    static Object assertit(Object object) {
        if (object == null) {
            int n = 1;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string = stackTraceElementArray[n].toString();
            if (string.indexOf("(") < string.lastIndexOf(")")) {
                string = string.substring(string.indexOf("(") + 1, string.lastIndexOf(")"));
            }
            common.failure("Assert failed at " + string);
        }
        return object;
    }

    public static boolean onLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean onSolaris() {
        return System.getProperty("os.name").toLowerCase().startsWith("sunos") || System.getProperty("os.name").toLowerCase().startsWith("solaris");
    }

    static boolean onAix() {
        return System.getProperty("os.name").toLowerCase().startsWith("aix");
    }

    public static String replace(String string, String string2, char c) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string.charAt(i) == c ? string3 + string2 : string3 + string.charAt(i);
        }
        return string3;
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        int n2 = -1;
        while (string.indexOf(string2) != -1 && (n = string.indexOf(string2)) != n2) {
            n2 = n;
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static void serial_out(String string, Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public static Object serial_in(String string) {
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace(log_html);
            exception.printStackTrace();
            return null;
        }
        return object;
    }

    public static void sleep_some_no_int(long l) {
        try {
            common.sleep_some(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep_some(long l) throws InterruptedException {
        if (l == 0L) {
            return;
        }
        common.sleep_some_usecs(l * 1000L);
    }

    public static void sleep_some_usecs(long l) throws InterruptedException {
        try {
            Thread.sleep(l / 1000L, (int)(l % 1000L) * 1000);
        }
        catch (InterruptedException interruptedException) {
            common.ptod("Interrupted in common.sleep()");
            throw new InterruptedException();
        }
    }

    static void where(int n, String string) {
        int n2 = 0;
        ++n;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 2; i < n && i < stackTraceElementArray.length; ++i) {
            String string2 = n2++ == 0 ? "==> where: " : "           ";
            string2 = string2 + stackTraceElementArray[i].toString() + (string != null ? ": " + string : "");
            common.ptod(string2);
        }
    }

    public static void where() {
        common.where(2, null);
    }

    public static void where(int n) {
        common.where(n, null);
    }

    public static void where(String string) {
        common.where(2, string);
    }

    public static void set_debug(int n) {
        if (n >= debug_flags.length) {
            common.failure("Requested debug flag setting too large: " + n);
        }
        common.debug_flags[n] = true;
    }

    public static boolean get_debug(int n) {
        return debug_flags[n];
    }

    public static String get_debug_string() {
        String string = " ";
        for (int i = 0; i < debug_flags.length; ++i) {
            if (!debug_flags[i]) continue;
            string = string + "-d" + i + " ";
        }
        return string;
    }
}

