/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.Errno;
import Vdb.ErrorLog;
import Vdb.FileAnchor;
import Vdb.FileEntry;
import Vdb.File_handles;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.HelpDebug;
import Vdb.KeyMap;
import Vdb.Native;
import Vdb.OpenFlags;
import Vdb.Operations;
import Vdb.SlaveWorker;
import Vdb.Timestamp;
import Vdb.Validate;
import Vdb.common;
import java.io.File;
import java.util.HashMap;
import java.util.Random;

class ActiveFile {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private FileEntry fe = null;
    private FileAnchor anchor = null;
    private FwgEntry active_fwg = null;
    private FwgThread calling_thread = null;
    private FwdStats active_stats = null;
    public int xfersize = 0;
    private int prev_xfer = 0;
    public long next_lba = 0L;
    private long file_start_lba = 0L;
    private long fhandle = 0L;
    private long high_write_lba = 0L;
    private long blocks_done = 0L;
    private long bytes_done = 0L;
    private long bytes_to_do = Long.MAX_VALUE;
    private long blocks_to_do = Long.MAX_VALUE;
    public boolean done_enough = false;
    private long native_read_buffer = 0L;
    private long native_write_buffer = 0L;
    private String full_name = null;
    private KeyMap key_map = null;
    private boolean open_for_read;
    private int data_flag;
    private static Random seek_rand = new Random();
    private static boolean print_open_flags = common.get_debug(common.PRINT_OPEN_FLAGS);
    private static boolean print_file_io = common.get_debug(common.PRINT_FILE_IO);

    public ActiveFile(FileEntry fileEntry, FwgEntry fwgEntry, long l, long l2) {
        this.fe = fileEntry;
        this.anchor = this.fe.getAnchor();
        this.active_fwg = fwgEntry;
        this.calling_thread = (FwgThread)Thread.currentThread();
        this.active_stats = this.calling_thread.per_thread_stats;
        this.full_name = this.fe.getFullName();
        this.file_start_lba = this.fe.getFileStartLba();
        this.native_read_buffer = l;
        this.native_write_buffer = l2;
        this.xfersize = 0;
        this.prev_xfer = 0;
        this.next_lba = 0L;
        this.blocks_done = 0L;
        this.bytes_done = 0L;
        this.data_flag = Validate.createDataFlag();
        if (!SlaveWorker.work.format_run) {
            if (fwgEntry.stopafter == Long.MAX_VALUE) {
                this.bytes_to_do = this.fe.getReqSize();
                this.blocks_to_do = fwgEntry.stopafter;
            } else if (fwgEntry.stopafter < 0L) {
                this.bytes_to_do = this.fe.getReqSize() * (fwgEntry.stopafter * -1L) / 100L;
            } else if (fwgEntry.stopafter > 0L) {
                this.blocks_to_do = fwgEntry.stopafter;
            }
        }
    }

    public FileEntry getFileEntry() {
        return this.fe;
    }

    public KeyMap getKeyMap() {
        return this.key_map;
    }

    public FwgEntry getFwg() {
        return this.active_fwg;
    }

    public long getHandle() {
        return this.fhandle;
    }

    public FileAnchor getAnchor() {
        return this.anchor;
    }

    protected void openFile(boolean bl) {
        int n;
        File file;
        this.open_for_read = bl;
        if (this.fhandle != 0L) {
            common.failure("openfile(): Trying to open file that is already open: %s", this.full_name);
        }
        if (!this.fe.isBusy()) {
            common.failure("openfile(): Trying to open file that is not marked busy: %s", this.full_name);
        }
        if (this.open_for_read && (file = new File(this.full_name)).exists() && file.length() != this.fe.getCurrentSize()) {
            common.ptod("openFile(): invalid file size. Expected: " + FileAnchor.whatSize(this.fe.getCurrentSize()) + "; found: " + FileAnchor.whatSize(new File(this.full_name).length()));
        }
        if (print_open_flags) {
            common.ptod("openFile flags: %s read: %-5b %s", this.active_fwg.open_flags, bl, this.full_name);
        }
        if ((this.fhandle = Native.openFile(this.full_name, this.active_fwg.open_flags, bl ? 0 : 1)) < 0L) {
            Native.printMemoryUsage();
            if (common.get_debug(common.DIRECTORY_CREATED)) {
                this.anchor.printFileStatus();
            }
            common.failure("open failed for " + this.full_name);
        }
        if (this.fe.getCurrentSize() > 0L && this.active_fwg.open_flags.isOther(OpenFlags.SOL_CLEAR_CACHE) && (n = Native.eraseFileSystemCache(this.fhandle, this.fe.getCurrentSize())) != 0) {
            common.failure("Native.eraseFileSystemCache() failed: " + n);
        }
        this.key_map = Validate.isRealValidate() || Dedup.isDedup() ? this.anchor.allocateKeyMap(this.file_start_lba) : new KeyMap();
        this.fe.setOpened();
        File_handles.addHandle(this.fhandle, this);
        if (!SlaveWorker.work.format_run && this.active_fwg.sequential_io && this.active_fwg.stopafter != Long.MAX_VALUE) {
            this.next_lba = this.fe.getCurrentSize() != this.fe.getReqSize() ? (!bl ? this.fe.getCurrentSize() : (this.fe.getLastLba() < this.fe.getCurrentSize() ? this.fe.getLastLba() : 0L)) : (this.fe.getLastLba() >= this.fe.getCurrentSize() ? 0L : this.fe.getLastLba());
        }
        if (this.fe.getCurrentSize() == this.fe.getReqSize() && this.active_fwg.sequential_io && !this.active_fwg.seq_io_start0) {
            this.xfersize = this.active_fwg.getXferSize();
            if (!this.setNextRandomLba()) {
                this.next_lba = 0L;
            }
        }
    }

    public static void conditionalCloseFile(ActiveFile activeFile) {
        if (activeFile == null) {
            return;
        }
        if (activeFile.fhandle != 0L) {
            activeFile.closeFile();
        }
    }

    public ActiveFile closeFile() {
        return this.closeFile(false);
    }

    public ActiveFile closeFile(boolean bl) {
        if (this.fhandle == 0L) {
            common.failure("closing handle for a file that is not open: " + this.full_name);
        }
        File_handles.remove(this.fhandle);
        if (print_open_flags) {
            common.ptod("closeFile flags: %s %s", this.active_fwg.open_flags, this.full_name);
        }
        long l = Native.get_simple_tod();
        long l2 = Native.closeFile(this.fhandle, this.active_fwg.open_flags);
        if (l2 != 0L) {
            this.fileError("close failure", l2);
        }
        this.active_fwg.blocked.count(Blocked.FILE_CLOSES);
        FwdStats.count(Operations.CLOSE, l);
        this.fhandle = 0L;
        this.fe.setCurrentSize(new File(this.full_name).length());
        if (!this.fe.exists()) {
            this.fe.setExists(true);
            this.fe.getParent().countFiles(1, this.fe);
            this.anchor.countExistingFiles(1, this.fe);
            this.active_fwg.blocked.count(Blocked.FILE_CREATES);
        }
        this.fe.setLastLba(this.next_lba + (long)this.xfersize);
        if (bl) {
            this.fe.deleteFile(this.active_fwg);
        }
        this.fe.setUnBusy();
        return null;
    }

    public boolean setNextSequentialRead() {
        return this.setNextSequentialLba(true);
    }

    public boolean setNextSequentialWrite() {
        return this.setNextSequentialLba(false);
    }

    private boolean setNextSequentialLba(boolean bl) {
        block5: {
            long l = bl ? this.fe.getCurrentSize() : this.fe.getReqSize();
            while (true) {
                this.next_lba += (long)this.prev_xfer;
                if (!this.doesBlockOrShorterBlockFit()) {
                    if (this.fe.pending_writes) {
                        this.fe.pending_writes = false;
                    }
                    return false;
                }
                if (this.next_lba >= l) {
                    return false;
                }
                this.prev_xfer = this.xfersize;
                if (this.key_map.storeDataBlockInfo(this.next_lba, this.xfersize, this.anchor.getDVMap())) {
                    this.calling_thread.block(Blocked.SKIP_BAD_BLOCKS);
                    continue;
                }
                if (!this.fe.pending_writes) break block5;
                HashMap<Long, Long> hashMap = this.anchor.pending_file_lba_map.get(this.fe);
                if (hashMap.get(this.next_lba) != null) break;
            }
            ErrorLog.plog("Verify pending write for %s lba 0x%08x", this.full_name, this.next_lba);
        }
        return true;
    }

    public boolean setNextRandomLba() {
        long l = this.open_for_read ? this.fe.getCurrentSize() : this.fe.getReqSize();
        int n = 0;
        if ((long)this.xfersize > l) {
            this.next_lba = 0L;
            this.doesBlockOrShorterBlockFit();
            if (this.key_map.storeDataBlockInfo(this.next_lba, this.xfersize, this.anchor.getDVMap())) {
                this.calling_thread.block(Blocked.SKIP_BAD_BLOCKS);
                return false;
            }
            return true;
        }
        while (true) {
            if (n++ > 100) {
                this.calling_thread.block(Blocked.SKIP_BAD_FILE);
                return false;
            }
            long l2 = l / (long)this.xfersize;
            l2 = (long)((double)l2 * seek_rand.nextDouble());
            this.next_lba = l2 * (long)this.xfersize;
            if (this.next_lba < 0L) {
                common.failure("setNextRandomLba(): negative lba: " + this.next_lba + " " + l + " " + this.xfersize + " " + n);
            }
            this.doesBlockOrShorterBlockFit();
            if (!this.key_map.storeDataBlockInfo(this.next_lba, this.xfersize, this.anchor.getDVMap())) {
                return true;
            }
            this.calling_thread.block(Blocked.SKIP_BAD_BLOCKS);
        }
    }

    private boolean doesBlockOrShorterBlockFit() {
        long l;
        long l2 = l = this.open_for_read ? this.fe.getCurrentSize() : this.fe.getReqSize();
        if (this.next_lba + (long)this.xfersize >= l) {
            this.xfersize = (int)(l - this.next_lba);
        }
        return this.xfersize != 0;
    }

    protected void writeBlock() {
        if (this.native_write_buffer == 0L) {
            common.failure("No write buffer available");
        }
        if (this.xfersize == 0) {
            common.failure("zero xfersize for %s %d %d %d", this.full_name, this.fe.getFileStartLba(), this.next_lba, this.fe.getCurrentSize());
        }
        if (HelpDebug.doAfterCount("simulate_fsd_write_error")) {
            this.fileError("Debugging forced error", 7777L);
            return;
        }
        this.high_write_lba = Math.max(this.high_write_lba, this.next_lba + (long)this.xfersize);
        if (Validate.isRealValidate() || Validate.isValidateForDedup()) {
            if (!Validate.isNoPreRead() && this.key_map.anyDataToCompare() && this.next_lba + (long)this.xfersize < this.fe.getCurrentSize()) {
                this.readAndValidate(Validate.FLAG_PRE_READ);
                this.key_map.saveCurrentTod(Timestamp.PRE_READ);
            }
            long l = this.dataValidationWrite();
            this.key_map.saveTimestamp(Timestamp.WRITE, l);
            this.key_map.saveWriteXfer(this.xfersize);
            if (Validate.isImmediateRead() && !this.key_map.badDataBlock()) {
                this.readAndValidate(Validate.FLAG_READ_IMMEDIATE);
                this.key_map.saveCurrentTod(Timestamp.READ_IMMED);
            }
        } else if (Validate.isCompression()) {
            this.writeWithPattern();
        } else {
            long l = Native.get_simple_tod();
            long l2 = Native.noDedupAndWrite(this.fhandle, this.next_lba, this.xfersize, this.native_write_buffer, -1);
            FwdStats.countXfer(Operations.WRITE, l, this.xfersize);
            ++this.blocks_done;
            this.bytes_done += (long)this.xfersize;
            if (l2 != 0L) {
                this.fileError("Write error", l2);
                return;
            }
        }
        if (print_file_io) {
            common.ptod("writeBlock: %12d %7d %s", this.next_lba, this.xfersize, this.fe.getFullName());
        }
    }

    private long writeWithPattern() {
        if (Dedup.isDedup()) {
            this.anchor.dedup.dedupFsdBlock(this);
        } else if (Validate.isCompression()) {
            this.key_map.setFsdCompressionOnlyOffset(this);
        }
        if (this.key_map.pattern_length == 0) {
            common.failure("zero pattern length");
        }
        int n = HelpDebug.doAfterCount("failWrite") ? Validate.FLAG_FAIL_WRITE : 0;
        long l = Native.get_simple_tod();
        long l2 = Validate.isRealValidate() ? System.currentTimeMillis() : 0L;
        long l3 = Native.multiKeyFillAndWriteBlock(this.fhandle, l2, this.data_flag | n, this.file_start_lba, this.next_lba, this.xfersize, this.key_map.pattern_lba, this.key_map.pattern_length, this.native_write_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), this.anchor.fsd_name_8bytes, -1);
        if (l3 != 0L) {
            this.fileError("Write error", l3);
            return 0L;
        }
        if (HelpDebug.doAfterCount("corruptAfterWrite")) {
            common.ptod("next_lba: %08x", this.next_lba);
            HelpDebug.corruptBlock(this.fhandle, this.xfersize, this.next_lba);
            common.failure("corruptAfterWrite");
        }
        if (this.anchor.dedup != null) {
            this.anchor.dedup.countDedup(this.key_map, this.anchor.getValidationMap());
        }
        FwdStats.countXfer(Operations.WRITE, l, this.xfersize);
        ++this.blocks_done;
        this.bytes_done += (long)this.xfersize;
        return l2;
    }

    private void obsolete_writeBuffer() {
        long l = Native.get_simple_tod();
        common.failure("This should be obsolete");
        long l2 = Native.noDedupAndWrite(this.fhandle, this.next_lba, this.xfersize, this.native_write_buffer, -1);
        FwdStats.countXfer(Operations.WRITE, l, this.xfersize);
        ++this.blocks_done;
        this.bytes_done += (long)this.xfersize;
        if (l2 != 0L) {
            this.fileError("WriteBuffer error", l2);
        }
    }

    private void readAndValidate(int n) {
        if (Dedup.isDedup()) {
            this.anchor.dedup.dedupFsdBlock(this);
        } else if (Validate.isCompression()) {
            this.key_map.setFsdCompressionOnlyOffset(this);
        }
        if (this.native_read_buffer == 0L) {
            common.failure("Read buffer is missing");
        }
        long l = Native.get_simple_tod();
        long l2 = Native.multiKeyReadAndValidateBlock(this.fhandle, this.data_flag | n, this.file_start_lba, this.next_lba, this.xfersize, this.native_read_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), this.anchor.fsd_name_8bytes, -1);
        if (l2 == 60003L && n == Validate.FLAG_PENDING_READ) {
            int n2;
            DV_map dV_map = this.anchor.getValidationMap();
            Byte by = dV_map.journal.before_map.pending_map.get(this.file_start_lba + this.next_lba);
            if (by == null) {
                common.failure("Invalid pending map state");
            }
            if ((n2 = by & 0xFF) == 132) {
                if (this.key_map.storeDataBlockInfo(this.next_lba, this.xfersize, this.anchor.getDVMap())) {
                    common.failure("Block should not be in error");
                }
                ErrorLog.plog("Re-checking file %s lba 0x%08x because of PENDING_KEY_REREAD", this.full_name, this.next_lba);
                if (HelpDebug.doAfterCount("corruptAfterPendingRead")) {
                    HelpDebug.corruptBlock(this.fhandle, this.xfersize, this.next_lba);
                }
                if ((l2 = Native.multiKeyReadAndValidateBlock(this.fhandle, this.data_flag | Validate.FLAG_PENDING_REREAD, this.file_start_lba, this.next_lba, this.xfersize, this.native_read_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), this.anchor.fsd_name_8bytes, -1)) == 0L) {
                    ErrorLog.plog("Re-checking file %s lba 0x%08x successful", this.full_name, this.next_lba);
                }
            }
        }
        FwdStats.countXfer(Operations.READ, l, this.xfersize);
        this.key_map.countFileReadAndValidates(this.fe, this.next_lba);
        if (HelpDebug.doAfterCount("forceFsdCorruptions")) {
            HelpDebug.forceFsdCorruptions(this.fhandle, this.data_flag | n, this.file_start_lba, this.next_lba, this.xfersize, this.native_read_buffer, this.active_fwg.getMaxXfersize(), this.key_map, this.anchor.fsd_name_8bytes);
        }
        if (l2 != 0L && l2 != 60003L) {
            this.fileError("readAndValidate error", l2);
        }
    }

    private long dataValidationWrite() {
        long l;
        if (Dedup.isDedup()) {
            this.anchor.dedup.dedupFsdBlock(this);
        }
        if ((Validate.isRealValidate() || Validate.isValidateForDedup()) && !this.key_map.incrementKeys()) {
            this.calling_thread.block(Blocked.SKIP_WRITE);
            return 0L;
        }
        if (Validate.isJournaling()) {
            this.key_map.writeBeforeJournalImage();
        }
        if ((l = this.writeWithPattern()) == 0L) {
            return 0L;
        }
        if (Validate.isJournaling()) {
            this.key_map.writeAfterJournalImage();
        }
        this.key_map.countFileWrites(this.fe, this.next_lba);
        this.key_map.storeKeys();
        return l;
    }

    private void fileError(String string, long l) {
        String string2 = "";
        string2 = string2 + string + " using file " + this.full_name;
        string2 = string2 + "\nError:         " + Errno.xlate_errno(l);
        string2 = string2 + "\nlba:           " + this.next_lba;
        string2 = string2 + "\nxfersize:      " + this.xfersize;
        string2 = string2 + "\nblocks_done:   " + this.blocks_done;
        string2 = string2 + "\nbytes_done:    " + this.bytes_done;
        string2 = string2 + "\nopen_for_read: " + this.open_for_read;
        string2 = string2 + "\nfhandle:       " + this.fhandle;
        common.ptod(string2);
        ErrorLog.ptod(string2, new Object[0]);
        common.sleep_some(100L);
        ErrorLog.countErrorsOnSlave(1);
    }

    protected void readBlock() {
        if (this.native_read_buffer == 0L) {
            common.failure("No read buffer available");
        }
        if (this.next_lba + (long)this.xfersize > this.fe.getCurrentSize() && this.next_lba + (long)this.xfersize > this.high_write_lba) {
            common.failure("Trying to read beyond EOF: %s 0x%08x (%d) %d %d", this.full_name, this.next_lba, this.next_lba, this.fe.getCurrentSize(), this.fe.getReqSize());
        }
        if (Validate.isRealValidate()) {
            if (this.fe.pending_writes) {
                this.readAndValidate(Validate.FLAG_PENDING_READ);
            } else {
                this.readAndValidate(Validate.FLAG_NORMAL_READ);
            }
            this.key_map.saveCurrentTod(Timestamp.READ_ONLY);
        } else {
            long l = Native.get_simple_tod();
            long l2 = Native.readFile(this.fhandle, this.next_lba, this.xfersize, this.native_read_buffer);
            FwdStats.countXfer(Operations.READ, l, this.xfersize);
            if (l2 != 0L) {
                this.fileError("Read error", l2);
            }
        }
        if (print_file_io) {
            common.ptod("readBlock:  %12d %7d %s", this.next_lba, this.xfersize, this.fe.getFullName());
        }
        ++this.blocks_done;
        this.bytes_done += (long)this.xfersize;
    }

    public void checkEnough() {
        if (this.bytes_done >= this.bytes_to_do) {
            this.done_enough = true;
        } else if (this.blocks_done >= this.blocks_to_do) {
            this.done_enough = true;
        }
    }
}

