/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.OS_cmd;
import Vdb.MiscParms;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.common;
import java.io.File;
import java.util.Vector;

class Adm_msgs
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String logname;
    private long last_changed_time;
    private int next_line_number;
    private static int message_count = 0;
    private static boolean valid_file = false;
    public static Thread adm_thread = null;
    private static String var_msgs;
    private static String var_msgs0;
    private static int sleep_time;
    private static boolean already_checked;
    private static boolean display;
    private static boolean scan;
    private static int max_messages;

    public Adm_msgs() {
        this.setName("Adm_msgs");
    }

    public Adm_msgs(String string) {
        this.logname = string;
        this.last_changed_time = new File(this.logname).lastModified();
        if (!new File(string).exists()) {
            common.ptod("File '" + string + "' does not exist. Monitoring bypassed");
            return;
        }
        if (new File(this.logname).canRead()) {
            Fget fget = new Fget(this.logname);
            while (fget.get() != null) {
                ++this.next_line_number;
            }
            fget.close();
            valid_file = true;
        }
    }

    public static void terminate() {
        if (adm_thread != null) {
            common.interruptThread(adm_thread);
        }
    }

    @Override
    public void run() {
        adm_thread = Thread.currentThread();
        try {
            Adm_msgs adm_msgs = new Adm_msgs(var_msgs);
            Adm_msgs adm_msgs2 = new Adm_msgs(var_msgs0);
            while (true) {
                common.sleep_some(sleep_time);
                if (!Thread.interrupted()) {
                    if (message_count > Adm_msgs.getMaxCount()) {
                        Vector<String> vector = new Vector<String>(8);
                        vector.add("*");
                        vector.add("*");
                        vector.add(String.format("* Maximum of %d %s messages reported. Shutting down scan.", Adm_msgs.getMaxCount(), var_msgs));
                        vector.add("*");
                        vector.add("* This maximum count can be overriden using 'messagescan=12345'");
                        vector.add("*");
                        SlaveJvm.sendMessageToConsole(vector);
                        return;
                    }
                    if (valid_file && adm_msgs2.has_file_changed()) {
                        adm_msgs2.next_line_number = adm_msgs.next_line_number;
                        adm_msgs2.report_new_lines(adm_msgs.next_line_number);
                        adm_msgs.report_new_lines(0);
                        continue;
                    }
                    if (!valid_file || !adm_msgs.has_file_changed()) continue;
                    adm_msgs.report_new_lines(adm_msgs.next_line_number);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    private void report_new_lines(int n) {
        String string = null;
        boolean bl = false;
        Vector<String> vector = new Vector<String>(16, 0);
        Fget fget = new Fget(this.logname);
        int n2 = 0;
        while ((string = fget.get()) != null) {
            if (n2++ < n) continue;
            if (!bl) {
                vector.add("New messages found on /var/adm/messages. Do they belong to you?");
                bl = true;
            }
            vector.add(this.logname + ": " + string);
            ++message_count;
        }
        fget.close();
        if (bl) {
            vector.add("");
        }
        this.next_line_number = n2;
        if (Adm_msgs.displayMessages()) {
            SlaveJvm.sendMessageToConsole(vector);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                common.ptod(vector.elementAt(i));
            }
        }
    }

    private boolean has_file_changed() {
        long l = new File(this.logname).lastModified();
        if (l == 0L) {
            return false;
        }
        if (l != this.last_changed_time) {
            this.last_changed_time = l;
            return true;
        }
        return false;
    }

    public static void copy_varadmmsgs() {
        int n;
        if (!SlaveWorker.isAdmRunning()) {
            return;
        }
        if (!common.onSolaris() && !common.onLinux()) {
            return;
        }
        if (!new File(var_msgs).exists() && !new File(var_msgs0).exists()) {
            return;
        }
        String string = "cat ";
        Vector<String> vector = new Vector<String>(500, 0);
        if (Fget.file_exists(var_msgs0)) {
            string = string + var_msgs0;
        }
        if (Fget.file_exists(var_msgs)) {
            string = string + " " + var_msgs;
        }
        string = string + " | tail -500";
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        oS_cmd.execute(false);
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        vector.add("Last 500 lines of " + var_msgs0 + " and " + var_msgs);
        vector.add("command used: " + string);
        vector.add("");
        for (n = 0; n < stringArray2.length; ++n) {
            vector.add("stderr: " + stringArray2[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        SlaveJvm.sendMessageToMaster(SocketMessage.ADM_MESSAGES, vector);
    }

    public static boolean displayMessages() {
        if (!already_checked) {
            already_checked = Adm_msgs.parseMessageOptions();
        }
        return display;
    }

    public static boolean scanMessages() {
        if (!already_checked) {
            already_checked = Adm_msgs.parseMessageOptions();
        }
        return scan;
    }

    public static int getMaxCount() {
        return max_messages;
    }

    public static boolean parseMessageOptions() {
        for (String[] stringArray : MiscParms.getMiscellaneous()) {
            if (!stringArray[0].equals("messagescan")) continue;
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2;
                String string = stringArray[i];
                for (String string2 : stringArray2 = string.trim().split("=")) {
                    if (string2.equals("nodisplay")) {
                        display = false;
                    }
                    if (string2.equals("no")) {
                        scan = false;
                    }
                    if (!common.isNumeric(string2)) continue;
                    max_messages = Integer.parseInt(string2);
                }
            }
        }
        return true;
    }

    static {
        sleep_time = 5000;
        if (common.onSolaris()) {
            var_msgs = "/var/adm/messages";
            var_msgs0 = "/var/adm/messages.0";
        } else if (common.onLinux()) {
            var_msgs = "/var/log/messages";
            var_msgs0 = "/var/log/messages.1";
        }
        already_checked = false;
        display = true;
        scan = true;
        max_messages = 1000;
    }
}

