/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.printf;
import Vdb.FileAnchor;
import Vdb.Report;
import Vdb.SlaveJvm;
import Vdb.SocketMessage;
import java.io.Serializable;
import java.util.Vector;

public class AnchorReport
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String name;
    private long files;
    private long dirs;
    private long size;
    private long total_files;
    private long total_dirs;
    private long total_size;
    private long wss_files;
    private long wss_dirs;
    private long wss_size;
    private long now_files;
    private long now_dirs;
    private long now_size;
    private long files_opened;
    private long size_opened;
    private static String anchor_mask;
    private static Report anchor_report;

    public AnchorReport(String string, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14) {
        this.name = string;
        this.files = l;
        this.dirs = l2;
        this.size = l3;
        this.total_files = l4;
        this.total_dirs = l5;
        this.total_size = l6;
        this.wss_files = l7;
        this.wss_dirs = l8;
        this.wss_size = l9;
        this.now_files = l10;
        this.now_dirs = l11;
        this.now_size = l12;
        this.files_opened = l13;
        this.size_opened = l14;
        SlaveJvm.sendMessageToMaster(SocketMessage.ANCHOR_SIZES, this);
    }

    public synchronized void printNumbers() {
        printf printf2 = new printf(anchor_mask + "%8d %8d %6s %8d %8d %6s %8d %8d %6s %8d %8d %6s %8d %6s");
        printf2.add(this.name);
        printf2.add(this.files);
        printf2.add(this.dirs);
        printf2.add(FileAnchor.whatSize1(this.size));
        printf2.add(this.total_files);
        printf2.add(this.total_dirs);
        printf2.add(FileAnchor.whatSize1(this.total_size));
        printf2.add(this.wss_files);
        printf2.add(this.wss_dirs);
        printf2.add(FileAnchor.whatSize1(this.wss_size));
        printf2.add(this.now_files);
        printf2.add(this.now_dirs);
        printf2.add(FileAnchor.whatSize1(this.now_size));
        printf2.add(this.files_opened);
        printf2.add(FileAnchor.whatSize1(this.size_opened));
        anchor_report.println(printf2.print());
    }

    public static Report create() {
        anchor_report = new Report("anchors", "Anchor status report");
        Report.getSummaryReport().printHtmlLink("Link to anchor report", anchor_report.getFileName(), "anchors");
        anchor_report.println("(This report will not contain useful info when the 'shared=yes' FSD parameter is used)\n");
        AnchorReport.setMaxAnchorMask();
        printf printf2 = new printf(anchor_mask + "   %-24s %-24s %-24s %-24s %-24s ");
        printf2.add("");
        printf2.add("......Anchor size....");
        printf2.add("......Total size.....");
        printf2.add("......Workingset.....");
        printf2.add("....Existing ........");
        printf2.add("...Opened...");
        anchor_report.println(printf2.print());
        printf2 = new printf(anchor_mask + "%8s %8s %6s %8s %8s %6s %8s %8s %6s %8s %8s %6s %8s %6s");
        printf2.add("");
        printf2.add("files");
        printf2.add("dirs");
        printf2.add("bytes");
        printf2.add("files");
        printf2.add("dirs");
        printf2.add("bytes");
        printf2.add("files");
        printf2.add("dirs");
        printf2.add("bytes");
        printf2.add("files");
        printf2.add("dirs");
        printf2.add("bytes");
        printf2.add("files");
        printf2.add("bytes");
        anchor_report.println(printf2.print());
        anchor_report.println("");
        return anchor_report;
    }

    private static void setMaxAnchorMask() {
        Vector<FileAnchor> vector = FileAnchor.getAnchorList();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            FileAnchor fileAnchor = vector.elementAt(i);
            n = Math.max(n, fileAnchor.getAnchorName().length());
        }
        anchor_mask = "%-" + n + "s ";
    }
}

