/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Vdb.AuxReport;
import Vdb.common;
import java.util.ArrayList;

public class Arcstats
extends AuxReport {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String[] parms = null;
    private String arc_file = null;
    private double requested_rate = 0.0;
    private int duration = 0;
    private boolean warmup_done = false;
    private ArcstatsData old_data = null;
    private ArcstatsData new_data = null;
    private ArrayList<ArcstatsData> history = new ArrayList(16);
    private static long hits = 0L;
    private static long misses = 0L;

    @Override
    public void parseParameters(String[] stringArray) {
        this.parms = stringArray;
        if (stringArray.length < 4) {
            common.failure("Arcstats.parseParameters(): Requiring a minimum of four parameters");
        }
        this.arc_file = stringArray[1];
        if (!Fget.file_exists(this.arc_file)) {
            common.failure("Arcstats.parseParameters(): file %s does not exist", this.arc_file);
        }
        for (int i = 2; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2[0].equals("hitrate")) {
                this.requested_rate = Double.parseDouble(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equals("duration")) {
                this.duration = Integer.parseInt(stringArray2[1]) * 1000;
                continue;
            }
            common.failure("Arcstats.parseParameters(): invalid parameter:", stringArray2[0]);
        }
    }

    @Override
    public void storeRunInfo(int n, int n2, int n3) {
        common.where();
    }

    @Override
    public String[] getSummaryHeaders() {
        String[] stringArray = new String[]{String.format("%7s %7s %7s", "l1arc", "l1arc", "l1arc"), String.format("%7s %7s %7s", "hitpct", "hits", "misses")};
        return stringArray;
    }

    @Override
    public String getSummaryData() {
        if (this.old_data == null) {
            return "*No old arcstats data available";
        }
        if (this.new_data == null) {
            return "*No new arcstats data available";
        }
        if (this.old_data.snap_time == this.new_data.snap_time) {
            return "*arcstats data did not change";
        }
        long l = this.new_data.demand_data_hits - this.old_data.demand_data_hits;
        long l2 = this.new_data.demand_data_misses - this.old_data.demand_data_misses;
        long l3 = this.new_data.snap_time - this.old_data.snap_time;
        long l4 = l + l2;
        double d = l4 > 0L ? (double)l * 100.0 / (double)l4 : 0.0;
        String string = String.format("%7.2f %7d %7d", d, l, l2);
        return string;
    }

    @Override
    public String[] getReportHeader() {
        common.where();
        return null;
    }

    @Override
    public String getReportData() {
        common.where();
        return null;
    }

    @Override
    public void runStart() {
        common.where();
    }

    @Override
    public void collectIntervalData() {
        ArcstatsData arcstatsData = new ArcstatsData();
        if (common.onWindows()) {
            arcstatsData.demand_data_hits = hits += 100L;
            arcstatsData.demand_data_misses = misses += 200L;
            arcstatsData.snap_time = System.currentTimeMillis();
            this.old_data = this.new_data;
            this.new_data = arcstatsData;
            return;
        }
        String[] stringArray = Fget.readFileToArray(this.arc_file);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].substring(15).split("\t+");
            if (stringArray2[0].equals("snaptime")) {
                arcstatsData.snap_time = (long)(Double.parseDouble(stringArray2[1]) * 1000.0);
                continue;
            }
            if (stringArray2[0].equals("demand_data_hits")) {
                arcstatsData.demand_data_hits = Long.parseLong(stringArray2[1]);
                continue;
            }
            if (!stringArray2[0].equals("demand_data_misses")) continue;
            arcstatsData.demand_data_misses = Long.parseLong(stringArray2[1]);
        }
        if (arcstatsData.snap_time == 0L) {
            return;
        }
        if (!this.warmup_done) {
            this.saveHistory(arcstatsData);
        }
        if (this.old_data != null && this.old_data.snap_time == arcstatsData.snap_time) {
            return;
        }
        this.old_data = this.new_data;
        this.new_data = arcstatsData;
    }

    @Override
    public boolean isWarmupComplete() {
        if (this.warmup_done) {
            return true;
        }
        boolean bl = common.get_debug(common.DEBUG_AUX_REPORT);
        if (bl) {
            common.ptod("isWarmupComplete history.size(): " + this.history.size());
        }
        if (this.history.size() < 2) {
            return false;
        }
        ArcstatsData arcstatsData = this.history.get(0);
        ArcstatsData arcstatsData2 = this.history.get(this.history.size() - 1);
        if (bl) {
            common.ptod("isWarmupComplete delta: " + (arcstatsData2.snap_time - arcstatsData.snap_time));
        }
        if (arcstatsData2.snap_time - arcstatsData.snap_time < (long)this.duration) {
            return false;
        }
        long l = arcstatsData2.demand_data_hits - arcstatsData.demand_data_hits;
        long l2 = arcstatsData2.demand_data_misses - arcstatsData.demand_data_misses;
        long l3 = l + l2;
        if (l3 == 0L) {
            return false;
        }
        double d = (double)l * 100.0 / (double)l3;
        if (bl) {
            common.ptod("isWarmupComplete: %.2f total: %d hits: %d misses: %d", d, l3, l, l2);
        }
        if (d > this.requested_rate) {
            common.ptod("Reporting end of warmup: %.2f%% total: %d hits: %d misses: %d", d, l3, l, l2);
            this.warmup_done = true;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            Arcstats arcstats = (Arcstats)Class.forName("Vdb.Arcstats").newInstance();
            common.ptod("arcstat: " + arcstats);
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    private void saveHistory(ArcstatsData arcstatsData) {
        this.history.add(arcstatsData);
        for (int i = 0; i < this.history.size(); ++i) {
            if (this.history.get((int)i).snap_time >= arcstatsData.snap_time - (long)this.duration - 1000L) continue;
            this.history.set(i, null);
        }
        while (this.history.remove(null)) {
        }
    }

    class ArcstatsData {
        long demand_data_hits;
        long demand_data_misses;
        long snap_time;

        ArcstatsData() {
        }
    }
}

