/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.AuxReport;
import Vdb.Kstat_cpu;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.SdStats;
import Vdb.Vdbmain;
import Vdb.common;

public class AuxExternal2
extends AuxReport {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private String[] parms = null;
    private boolean disabled = false;
    private OS_cmd ocmd = null;
    private String[] blank_header = new String[]{"n/a", "n/a"};
    private String[] disabled_header = new String[]{"disabled", "disabled"};
    private String data = null;
    private String head1 = null;
    private String head2 = null;
    private static double free_bytes = -1.0;

    @Override
    public void parseParameters(String[] stringArray) {
        this.parms = stringArray;
        if (stringArray.length < 2) {
            common.failure("'auxreport=' must consist of a minimum of two parameters.");
        }
        this.obtainSummaryHeaders();
    }

    @Override
    public void storeRunInfo(int n, int n2, int n3) {
        common.where();
    }

    @Override
    public String[] getSummaryHeaders() {
        if (this.disabled) {
            return this.disabled_header;
        }
        return new String[]{this.head1, this.head2};
    }

    private void obtainSummaryHeaders() {
        if (this.disabled) {
            return;
        }
        this.head1 = " | " + this.callScript("header1");
        this.head2 = " | " + this.callScript("header2");
    }

    private String callScript(String string) {
        try {
            this.ocmd = new OS_cmd();
            this.ocmd.addQuot(this.parms[1]);
            this.ocmd.addText(string);
            for (int i = 2; i < this.parms.length; ++i) {
                this.ocmd.addQuot(this.parms[i]);
            }
            if (Vdbmain.isWdWorkload()) {
                SdStats sdStats = Report.getSummaryReport().getData().getIntervalSdStats();
                Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getIntervalCpuStats();
                if (sdStats != null) {
                    this.ocmd.addText(String.format("rd    %s", RD_entry.next_rd.rd_name));
                    this.ocmd.addText(String.format("iops  %.3f", sdStats.rate()));
                    this.ocmd.addText(String.format("resp  %.3f", sdStats.respTime()));
                    this.ocmd.addText(String.format("rresp %.3f", sdStats.readResp()));
                    this.ocmd.addText(String.format("wresp %.3f", sdStats.writeResp()));
                    this.ocmd.addText(String.format("max   %.3f", sdStats.respMax()));
                    this.ocmd.addText(String.format("std   %.3f", sdStats.resptime_std()));
                    if (kstat_cpu != null) {
                        this.ocmd.addText(String.format("cpu     %.3f", kstat_cpu.kernel_pct() + kstat_cpu.user_pct()));
                        this.ocmd.addText(String.format("cpu_sys %.3f", kstat_cpu.kernel_pct()));
                        this.ocmd.addText(String.format("cpu_usr %.3f", kstat_cpu.user_pct()));
                    }
                }
            }
            if (!this.ocmd.execute(false)) {
                this.ocmd.printStderr();
                this.ocmd.printStdout();
                common.ptod("'auxreport=' failure. Disabled.");
                this.disabled = true;
                return null;
            }
            String[] stringArray = this.ocmd.getStdout();
            if (stringArray.length != 1) {
                this.ocmd.printStderr();
                this.ocmd.printStdout();
                common.ptod("'auxreport=' expecting one line containing two blank separated headers. Disabled.");
                this.disabled = true;
                return null;
            }
            this.ocmd.printStderr();
            this.ocmd = null;
            return stringArray[0];
        }
        catch (Exception exception) {
            common.ptod("'auxreport=' failure. Disabled.");
            common.ptod(exception);
            this.disabled = true;
            return null;
        }
    }

    @Override
    public String getSummaryData() {
        if (this.disabled) {
            return " disabled";
        }
        if (this.isShutdown()) {
            return " shutdown";
        }
        if (this.data == null) {
            return " no data yet";
        }
        return this.data;
    }

    @Override
    public String[] getReportHeader() {
        common.where();
        return null;
    }

    @Override
    public String getReportData() {
        common.where();
        return null;
    }

    @Override
    public void runStart() {
        common.where();
    }

    @Override
    public void collectIntervalData() {
        if (this.disabled) {
            return;
        }
        if (this.isShutdown()) {
            return;
        }
        try {
            if (this.ocmd != null) {
                return;
            }
            String string = this.callScript("data 777.777");
            if (string == null) {
                return;
            }
            String[] stringArray = string.split(" +");
            if (stringArray[0].equals("shutdown_rd")) {
                if (!this.isShutdown()) {
                    this.setShutdown(true);
                    common.pboth("'auxreport=' requested shutdown of the current RD.", new Object[0]);
                }
            } else if (stringArray[0].equals("shutdown")) {
                Reporter.monitor_final = true;
                if (!this.isShutdown()) {
                    this.setShutdown(true);
                    common.pboth("'auxreport=' requested shutdown of Vdbench.", new Object[0]);
                }
            } else if (stringArray[0].equals("end_warmup")) {
                if (!this.isWarmupComplete()) {
                    this.setWarmupComplete(true);
                    common.pboth("'auxreport=' requested end to warmup.", new Object[0]);
                }
            } else {
                this.data = " | " + string;
            }
        }
        catch (Exception exception) {
            common.ptod("'auxreport=' auxiliarly reporting is being disabled.");
            common.ptod(exception);
            this.disabled = true;
        }
    }
}

