/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.ActiveFile;
import Vdb.BadDataBlock;
import Vdb.BadKeyBlock;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.ErrorLog;
import Vdb.File_handles;
import Vdb.Jnl_entry;
import Vdb.Native;
import Vdb.Patterns;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.Validate;
import Vdb.common;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

public class BadSector {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public static int BAD_KEY = 1;
    public static int BAD_CHECKSUM = 2;
    public static int BAD_LBA = 4;
    public static int BAD_NAME = 8;
    public static int BAD_DATA = 16;
    public static int BAD_COMP = 32;
    public static int BAD_DEDUPSET = 64;
    public static int BAD_ZERO = 128;
    public static int BAD_OWNER = 256;
    public BadKeyBlock owning_bkb;
    public BadDataBlock owning_bdb;
    public int data_flag;
    public long handle;
    public long file_lba;
    public long key_lba;
    public long rel_data_lba;
    public long file_start_lba;
    public long sector_lba;
    public int offset_in_key_block;
    public long compression;
    public long dedup_set;
    public int key_expected;
    public int key_blksize;
    public int data_blksize;
    public String name_left;
    public int error_flag;
    public int[] sector_array;
    public boolean bad_key = false;
    public boolean bad_checksum = false;
    public boolean bad_lba = false;
    public boolean bad_name = false;
    public boolean bad_data = false;
    public boolean bad_comp = false;
    public boolean bad_dedupset = false;
    public boolean bad_zero = false;
    public boolean bad_owner = false;
    public boolean unique = false;
    public boolean duplicate = false;
    public SD_entry sd = null;
    public ActiveFile afe = null;
    public String lun = null;
    public DV_map dv = null;
    public int sector_in_keyblock;
    public int sector_in_datablock;
    public int keyblock_in_datablock;
    private static int[] expected_pattern;
    private static int[] lfsr_sector;
    public static SimpleDateFormat dv_df;
    private static String allowed_chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void signalBadSector(int[] nArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13) {
        try {
            Object object = BadDataBlock.reporting_lock;
            synchronized (object) {
                Object object2;
                HashMap<Long, BadDataBlock> hashMap = null;
                common.where(16);
                BadSector badSector = new BadSector();
                badSector.sector_array = nArray;
                badSector.handle = l;
                badSector.file_lba = l2;
                badSector.rel_data_lba = l2 + l4;
                badSector.key_lba = l3;
                badSector.file_start_lba = l4;
                badSector.offset_in_key_block = (int)l6;
                badSector.sector_lba = l5;
                badSector.compression = l7;
                badSector.dedup_set = l8;
                badSector.error_flag = (int)l13;
                badSector.data_flag = (int)l9;
                badSector.key_expected = (int)l10;
                badSector.data_blksize = (int)l12;
                badSector.key_blksize = (int)l11;
                badSector.sector_in_keyblock = badSector.offset_in_key_block / 512;
                badSector.sector_in_datablock = (int)((badSector.key_lba - badSector.file_lba) / 512L + (long)badSector.sector_in_keyblock);
                badSector.keyblock_in_datablock = (int)((badSector.key_lba - badSector.file_start_lba - badSector.file_lba) / (long)badSector.key_blksize);
                badSector.interpretFlags();
                Object object3 = File_handles.findHandle(badSector.handle);
                if (object3 instanceof SD_entry) {
                    badSector.sd = (SD_entry)object3;
                    object2 = badSector.sd;
                    badSector.lun = ((SD_entry)object2).lun;
                    hashMap = ((SD_entry)object2).bad_data_map;
                    if (hashMap == null) {
                        hashMap = ((SD_entry)object2).bad_data_map = new HashMap(8);
                    }
                    badSector.name_left = ((SD_entry)object2).sd_name8;
                } else if (object3 instanceof ActiveFile) {
                    badSector.afe = (ActiveFile)object3;
                    object2 = badSector.afe;
                    badSector.name_left = ((ActiveFile)object2).getFileEntry().getAnchor().fsd_name_8bytes;
                    badSector.lun = ((ActiveFile)object2).getFileEntry().getFullName();
                    hashMap = ((ActiveFile)object2).getFileEntry().getAnchor().bad_data_map;
                    if (((ActiveFile)object2).getFileEntry().getAnchor().bad_data_map == null) {
                        ((ActiveFile)object2).getFileEntry().getAnchor().bad_data_map = new HashMap(8);
                        hashMap = ((ActiveFile)object2).getFileEntry().getAnchor().bad_data_map;
                    }
                    ((ActiveFile)object2).getFileEntry().setBlockBad(512);
                } else {
                    throw new RuntimeException("reportBadSector(): unexpected file handle return: " + object3);
                }
                object2 = hashMap.get(badSector.rel_data_lba);
                if (object2 == null) {
                    object2 = new BadDataBlock(badSector);
                    hashMap.put(badSector.rel_data_lba, (BadDataBlock)object2);
                }
                if ((badSector.dv = DV_map.findExistingMap(badSector.name_left.trim())) == null) {
                    common.failure("Unable to find Data Validation map for '%s'", badSector.name_left.trim());
                }
                badSector.dv.countBadSectors();
                ((BadDataBlock)object2).addSector(badSector);
                if (common.get_debug(common.DV_PRINT_SECTOR_IMMED)) {
                    BadSector.plog("Reporting due to 'DV_PRINT_SECTOR_IMMED'", new Object[0]);
                    badSector.printOneSector();
                    ErrorLog.flush();
                }
                if (Validate.getErrorCommand() != null) {
                    SlaveJvm.stopWork();
                }
            }
        }
        catch (Exception exception) {
            common.ptod("Exception during signalBadSector()");
            common.ptod(exception);
            common.ptod("Flushing local errorlog");
            ErrorLog.flush();
            common.failure(exception);
        }
    }

    public void printOneSector() {
        String string = Format.hex(this.getTimeStampRead(), 14);
        if (string.length() > 14) {
            string = string.substring(0, 14);
        }
        long l = this.offset_in_key_block / 512;
        BadSector.plog("", new Object[0]);
        if (this.afe != null) {
            BadSector.plog("        Data Validation error for fsd=%s; FSD lba: 0x%08x; Key block size: %d; relative sector in data block: 0x%02x ", this.name_left.trim(), this.sector_lba, this.key_blksize, l);
            BadSector.plog("        File name: %s; file block lba: 0x%08x; bad sector file lba: 0x%08x", this.lun, this.file_lba, this.sector_lba - this.file_start_lba);
        } else {
            BadSector.plog("        Data Validation error for sd=%s,lun=%s ", this.name_left.trim(), this.lun);
            BadSector.plog("        Block lba: 0x%08x; sector lba: 0x%08x; Key block size: %d; relative sector in data block: 0x%02x (%2d)", this.key_lba, this.sector_lba, this.key_blksize, l, l);
        }
        if (!this.owning_bkb.allMatching()) {
            this.report_flags(this.error_flag);
        }
        if ((this.error_flag & BAD_NAME) != 0) {
            BadSector.plog("        SD or FSD name in block expected: '%s'; received: '%s'.", this.name_left.trim(), this.getNameString());
        }
        if (!(Dedup.isDedup() && this.dedup_set != Dedup.UNIQUE_BLOCK_ACROSS_YES || this.owning_bkb.allMatching())) {
            String string2 = dv_df.format(new Date(this.getTimeStampRead()));
            BadSector.plog("        Timestamp found in sector: %s", string2);
        }
        if ((this.error_flag & BAD_CHECKSUM) != 0) {
            BadSector.plog("        Checksum on timestamp failed. Timestamp: 0x%s; checksum %s; should be %s", string, Format.hex(this.getChecksum(), 2), Format.hex(BadSector.calc_checksum(string)));
        }
        expected_pattern = this.getExpectedPattern();
        this.printFirstLine();
        this.printSecondLine();
        if (!this.checkOtherContent()) {
            if ((this.error_flag & BAD_KEY) != 0 && (this.error_flag & BAD_DATA) != 0) {
                BadSector.plog("        Key miscompare always implies Data miscompare. Remainder of data suppressed.", new Object[0]);
            } else {
                boolean bl = false;
                for (int i = 8; i < 128; i += 4) {
                    String string3 = String.format("%08x %08x %08x %08x", expected_pattern[i + 0], expected_pattern[i + 1], expected_pattern[i + 2], expected_pattern[i + 3]);
                    String string4 = String.format("%08x %08x %08x %08x", this.sector_array[i + 0], this.sector_array[i + 1], this.sector_array[i + 2], this.sector_array[i + 3]);
                    BadSector.combine_and_print(i, string3, string4);
                }
            }
        }
        ErrorLog.flush();
    }

    private static void plog(String string, Object ... objectArray) {
        ErrorLog.add(string, objectArray);
    }

    private void report_flags(int n) {
        ArrayList<String> arrayList = this.getFlagText();
        for (String string : arrayList) {
            BadSector.plog("        ===> " + string, new Object[0]);
        }
    }

    public ArrayList<String> getFlagText() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (this.bad_key) {
            arrayList.add(String.format("Data Validation Key miscompare. Expecting key=0x%02x received key=0x%02x (%d/%d)", this.key_expected, this.getKey(), this.key_expected, this.getKey()));
        }
        if (this.bad_checksum) {
            arrayList.add(String.format("Checksum error on timestamp. Checksum: 0x%02x, timestamp: 0x%016x", this.getChecksum(), this.getTimeStampRead()));
        }
        if (this.bad_lba) {
            arrayList.add(String.format("Logical byte address miscompare. Expecting 0x%08x, receiving 0x%08x", this.sector_lba, this.getLba()));
        }
        if (this.bad_name) {
            arrayList.add(String.format("SD or FSD name miscompare. Expecting '%s', receiving '%s' (0x%016x)", this.name_left, this.getNameString(), this.getNameHex()));
        }
        if (this.bad_data) {
            arrayList.add("Data Corruption beyond fixed sector header.");
        }
        if (this.bad_comp) {
            arrayList.add("Compression pattern miscompare.");
        }
        if (this.bad_dedupset) {
            arrayList.add("Bad dedup set value.");
        }
        if (this.bad_zero) {
            arrayList.add("Bad reserved field contents (mbz).");
        }
        if (this.bad_owner) {
            if (!Dedup.isDedup() || this.unique) {
                arrayList.add(String.format("Bad owner id. Expecting 0x%04x (%d) but found 0x%04x", SlaveJvm.getOwnerId(), SlaveJvm.getOwnerId(), this.getOwnerId()));
            } else {
                arrayList.add(String.format("Bad owner id. Expecting 0x%04x (%d) but found 0x%04x", SlaveJvm.getOwnerId(), SlaveJvm.getOwnerId(), this.getDupOwnerId()));
            }
        }
        if (this.unique) {
            arrayList.add("This is a unique (dedup) block.");
        }
        if (this.duplicate) {
            arrayList.add("This is a duplicate (dedup) block.");
        }
        return arrayList;
    }

    public void interpretFlags() {
        this.bad_key = (this.error_flag & BAD_KEY) != 0;
        this.bad_checksum = (this.error_flag & BAD_CHECKSUM) != 0;
        this.bad_lba = (this.error_flag & BAD_LBA) != 0;
        this.bad_name = (this.error_flag & BAD_NAME) != 0;
        this.bad_data = (this.error_flag & BAD_DATA) != 0;
        this.bad_comp = (this.error_flag & BAD_COMP) != 0;
        this.bad_dedupset = (this.error_flag & BAD_DEDUPSET) != 0;
        this.bad_zero = (this.error_flag & BAD_ZERO) != 0;
        boolean bl = this.bad_owner = (this.error_flag & BAD_OWNER) != 0;
        if (this.bad_key) {
            this.bad_data = false;
        }
        if (Dedup.isDedup()) {
            if ((this.dedup_set & Dedup.UNIQUE_BLOCK_MASK) != 0L) {
                this.unique = true;
            } else {
                this.duplicate = true;
            }
        }
    }

    private static int calc_checksum(String string) {
        int n = 0;
        if (string.length() != 14) {
            throw new RuntimeException("hex string must be 14 digits: '" + string + "'");
        }
        for (int i = 0; i < 7; ++i) {
            n += Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return n &= 0xFF;
    }

    private int[] getExpectedPattern() {
        int[] nArray = new int[128];
        if (!Validate.isCompression()) {
            Native.fillLfsrArray(nArray, this.sector_lba, this.key_expected, this.name_left);
            int[] nArray2 = new int[128];
            System.arraycopy(nArray, 0, nArray2, 8, 120);
            return nArray2;
        }
        int[] nArray3 = Patterns.getPattern();
        if (this.compression < 0L) {
            throw new RuntimeException("Unexpected negative compression field: " + this.compression);
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = (int)(this.compression + (long)this.offset_in_key_block + (long)(i * 4)) % (nArray3.length * 4) / 4;
            nArray[i] = nArray3[n];
        }
        return nArray;
    }

    private void printFirstLine() {
        if (!Dedup.isDedup() || (this.dedup_set & Dedup.UNIQUE_BLOCK_MASK) != 0L) {
            BadSector.plog("0x%03x%s  %08x %08x %s %s   %08x %08x %08x %08x", 0, (this.error_flag & BAD_LBA) != 0 || (this.error_flag & BAD_CHECKSUM) != 0 ? "*" : " ", (int)(this.sector_lba >> 32), (int)this.sector_lba, "........", "........", this.sector_array[0], this.sector_array[1], this.sector_array[2], this.sector_array[3]);
        } else if (this.dedup_set == Dedup.UNIQUE_BLOCK_ACROSS_NO) {
            BadSector.plog("0x%03x%s  %08x %08x %08x %08x   %08x %08x %08x %08x", 0, (this.error_flag & BAD_LBA) != 0 ? "*" : " ", (int)(this.sector_lba >> 32), (int)this.sector_lba, expected_pattern[2], expected_pattern[3], this.sector_array[0], this.sector_array[1], this.sector_array[2], this.sector_array[3]);
        } else {
            BadSector.plog("0x%03x%s  %08x %08x %08x %08x   %08x %08x %08x %08x", 0, (this.error_flag & BAD_DEDUPSET) != 0 ? "*" : " ", (int)(this.dedup_set >> 32), (int)this.dedup_set, SlaveJvm.getOwnerId(), expected_pattern[3], this.sector_array[0], this.sector_array[1], this.sector_array[2], this.sector_array[3]);
        }
    }

    private void printSecondLine() {
        if (!Dedup.isDedup() || (this.dedup_set & Dedup.UNIQUE_BLOCK_MASK) != 0L) {
            String string = BadSector.name_to_hex(this.name_left);
            BadSector.plog("0x%03x   %02x..0000 %-8s %-8s %08x   %08x %08x %08x %08x", 16, this.key_expected, string.substring(0, 8), string.substring(8), 0, this.sector_array[4], this.sector_array[5], this.sector_array[6], this.sector_array[7]);
        } else {
            String string = String.format("%08x %08x %08x %08x", expected_pattern[4], expected_pattern[5], expected_pattern[6], expected_pattern[7]);
            String string2 = String.format("%08x %08x %08x %08x", this.sector_array[4], this.sector_array[5], this.sector_array[6], this.sector_array[7]);
            BadSector.plog("0x%03x%s  %s   %s", 16, string.equals(string2) ? " " : "*", string, string2);
        }
    }

    private static void combine_and_print(int n, String string, String string2) {
        String string3 = "*";
        if (string.equals(string2)) {
            string3 = " ";
            return;
        }
        BadSector.plog("0x%03x%s  %s   %s ", n * 4, string3, string, string2);
    }

    private boolean checkOtherContent() {
        int n;
        boolean bl = false;
        for (n = 8; n < 128; ++n) {
            if (this.sector_array[n] == expected_pattern[n]) continue;
            bl = true;
        }
        if (!bl) {
            BadSector.plog("        There are no mismatches in bytes 32-511\n", new Object[0]);
            return true;
        }
        if ((this.data_flag & Validate.FLAG_COMPRESSION) != 0) {
            return false;
        }
        if ((this.error_flag & BAD_KEY) != 0 || (this.error_flag & BAD_LBA) != 0) {
            if (this.getNameString().length() < 8) {
                return false;
            }
            n = this.sector_array[4] >>> 24;
            long l = Jnl_entry.make64(this.sector_array[0], this.sector_array[1]);
            Native.fillLfsrArray(lfsr_sector, l, n, this.getNameString());
            for (int i = 8; i < 128; ++i) {
                if (this.sector_array[i] == lfsr_sector[i]) continue;
                bl = true;
            }
            if (!bl) {
                BadSector.plog("        Data pattern matches the incorrect key and/or lba that was read.\n", new Object[0]);
                return true;
            }
        }
        return false;
    }

    private static String name_to_hex(String string) {
        String string2 = "";
        if (string.length() != 8) {
            string = (string + "        ").substring(0, 8);
        }
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            for (int i = 0; i < string.length(); ++i) {
                string2 = string2 + Format.hex(string.charAt(i), 2);
            }
        } else {
            string2 = string2 + Format.hex(string.charAt(3), 2);
            string2 = string2 + Format.hex(string.charAt(2), 2);
            string2 = string2 + Format.hex(string.charAt(1), 2);
            string2 = string2 + Format.hex(string.charAt(0), 2);
            string2 = string2 + Format.hex(string.charAt(7), 2);
            string2 = string2 + Format.hex(string.charAt(6), 2);
            string2 = string2 + Format.hex(string.charAt(5), 2);
            string2 = string2 + Format.hex(string.charAt(4), 2);
        }
        return string2;
    }

    public String getTimeStampText() {
        if (!Dedup.isDedup() || Dedup.isUnique(this.dedup_set)) {
            return dv_df.format(new Date(this.getTimeStampRead()));
        }
        return null;
    }

    public int getOwnerId() {
        return this.sector_array[7];
    }

    public int getDupOwnerId() {
        return this.sector_array[2];
    }

    public int getKey() {
        return this.sector_array[4] >>> 24;
    }

    public int getChecksum() {
        return this.sector_array[4] << 8 >>> 24;
    }

    public long getLba() {
        return Jnl_entry.make64(this.sector_array[0], this.sector_array[1]);
    }

    public long getTimeStampRead() {
        return Jnl_entry.make64(this.sector_array[2], this.sector_array[3]);
    }

    public long getNameHex() {
        return Jnl_entry.make64(this.sector_array[5], this.sector_array[6]);
    }

    public String obsolete_getNameString() {
        int n;
        int n2;
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new RuntimeException("tbd: BIG_ENDIAN");
        }
        int n3 = this.sector_array[5];
        int n4 = this.sector_array[6];
        char[] cArray = new char[8];
        for (n2 = 0; n2 < 4; ++n2) {
            cArray[n2] = (char)(n3 << n2 * 8 >>> 24);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            cArray[4 + n2] = (char)(n4 << n2 * 8 >>> 24);
        }
        char[] cArray2 = new char[]{'-', '_', '\'', ' '};
        String string = "";
        for (n = 3; n >= 0; --n) {
            if (!Character.isLetterOrDigit(cArray[n]) && new String(cArray2).indexOf(cArray[n]) < 0) {
                return "garbage ";
            }
            string = String.format("%s%s", string, new Character(cArray[n]));
        }
        for (n = 7; n >= 4; --n) {
            if (!Character.isLetterOrDigit(cArray[n]) && new String(cArray2).indexOf(cArray[n]) < 0) {
                return "garbage ";
            }
            string = String.format("%s%s", string, new Character(cArray[n]));
        }
        if ((string = string.trim()).contains(" ")) {
            return "garbage ";
        }
        String string2 = (string + "         ").substring(0, 8);
        common.ptod("ret: >>>%s<<<", string2);
        common.failure("testing");
        return string2;
    }

    public String getNameString() {
        char c;
        int n;
        int n2;
        int n3 = this.sector_array[5];
        int n4 = this.sector_array[6];
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            n3 = Integer.reverseBytes(n3);
            n4 = Integer.reverseBytes(n4);
        }
        char[] cArray = new char[8];
        for (n2 = 0; n2 < 4; ++n2) {
            cArray[n2] = (char)(n3 << n2 * 8 >>> 24);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            cArray[4 + n2] = (char)(n4 << n2 * 8 >>> 24);
        }
        String string = "";
        for (n = 3; n >= 0; --n) {
            c = cArray[n];
            if (allowed_chars.indexOf(c) == -1) {
                return "garbage1";
            }
            string = String.format("%s%s", string, new Character(c));
        }
        for (n = 7; n >= 4; --n) {
            c = cArray[n];
            if (allowed_chars.indexOf(c) == -1) {
                return "garbage2";
            }
            string = String.format("%s%s", string, new Character(c));
        }
        if ((string = string.trim()).contains(" ")) {
            return "garbage1";
        }
        String string2 = (string + "         ").substring(0, 8);
        return string2;
    }

    public static void main(String[] stringArray) {
        BadSector badSector = new BadSector();
        badSector.sector_array = new int[8];
        badSector.sector_array[5] = 2034584942;
        badSector.sector_array[6] = 858928204;
        badSector.sector_array[5] = 1935946016;
        badSector.sector_array[6] = 0x20202020;
        common.ptod("name: >>>%s<<<", badSector.getNameString());
    }

    public static void main2(String[] stringArray) {
        int n = 1289606558;
        int n2 = 1579632019;
        n = -1637491380;
        n2 = -1824184482;
        Random random = new Random(0L);
        int n3 = 0;
        block0: for (int i = 0; i < 100000000; ++i) {
            char c;
            int n4;
            int n5;
            n = random.nextInt();
            n2 = random.nextInt();
            char[] cArray = new char[8];
            for (n5 = 0; n5 < 4; ++n5) {
                cArray[n5] = (char)(n << n5 * 8 >>> 24);
            }
            for (n5 = 0; n5 < 4; ++n5) {
                cArray[4 + n5] = (char)(n2 << n5 * 8 >>> 24);
            }
            String string = "";
            for (n4 = 3; n4 >= 0; --n4) {
                c = cArray[n4];
                if (allowed_chars.indexOf(c) == -1) continue block0;
                string = String.format("%s%s", string, new Character(c));
            }
            for (n4 = 7; n4 >= 4; --n4) {
                c = cArray[n4];
                if (allowed_chars.indexOf(c) == -1) continue block0;
                string = String.format("%s%s", string, new Character(c));
            }
            if ((string = string.trim()).contains(" ")) continue;
            String string2 = (string + "         ").substring(0, 8);
            common.ptod("valid: %4d >>>%s<<< for %08x %08x", n3++, string2, n, n2);
        }
        common.ptod("valids: " + n3);
    }

    static {
        lfsr_sector = new int[128];
        dv_df = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS zzz");
        allowed_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_' ";
    }
}

