/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BlockTrace;
import Vdb.Report;
import Vdb.SlaveJvm;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

class Blocked
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static long[] stat_counter;
    private static ArrayList<String> labels;
    public static int FILE_CREATES;
    public static int DIRECTORY_CREATES;
    public static int FILE_DELETES;
    public static int DIRECTORY_DELETES;
    public static int READ_OPENS;
    public static int WRITE_OPENS;
    public static int DIR_BUSY_RMDIR;
    public static int DIR_BUSY_MKDIR;
    public static int DIR_DOES_NOT_EXIST;
    public static int DIR_EXISTS;
    public static int DIR_STILL_HAS_CHILD;
    public static int DIR_STILL_HAS_FILES;
    public static int FILE_BUSY;
    public static int FILE_MAY_NOT_EXIST;
    public static int FILE_MUST_EXIST;
    public static int FILE_NOT_FULL;
    public static int GET_ATTR;
    public static int MISSING_PARENT;
    public static int PARENT_DIR_BUSY;
    public static int SET_ATTR;
    public static int SPARSE_CREATES;
    public static int FILE_CLOSES;
    public static int SKIP_BAD_BLOCKS;
    public static int SKIP_WRITE;
    public static int FILES_COPIED;
    public static int FILES_MOVED;
    public static int FILE_WRONG_SIZE;
    public static int BAD_FILE_SKIPPED;
    public static int FILE_IS_FULL;
    public static int DIR_CREATE_SHARED;
    public static int DIR_WAIT_SHARED;
    public static int FILE_FILL_SHARED;
    public static int FILE_DELETE_SHARED;
    public static int DIR_DELETE_SHARED;
    public static int SKIP_BAD_FILE;
    public static int ACCESS;
    private static int TRACE_LENGTH;
    private static int TRACE_MASK;
    private static BlockTrace[] trace;
    private static long offset;
    private static Object count_lock;
    private static int only_once;

    public Blocked() {
        stat_counter = new long[labels.size()];
    }

    private static int init(String string) {
        labels.add(string);
        return labels.size() - 1;
    }

    public static String getLabel(int n) {
        return labels.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(int n) {
        Object object = count_lock;
        synchronized (object) {
            int n2 = n;
            stat_counter[n2] = stat_counter[n2] + 1L;
            BlockTrace blockTrace = trace[(int)(offset++ & (long)TRACE_MASK)];
            blockTrace.ts = System.currentTimeMillis();
            blockTrace.operation = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTrace() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        Object object = common.ptod_lock;
        synchronized (object) {
            if (only_once++ > 0) {
                return;
            }
            long l = offset;
            for (int i = 0; i < trace.length; ++i) {
                BlockTrace blockTrace = trace[(int)(l++ & (long)TRACE_MASK)];
                String string = simpleDateFormat.format(new Date(blockTrace.ts));
                common.ptod("trace: " + string + " " + labels.get(blockTrace.operation));
            }
        }
    }

    public static long[] getCounters() {
        return stat_counter;
    }

    public static void resetCounters() {
        stat_counter = new long[labels.size()];
    }

    public static void printAndResetCounters() {
        Blocked.printCounters(stat_counter, common.stdout);
        Blocked.resetCounters();
    }

    public static void printCountersToLog() {
        if (stat_counter != null) {
            Blocked.printCounters(stat_counter, common.log_html);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCounters(long[] lArray, PrintWriter printWriter) {
        if (SlaveJvm.isThisSlave() && !SlaveJvm.isFwdWorkload()) {
            return;
        }
        if (!SlaveJvm.isThisSlave() && !Vdbmain.isFwdWorkload()) {
            return;
        }
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            n = (int)((long)n + lArray[i]);
        }
        if (n == 0) {
            common.ptod("Miscellaneous statistics: All counters are zero", printWriter);
            return;
        }
        Object object = common.ptod_lock;
        synchronized (object) {
            common.ptod("", printWriter);
            common.ptod("Miscellaneous statistics:", printWriter);
            if (Vdbmain.isWorkloadDone()) {
                common.ptod("(These statistics do not include activity between the last reported interval and shutdown.)");
            }
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 0L) continue;
                if (SlaveJvm.isThisSlave()) {
                    common.ptod("%-60s %,10d", labels.get(i) + ":", lArray[i]);
                    continue;
                }
                common.ptod("%-60s %,10d %,10d/sec", labels.get(i) + ":", lArray[i], lArray[i] / (long)Report.getInterval() / (long)Report.getIntervalDuration());
            }
            common.ptod("", printWriter);
        }
    }

    public static void accumCounters(long[] lArray) {
        if (stat_counter.length != lArray.length) {
            common.failure("accumCounters() unequal counter length: " + stat_counter.length + " " + lArray.length);
        }
        for (int i = 0; i < stat_counter.length; ++i) {
            int n = i;
            stat_counter[n] = stat_counter[n] + lArray[i];
        }
    }

    static {
        labels = new ArrayList(16);
        FILE_CREATES = Blocked.init("FILE_CREATES        Files created");
        DIRECTORY_CREATES = Blocked.init("DIRECTORY_CREATES   Directories created");
        FILE_DELETES = Blocked.init("FILE_DELETES        Files deleted");
        DIRECTORY_DELETES = Blocked.init("DIRECTORY_DELETES   Directories deleted");
        READ_OPENS = Blocked.init("READ_OPENS          Files opened for read activity");
        WRITE_OPENS = Blocked.init("WRITE_OPENS         Files opened for write activity");
        DIR_BUSY_RMDIR = Blocked.init("DIR_BUSY_RMDIR      Directory busy (rmdir)");
        DIR_BUSY_MKDIR = Blocked.init("DIR_BUSY_MKDIR      Directory busy (mkdir)");
        DIR_DOES_NOT_EXIST = Blocked.init("DIR_DOES_NOT_EXIST  Directory does not exist (rmdir)");
        DIR_EXISTS = Blocked.init("DIR_EXISTS          Directory may not exist (yet)");
        DIR_STILL_HAS_CHILD = Blocked.init("DIR_STILL_HAS_CHILD Directory still has a child directory");
        DIR_STILL_HAS_FILES = Blocked.init("DIR_STILL_HAS_FILES Directory still has files");
        FILE_BUSY = Blocked.init("FILE_BUSY           File busy");
        FILE_MAY_NOT_EXIST = Blocked.init("FILE_MAY_NOT_EXIST  File may not exist (yet)");
        FILE_MUST_EXIST = Blocked.init("FILE_MUST_EXIST     File does not exist (yet)");
        FILE_NOT_FULL = Blocked.init("FILE_NOT_FULL       File has not been completely written");
        GET_ATTR = Blocked.init("GET_ATTR            Getattr requests");
        MISSING_PARENT = Blocked.init("MISSING_PARENT      Parent directory does not exist (yet)");
        PARENT_DIR_BUSY = Blocked.init("PARENT_DIR_BUSY     Parent directory busy, waiting");
        SET_ATTR = Blocked.init("SET_ATTR            Setattr requests");
        SPARSE_CREATES = Blocked.init("SPARSE_CREATES      Sparse files created");
        FILE_CLOSES = Blocked.init("FILE_CLOSES         Close requests");
        SKIP_BAD_BLOCKS = Blocked.init("SKIP_BAD_BLOCKS     A block marked bad has been skipped");
        SKIP_WRITE = Blocked.init("SKIP_WRITE          Write after bad read was skipped");
        FILES_COPIED = Blocked.init("FILES_COPIED        Files copied");
        FILES_MOVED = Blocked.init("FILES_MOVED         Files moved");
        FILE_WRONG_SIZE = Blocked.init("FILE_WRONG_SIZE     Target copy/move file must be same size");
        BAD_FILE_SKIPPED = Blocked.init("BAD_FILE_SKIPPED    Too many errors on file");
        FILE_IS_FULL = Blocked.init("FILE_IS_FULL        File is full");
        DIR_CREATE_SHARED = Blocked.init("DIR_CREATE_SHARED   Shared directory already exists");
        DIR_WAIT_SHARED = Blocked.init("DIR_WAIT_SHARED     Shared directory check pending");
        FILE_FILL_SHARED = Blocked.init("FILE_FILL_SHARED    Shared file already exists");
        FILE_DELETE_SHARED = Blocked.init("FILE_DELETE_SHARED  Shared file delete failed");
        DIR_DELETE_SHARED = Blocked.init("DIR_DELETE_SHARED   Shared directory delete failed");
        SKIP_BAD_FILE = Blocked.init("SKIP_BAD_FILE       Not enough good blocks left in file");
        ACCESS = Blocked.init("ACCESS              Access to file checked");
        TRACE_LENGTH = 1024;
        TRACE_MASK = TRACE_LENGTH - 1;
        trace = new BlockTrace[TRACE_LENGTH];
        for (int i = 0; i < trace.length; ++i) {
            Blocked.trace[i] = new BlockTrace();
        }
        offset = 0L;
        count_lock = new Object();
        only_once = 0;
    }
}

