/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.Fget;
import Utils.Format;
import Vdb.BucketRange;
import Vdb.common;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class BucketRanges
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String type;
    private BucketRange[] ranges;
    private String[] maxes;
    private boolean suppress = false;
    private static HashMap<String, BucketRanges> type_map = BucketRanges.setDefaultHistogram();

    public BucketRanges(String[] stringArray) {
        this.type = stringArray[0];
        this.parseList(this.findOptions(stringArray));
        type_map.put(this.type, this);
        this.createMaxText();
    }

    public boolean suppress() {
        return this.suppress;
    }

    public static HashMap getBucketTypes() {
        return type_map;
    }

    public static void setBucketTypes(HashMap hashMap) {
        type_map = hashMap;
    }

    public static void setOption(String string, String string2) {
        BucketRanges bucketRanges = type_map.get(string);
        if (bucketRanges == null) {
            common.failure("BucketRanges.setOption(): bucket %s not found", string);
        }
        if ("suppress".startsWith(string2)) {
            bucketRanges.suppress = true;
        } else {
            common.failure("BucketRanges.setOption(): option %s not found", string2);
        }
    }

    public Object clone() {
        try {
            BucketRanges bucketRanges = (BucketRanges)super.clone();
            bucketRanges.ranges = (BucketRange[])this.ranges.clone();
            return bucketRanges;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    private void createMaxText() {
        this.maxes = new String[this.ranges.length];
        String string = null;
        for (int i = 0; i < this.ranges.length; ++i) {
            BucketRange bucketRange = this.ranges[i];
            if (bucketRange.max < 10000L) {
                string = Format.f("%12dus", bucketRange.max);
            } else if (bucketRange.max < 1000000L) {
                string = Format.f("%12.3fms", (double)bucketRange.max / 1000.0);
            } else if (i != this.ranges.length - 1) {
                string = Format.f(" %12.3fs", (double)bucketRange.max / 1000000.0);
            } else {
                string = ">" + string.trim();
                string = Format.f("  %12s", string);
            }
            this.maxes[i] = string;
        }
    }

    public String getMax(int n) {
        return this.maxes[n];
    }

    public int getBucketCount() {
        return this.ranges.length;
    }

    public static BucketRanges getRangesFromType(String string) {
        BucketRanges bucketRanges = type_map.get(string);
        if (bucketRanges == null) {
            common.failure("Unable to find BucketRanges type: " + string);
        }
        return bucketRanges;
    }

    public BucketRange[] getRanges() {
        return this.ranges;
    }

    public int findBucket(long l) {
        int n;
        for (n = 0; n < this.ranges.length; ++n) {
            BucketRange bucketRange = this.ranges[n];
            if (l < bucketRange.min || l >= bucketRange.max) continue;
            return bucketRange.which;
        }
        common.ptod("Requesting bucket for: " + l);
        for (n = 0; n < this.ranges.length; ++n) {
            common.ptod("" + this.ranges[n]);
        }
        common.failure("Unable to find bucket. Are we having a Harry Belafonte moment here? " + l);
        return -1;
    }

    private void parseList(String[] stringArray) {
        int n;
        ArrayList<Long> arrayList = new ArrayList<Long>(64);
        long l = -1L;
        long l2 = 0L;
        for (n = 1; n < stringArray.length; ++n) {
            String string = stringArray[n];
            long l3 = 1L;
            if (string.endsWith("u")) {
                l3 = 1L;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("m")) {
                l3 = 1000L;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("s")) {
                l3 = 1000000L;
                string = string.substring(0, string.length() - 1);
            }
            long l4 = Long.parseLong(string) * l3;
            if (l4 <= l) {
                l2 = l4;
                continue;
            }
            if (l2 > 0L) {
                for (long i = l + l2; i < l4; i += l2) {
                    arrayList.add(new Long(i));
                }
                l2 = 0L;
            }
            arrayList.add(new Long(l4));
            l = l4;
        }
        if (arrayList.size() == 0) {
            common.failure("Histogram bucket list is empty. ");
        }
        if ((Long)arrayList.get(0) == 0L) {
            common.failure("First bucket may not be zero: " + arrayList.get(0));
        }
        arrayList.add(new Long(Long.MAX_VALUE));
        if (arrayList.size() > 64) {
            for (n = 0; n < arrayList.size() && n < 64; ++n) {
                common.ptod("bucket: " + n + " " + arrayList.get(n));
            }
            common.failure("Histogram bucket list may not contain more than 64 buckets");
        }
        this.ranges = new BucketRange[arrayList.size()];
        long l5 = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l6 = (Long)arrayList.get(i);
            this.ranges[i] = new BucketRange(l5, l6, i);
            l5 = l6;
        }
    }

    private String[] findOptions(String[] stringArray) {
        while (true) {
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                if (!"suppress".startsWith(stringArray[i])) continue;
                bl = true;
            }
            if (!bl) {
                return stringArray;
            }
            Vector<String> vector = new Vector<String>(stringArray.length);
            for (int i = 1; i < stringArray.length; ++i) {
                if ("suppress".startsWith(stringArray[i])) {
                    this.suppress = true;
                    continue;
                }
                vector.add(stringArray[i]);
            }
            stringArray = vector.toArray(new String[0]);
        }
    }

    public long[] getJniBucketArray() {
        long[] lArray = new long[this.ranges.length * 3];
        for (int i = 0; i < lArray.length / 3; ++i) {
            lArray[i * 3 + 0] = this.ranges[i].min;
            lArray[i * 3 + 1] = this.ranges[i].max;
            lArray[i * 3 + 2] = 0L;
        }
        return lArray;
    }

    private static HashMap setDefaultHistogram() {
        type_map = new HashMap(8);
        String[] stringArray = new String[]{"default", "20", "40", "60", "80", "100", "200", "400", "600", "800", "1m", "2m", "4m", "6m", "8m", "10m", "20m", "40m", "60m", "80m", "100m", "200m", "400m", "600m", "800m", "1s", "2s"};
        if (Fget.file_exists(ClassPath.classPath("histogram.txt"))) {
            String[] stringArray2 = Fget.readFileToArray(ClassPath.classPath("histogram.txt"));
            for (String string : Fget.readFileToArray(ClassPath.classPath("histogram.txt"))) {
                if ((string = string.trim()).length() == 0 || string.startsWith("*")) continue;
                if (!string.startsWith("histogram=")) {
                    common.failure("Reading file %s; expecting 'histogram='", ClassPath.classPath("histogram.txt"));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=,()");
                String[] stringArray3 = new String[stringTokenizer.countTokens() - 1];
                stringTokenizer.nextToken();
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray3[i] = stringTokenizer.nextToken();
                }
                if (stringArray3.length == 2) {
                    if (type_map.size() == 0) {
                        new BucketRanges(stringArray);
                    }
                    BucketRanges.setOption(stringArray3[0], stringArray3[1]);
                    continue;
                }
                new BucketRanges(stringArray3);
            }
            return type_map;
        }
        new BucketRanges(stringArray);
        return type_map;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        BucketRanges bucketRanges = BucketRanges.getRangesFromType("default");
        common.ptod("hb 0       : " + bucketRanges.findBucket(0L));
        common.ptod("hb 1       : " + bucketRanges.findBucket(1L));
        common.ptod("hb 2       : " + bucketRanges.findBucket(2L));
        common.ptod("hb 8388608 : " + bucketRanges.findBucket(0x800000L));
        common.ptod("hb 16777215: " + bucketRanges.findBucket(0xFFFFFFL));
        common.ptod("hb 16777216: " + bucketRanges.findBucket(0x1000000L));
    }
}

