/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.Native;
import Vdb.RD_entry;
import Vdb.common;
import Vdb.ownmath;
import java.io.Serializable;

public class Bursts
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private double[] matrix = null;
    private long[] arrivals = null;
    private double[] rates = null;
    private int ios_left_for_this_second = 0;
    private long start_time = -1000000L;
    private boolean spread = false;
    private double max_rate = 0.0;

    public Bursts(double[] dArray, boolean bl) {
        if (dArray == null) {
            common.failure("'dist=variable' requested without a proper iorate= distribution list");
        }
        this.spread = bl;
        this.matrix = (double[])dArray.clone();
        if (this.matrix.length % 2 == 1) {
            common.failure("Burst distribution list must contain an even number of values.");
        }
        int n = 0;
        for (int i = 0; i < this.matrix.length; i += 2) {
            n = (int)((double)n + this.matrix[i + 1]);
            this.max_rate = Math.max(this.max_rate, this.matrix[i]);
        }
        if (n > 3600) {
            common.failure("Variable i/o rate distribution list may contain no more than 3600 seconds worth of i/o rates:" + n);
        }
    }

    public double getMaxRate() {
        return this.max_rate;
    }

    public Object clone() {
        try {
            Bursts bursts = (Bursts)super.clone();
            if (this.matrix != null) {
                bursts.matrix = (double[])this.matrix.clone();
            }
            if (this.arrivals != null) {
                bursts.arrivals = (long[])this.arrivals.clone();
            }
            return bursts;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public double[] getList() {
        return this.matrix;
    }

    public boolean isSpread() {
        return this.spread;
    }

    public void createBurstList(double d, RD_entry rD_entry) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.matrix.length; n2 += 2) {
            if (this.matrix[n2 + 0] < 0.0) {
                this.matrix[n2 + 0] = rD_entry.iorate * (this.matrix[n2 + 0] * -1.0) / 100.0;
            }
            if (!(this.matrix[n2 + 1] < 0.0)) continue;
            double d2 = (long)((double)rD_entry.getElapsed() * (this.matrix[n2 + 1] * -1.0) / 100.0);
            if (d2 == 0.0) {
                common.failure("A burst duration percentage in the 'burst=' matrix results in a duration of zero seconds: " + this.matrix[n2 + 1] * -1.0 + "%.");
            }
            this.matrix[n2 + 1] = d2;
        }
        n2 = 0;
        for (n = 0; n < this.matrix.length; n += 2) {
            n2 = (int)((double)n2 + (this.matrix[n + 1] > 0.0 ? this.matrix[n + 1] : 1.0));
        }
        if ((long)n2 > rD_entry.getElapsed()) {
            common.failure("The amount of time covered by 'dist=variable' iorate (%d) must be shorter than elapsed time (%d)", n2, rD_entry.getElapsed());
        }
        this.rates = new double[n2];
        this.arrivals = new long[n2];
        n = 0;
        for (int i = 0; i < this.matrix.length; i += 2) {
            int n3 = 0;
            while ((double)n3 < this.matrix[i + 1]) {
                this.rates[n] = this.matrix[i] * d / 100.0;
                this.arrivals[n++] = this.matrix[i] != 0.0 ? (long)(1000000.0 / (this.matrix[i] * d / 100.0)) : 0L;
                ++n3;
            }
        }
    }

    public double getArrivalTime(double d, int n) {
        if (!this.spread) {
            return this.getHotArrivalTime();
        }
        return this.GetSpreadArrivalTime(d, n);
    }

    public double getHotArrivalTime() {
        if (this.ios_left_for_this_second == 0) {
            do {
                this.start_time += 1000000L;
                long l = (long)((double)this.start_time / 1000000.0);
                this.ios_left_for_this_second = (int)this.rates[(int)(l % (long)this.rates.length)];
            } while (this.ios_left_for_this_second <= 0);
        }
        --this.ios_left_for_this_second;
        return this.start_time;
    }

    public double GetSpreadArrivalTime(double d, int n) {
        double d2 = d;
        long l = (long)d2 / 1000000L;
        double d3 = this.arrivals[(int)(l % (long)this.arrivals.length)];
        while (d3 == 0.0) {
            l = (long)(d2 += 1000000.0) / 1000000L;
            d3 = this.arrivals[(int)(l % (long)this.arrivals.length)];
        }
        if (n == 0) {
            double d4 = ownmath.exponential(d3);
            if (d4 > 1.8E8) {
                d4 = 1.8E8;
            }
            d2 += d4;
        } else if (n == 1) {
            double d5 = ownmath.uniform(0.0, d3 * 2.0);
            if (d5 > 1000000.0) {
                d5 = 1000000.0;
            }
            d2 += d5;
        } else {
            d2 += d3;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        int n = 30000000;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            long l2 = Native.get_simple_tod();
        }
        long l3 = System.currentTimeMillis();
        double d = (double)(l3 - l) / 1000.0;
        common.ptod("seconds: " + d);
        common.ptod(Format.f("end: %.6f", (double)n / d));
    }
}

