/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BoxPrint;
import Vdb.Host;
import Vdb.InfoFromHost;
import Vdb.LunInfoFromHost;
import Vdb.Native;
import Vdb.SD_entry;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ConcatMarkers {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static long marker_tod = 0L;
    private static int MARKER1 = 1129270851;
    private static int MARKER2 = 1296126539;
    private static Host local_host = null;

    public static long getMarkerTod() {
        return marker_tod;
    }

    public static void checkLunCounts(HashMap<String, HashMap<String, LunInfoFromHost>> hashMap) {
        Cloneable cloneable;
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            cloneable = Host.getDefinedHosts().get(i);
            HashMap<String, LunInfoFromHost> hashMap2 = hashMap.get(((Host)cloneable).getLabel());
            if (hashMap2 != null) continue;
            ConcatMarkers.error("ConcatMarkers: No lun definitions found for host=%s", ((Host)cloneable).getLabel());
        }
        Host host = Host.getDefinedHosts().get(0);
        cloneable = hashMap.get(host.getLabel());
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            Host host2 = Host.getDefinedHosts().get(i);
            HashMap<String, LunInfoFromHost> hashMap3 = hashMap.get(host2.getLabel());
            if (((HashMap)cloneable).size() == hashMap3.size()) continue;
            common.ptod("");
            common.ptod("ConcatMarkers: Unmatched lun count.");
            for (i = 0; i < Host.getDefinedHosts().size(); ++i) {
                host2 = Host.getDefinedHosts().get(i);
                hashMap3 = hashMap.get(host2.getLabel());
                common.ptod("ConcatMarkers: host=%s has %d luns", host2.getLabel(), hashMap3.size());
            }
            ConcatMarkers.error("ConcatMarkers: Unmatched lun count.", new Object[0]);
        }
    }

    public static void writeMarkers() {
        marker_tod = System.currentTimeMillis();
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        local_host = null;
        for (Host cloneable : Host.getDefinedHosts()) {
            if (!cloneable.getSlaves().get(0).isLocalHost()) continue;
            local_host = cloneable;
            break;
        }
        if (local_host == null) {
            ConcatMarkers.error("ConcatMarkers: Unable to find local host for writing markers", new Object[0]);
        }
        for (SD_entry sD_entry : Vdbmain.sd_list) {
            if (sD_entry.concatenated_sd || !sD_entry.sd_is_referenced) continue;
            if (common.get_debug(common.CONCAT_ALLOW_WRITE)) {
                sD_entry.setOpenForWrite();
            }
            if (sD_entry.open_for_write) continue;
            ConcatMarkers.error("ConcatMarkers: Writing of markers for sd=%s can not be done for read-only workloads.", sD_entry.sd_name);
        }
        long l = Native.allocBuffer(4096);
        int[] nArray = new int[1024];
        for (SD_entry sD_entry : Vdbmain.sd_list) {
            long l2;
            long l3;
            if (sD_entry.concatenated_sd || !sD_entry.sd_is_referenced) continue;
            String string = local_host.getLunNameForSd(sD_entry);
            if (hashMap.put(string, string) != null) {
                ConcatMarkers.error("ConcatMarkers: host=%s,lun=%s defined more than once.", local_host.getLabel(), string);
            }
            if ((l3 = sD_entry.end_lba) == 0L) {
                LunInfoFromHost lunInfoFromHost = new LunInfoFromHost();
                lunInfoFromHost.lun = string;
                if (string.startsWith("/dev/") || string.startsWith("\\\\.\\")) {
                    lunInfoFromHost.getRawInfo();
                } else {
                    lunInfoFromHost.getFileInfo();
                }
                l3 = lunInfoFromHost.lun_size;
                if (l3 == 0L) {
                    ConcatMarkers.error("ConcatMarkers: Unable to obtain lun size for '%s'", string);
                }
            }
            if ((l2 = Native.openFile(string, 1)) == -1L) {
                ConcatMarkers.error("ConcatMarkers: Open for lun '%s' failed", string);
            }
            long l4 = l3 / 4096L * 4096L - 4096L;
            nArray[0] = MARKER1;
            nArray[1] = MARKER2;
            nArray[2] = sD_entry.relative_sd_num;
            nArray[3] = (int)(marker_tod >> 32);
            nArray[4] = (int)marker_tod;
            Native.arrayToBuffer(nArray, l);
            if (Native.writeFile(l2, l4, 4096L, l) < 0L) {
                ConcatMarkers.error("ConcatMarkers: Writing marker failed for lun '%s'", string);
            }
            Native.closeFile(l2);
            common.plog("ConcatMarkers: Writing SD Concatenation markers to lun=%s", string);
        }
        Native.freeBuffer(4096, l);
    }

    public static void readMarker(LunInfoFromHost lunInfoFromHost) {
        long l;
        long l2;
        long l3 = Native.allocBuffer(4096);
        int[] nArray = new int[1024];
        long l4 = Native.openFile(lunInfoFromHost.lun, 0);
        if (l4 == -1L) {
            ConcatMarkers.error("ConcatMarkers: Open for lun '%s' failed", lunInfoFromHost.lun);
        }
        if ((l2 = lunInfoFromHost.end_lba) == 0L) {
            if (lunInfoFromHost.lun.startsWith("/dev/") || lunInfoFromHost.lun.startsWith("\\\\.\\")) {
                lunInfoFromHost.getRawInfo();
            } else {
                lunInfoFromHost.getFileInfo();
            }
            l2 = lunInfoFromHost.lun_size;
            if (l2 == 0L) {
                ConcatMarkers.error("ConcatMarkers: Unable to obtain lun size for '%s'", lunInfoFromHost.lun);
            }
        }
        if (Native.readFile(l4, l = l2 / 4096L * 4096L - 4096L, 4096L, l3) < 0L) {
            common.ptod("ConcatMarkers: Reading marker for lun '%s' failed", lunInfoFromHost.lun);
            Native.freeBuffer(4096, l3);
            return;
        }
        Native.buffer_to_array(nArray, l3, 4096);
        if (nArray[0] == MARKER1 && nArray[1] == MARKER2) {
            lunInfoFromHost.marker_found = true;
            lunInfoFromHost.marker_sd_num = nArray[2];
            lunInfoFromHost.marker_tod = (long)nArray[3] << 32;
            lunInfoFromHost.marker_tod |= (long)nArray[4] & 0xFFFFFFFFL;
        } else {
            common.ptod("ConcatMarkers: Invalid marker read for lun '%s'", lunInfoFromHost.lun);
            common.ptod("marker0: %08x", nArray[0]);
            common.ptod("marker1: %08x", nArray[1]);
            common.ptod("marker2: %08x", nArray[2]);
            common.ptod("marker3: %08x", nArray[3]);
            common.ptod("marker4: %08x", nArray[4]);
            Native.freeBuffer(4096, l3);
            return;
        }
        Native.closeFile(l4);
        Native.freeBuffer(4096, l3);
    }

    public static void verifyMarkerResults(Vector<InfoFromHost> vector) {
        int n = vector.get((int)0).luns_on_host.size();
        for (int i = 0; i < vector.size(); ++i) {
            for (InfoFromHost object22 : vector) {
                if (object22.luns_on_host.size() == n) continue;
                ConcatMarkers.error("ConcatMarkers: mismatch in the amount of luns available on all hosts", new Object[0]);
            }
        }
        ArrayList<LunInfoFromHost> arrayList = new ArrayList<LunInfoFromHost>(16);
        for (InfoFromHost infoFromHost : vector) {
            for (LunInfoFromHost lunInfoFromHost : infoFromHost.luns_on_host) {
                arrayList.add(lunInfoFromHost);
            }
        }
        int n2 = 0;
        for (LunInfoFromHost lunInfoFromHost : arrayList) {
            if (!lunInfoFromHost.marker_found) {
                common.ptod("ConcatMarkers: No valid SD Concatenation marker found for host=%s,lun=%s", lunInfoFromHost.host_name, lunInfoFromHost.lun);
                ++n2;
                continue;
            }
            if (lunInfoFromHost.marker_tod == marker_tod) continue;
            common.ptod("ConcatMarkers: Timestamp mismatch found for host=%s,lun=%s", lunInfoFromHost.host_name, lunInfoFromHost.lun);
            common.ptod("ConcatMarkers: Timestamp expected: " + new Date(marker_tod));
            common.ptod("ConcatMarkers: Timestamp found:    " + new Date(lunInfoFromHost.marker_tod));
            ++n2;
        }
        if (n2 > 0) {
            ConcatMarkers.error("ConcatMarkers: SD Concatenation errors found", new Object[0]);
        }
        Object var4_10 = null;
        for (InfoFromHost infoFromHost : vector) {
            if (!infoFromHost.host_label.equals(local_host.getLabel())) continue;
            InfoFromHost infoFromHost2 = infoFromHost;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(4);
        ArrayList<String> arrayList3 = new ArrayList<String>(4);
        ArrayList<String> arrayList4 = new ArrayList<String>(4);
        ArrayList<String> arrayList5 = new ArrayList<String>(4);
        for (InfoFromHost infoFromHost : vector) {
            Host host = Host.findHost(infoFromHost.host_label);
            for (LunInfoFromHost lunInfoFromHost : infoFromHost.luns_on_host) {
                String[] stringArray = host.getSdNamesForLun(lunInfoFromHost.lun);
                if (stringArray.length == 0) {
                    common.ptod("ConcatMarkers: Expecting an SD name for host=%s,lun=%s", lunInfoFromHost.host_name, lunInfoFromHost.lun);
                    ++n2;
                    continue;
                }
                if (stringArray.length > 1) {
                    common.ptod("ConcatMarkers: Expecting only ONE SD name for host=%s,lun=%s", lunInfoFromHost.host_name, lunInfoFromHost.lun);
                    ++n2;
                    continue;
                }
                String string = stringArray[0];
                SD_entry sD_entry = SD_entry.findSD(string);
                if (sD_entry == null) {
                    common.ptod("ConcatMarkers: Can not find sd=%s", string);
                    ++n2;
                    continue;
                }
                if (lunInfoFromHost.marker_sd_num == (long)sD_entry.relative_sd_num) continue;
                common.ptod("ConcatMarkers: Defined SD order mismatch between sd=%s,host=%s,lun=%s ", sD_entry.sd_name, local_host.getLabel(), local_host.getLunNameForSd(sD_entry));
                String string2 = "%" + (45 + sD_entry.sd_name.length()) + "s";
                common.ptod(string2 + " sd=%s,host=%s,lun=%s ", "", sD_entry.sd_name, infoFromHost.host_label, host.getLunNameForSd(sD_entry));
                boolean bl = false;
                for (LunInfoFromHost lunInfoFromHost2 : infoFromHost.luns_on_host) {
                    if (lunInfoFromHost2.marker_sd_num != (long)sD_entry.relative_sd_num) continue;
                    if (bl) {
                        common.failure("Duplicate 'replace SD order' found");
                    }
                    bl = true;
                    arrayList2.add(host.getLabel());
                    arrayList3.add(string);
                    arrayList4.add(lunInfoFromHost.lun);
                    arrayList5.add(lunInfoFromHost2.lun);
                }
            }
        }
        if (n2 > 0) {
            ConcatMarkers.error("ConcatMarkers: SD Concatenation errors found", new Object[0]);
        }
        if (arrayList2.size() == 0) {
            return;
        }
        common.ptod("");
        common.ptod("ConcatMarkers: SD/lun ordering before correction:");
        for (SD_entry sD_entry : Vdbmain.sd_list) {
            int n3 = 0;
            for (Host host : Host.getDefinedHosts()) {
                if (!sD_entry.sd_is_referenced || sD_entry.concatenated_sd) continue;
                if (n3++ == 0) {
                    common.ptod("ConcatMarkers: sd=%s,host=%s,lun=%s,", sD_entry.sd_name, host.getLabel(), host.getLunNameForSd(sD_entry));
                    continue;
                }
                common.ptod("ConcatMarkers: %" + (sD_entry.sd_name.length() + 4) + "shost=%s,lun=%s", "", host.getLabel(), host.getLunNameForSd(sD_entry));
            }
        }
        common.ptod("");
        for (int i = 0; i < arrayList2.size(); ++i) {
            Host host = Host.findHost((String)arrayList2.get(i));
            String string = (String)arrayList3.get(i);
            Iterator<Host> iterator = (String)arrayList4.get(i);
            String string3 = (String)arrayList5.get(i);
            host.replaceLunForSd(string, string3);
            common.ptod("ConcatMarkers: sd=%s,host=%s replaced lun=%s with lun=%s ", string, host.getLabel(), iterator, string3);
        }
        common.ptod("");
        common.ptod("ConcatMarkers: SD/lun ordering after correction:");
        for (SD_entry sD_entry : Vdbmain.sd_list) {
            int n4 = 0;
            for (Host host : Host.getDefinedHosts()) {
                if (!sD_entry.sd_is_referenced || sD_entry.concatenated_sd) continue;
                if (n4++ == 0) {
                    common.ptod("ConcatMarkers: sd=%s,host=%s,lun=%s,", sD_entry.sd_name, host.getLabel(), host.getLunNameForSd(sD_entry));
                    continue;
                }
                common.ptod("ConcatMarkers: %" + (sD_entry.sd_name.length() + 4) + "shost=%s,lun=%s", "", host.getLabel(), host.getLunNameForSd(sD_entry));
            }
        }
        common.ptod("");
    }

    private static void error(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        BoxPrint boxPrint = new BoxPrint();
        boxPrint.add("", new Object[0]);
        boxPrint.add(string2, new Object[0]);
        boxPrint.add("", new Object[0]);
        boxPrint.add("SD concatenation writes a 'marker' to each lun so that we can be assured ", new Object[0]);
        boxPrint.add("that the SD names and lun names identified across all hosts match.", new Object[0]);
        boxPrint.add("", new Object[0]);
        boxPrint.add("This will also CORRECT any discrepancies in possibly accidental", new Object[0]);
        boxPrint.add("out-of-sequence sd/lun/host combinations defined in the parameter file.", new Object[0]);
        boxPrint.add("", new Object[0]);
        boxPrint.add("", new Object[0]);
        boxPrint.print();
        common.failure(string2);
    }
}

