/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.SlaveList;
import Vdb.SlaveOnMaster;
import Vdb.SlaveSocket;
import Vdb.Status;
import Vdb.common;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;

public class ConnectSlaves {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static ServerSocket server_socket_to_slaves = null;

    public static void createSocketToSlaves() {
        int n = 0;
        int n2 = 8;
        while (true) {
            try {
                server_socket_to_slaves = new ServerSocket(SlaveSocket.getMasterPort());
                server_socket_to_slaves.setSoTimeout(100);
            }
            catch (IOException iOException) {
                common.ptod("Unable to listen on port " + SlaveSocket.getMasterPort() + ". Possibly caused by running multiple Vdbench tests concurrently.");
                if (++n == n2) {
                    common.ptod("");
                    common.ptod("A total of %d attempts to find an available port has been made. Vdbench is giving up. ", n2);
                    common.ptod("");
                    common.failure(iOException);
                }
                SlaveSocket.setMasterPort(SlaveSocket.getMasterPort() + 1);
                common.ptod("Trying again on port " + SlaveSocket.getMasterPort());
                continue;
            }
            break;
        }
    }

    public static void connectToSlaves() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        while (true) {
            if (SlaveList.waitForConnections()) {
                try {
                    server_socket_to_slaves.close();
                }
                catch (Exception exception) {
                    common.failure(exception);
                }
                break;
            }
            SlaveList.allDead();
            l = common.signal_caller(l, 10000L);
            if (l == 0L) {
                SlaveList.displayConnectWait();
            }
            if (System.currentTimeMillis() - l2 > 120000L) {
                common.failure("Terminating attempt to connect to slaves.");
            }
            try {
                SlaveSocket slaveSocket = new SlaveSocket(server_socket_to_slaves);
                SlaveOnMaster slaveOnMaster = new SlaveOnMaster();
                slaveOnMaster.setSocket(slaveSocket);
                slaveOnMaster.start();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                common.failure(iOException);
            }
        }
        Status.printStatus("Slaves connected", new Object[0]);
    }
}

