/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.FsdEntry;
import Vdb.common;
import java.io.Serializable;
import java.util.HashMap;

public class CurlHandling
implements Serializable {
    private static final String c = "Copyright (c) 2000-2008 Sun Microsystems, Inc. All Rights Reserved.";
    private String cloud_url = null;
    private String cloud_user = null;
    private String cloud_pwd = null;
    private String container = null;
    private String stor_url = null;
    private String auth_token = null;
    public HashMap<String, String> file_map = new HashMap(1000);

    public CurlHandling(FsdEntry fsdEntry) {
        this.cloud_url = fsdEntry.cloud_url;
        this.cloud_user = fsdEntry.cloud_user;
        this.cloud_pwd = fsdEntry.cloud_pwd;
        this.container = fsdEntry.name;
    }

    public void getAuthorization() {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -s -i %s/ -X LIST -H 'X-Auth-User: %s' -H 'X-Auth-Key: %s'", this.cloud_url, this.cloud_user, this.cloud_pwd);
        oS_cmd.execute();
        oS_cmd.printStderr();
        oS_cmd.printStdout();
        String string = oS_cmd.getHttpCode();
        if (string == null || !string.equals("200 OK")) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("failure getting authorization %s %s %s", this.cloud_url, this.cloud_user, "xxxpassword");
        }
        for (String string2 : oS_cmd.getStdout()) {
            String[] stringArray = string2.split(" +");
            if (stringArray[0].equalsIgnoreCase("X-Storage-Url:")) {
                this.stor_url = stringArray[1];
                continue;
            }
            if (!stringArray[0].equalsIgnoreCase("X-Auth-Token:")) continue;
            this.auth_token = "X-Auth-Token:" + stringArray[1];
        }
        common.ptod("stor_url: " + this.stor_url);
        common.ptod("auth_token: " + this.auth_token);
    }

    public void listContainer() {
        common.ptod("listContainer: " + this.container);
        this.file_map = new HashMap(1000);
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -i -s -X GET -H %s %s%s", this.auth_token, this.stor_url, this.container);
        oS_cmd.execute();
        String string = oS_cmd.getHttpCode();
        if (!string.equals("200 OK") && !string.equals("204 No Content")) {
            common.ptod("There are %,d objects ", this.file_map.size());
            return;
        }
        String[] stringArray = oS_cmd.getStdout();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() != 0) continue;
            ++i;
            while (i < stringArray.length) {
                string2 = stringArray[i];
                this.file_map.put("/" + string2, "/" + string2);
                ++i;
            }
        }
        common.ptod("There are %,d objects ", this.file_map.size());
    }

    public void uploadFile(String string) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -i -s  -X PUT -H Expect: -H %s %s%s%s -T %s", this.auth_token, this.stor_url, this.container, string, string);
        oS_cmd.execute(false);
        String string2 = oS_cmd.getHttpCode();
        if (!string2.equals("201 Created")) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("uploadFile failed for file %s", string);
        }
    }

    public void downloadFile(String string) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -D-  -s  -X GET -H %s %s%s%s -o %s", this.auth_token, this.stor_url, this.container, string, string);
        oS_cmd.execute(true);
        String string2 = oS_cmd.getHttpCode();
        if (!string2.equals("200 OK")) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("downloadFile failed for file %s", string);
        }
    }

    private void deleteFile(String string) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -s -X DELETE -H %s %s/%s/%s", this.auth_token, this.stor_url, this.container, string);
        oS_cmd.execute(false);
        if (!oS_cmd.getRC()) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("failure deleting object %s/%s/%s", this.stor_url, this.container, string);
        }
    }

    public void createContainer() {
        common.ptod("createContainer: " + this.container);
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -i -s -X PUT -H %s %s%s", this.auth_token, this.stor_url, this.container);
        oS_cmd.execute(true);
        String string = oS_cmd.getHttpCode();
        if (string.equals("201 Created")) {
            return;
        }
        if (!oS_cmd.getRC()) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("failure creating container %s/%s", this.stor_url, this.container);
        }
    }

    public void deleteContainer() {
        common.ptod("deleteContainer: " + this.container);
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("curl -i -s -X DELETE -H %s %s%s", this.auth_token, this.stor_url, this.container);
        oS_cmd.execute(true);
        String string = oS_cmd.getHttpCode();
        if (string.equals("404 Not Found") || string.equals("204 No Content")) {
            return;
        }
        if (!oS_cmd.getRC()) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("failure deleting container %s/%s", this.stor_url, this.container);
        }
    }
}

