/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Getopt;
import Vdb.DataBlock;
import Vdb.DvKeyBlock;
import Vdb.Native;
import Vdb.PostGui;
import Vdb.Sector;
import Vdb.common;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class DVPost {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static HashMap<String, DvKeyBlock> bad_keyblock_map = new HashMap(128);
    private static HashMap<String, Integer> lun_keyblock_map = new HashMap(128);
    private static HashMap<String, DataBlock> data_block_map = new HashMap(128);
    private static int linecount = 0;
    private static int sectorcount = 0;
    private static Fget fg;
    private static String line;
    private static ArrayList<String> overview;
    protected static String name_mask;
    private static int duplicates;
    private static String first_failure_date;
    private static SimpleDateFormat df;

    public static void print(String string) {
        overview.add(string);
    }

    public static void print(String string, Object ... objectArray) {
        overview.add(String.format(string, objectArray));
    }

    public static void main(String[] stringArray) {
        Getopt getopt = new Getopt(stringArray, "db", 2);
        getopt.print("DVPost");
        if (!getopt.isOK()) {
            common.failure("Parameter scan error");
        }
        String string = ".";
        if (getopt.get_positionals().size() > 0) {
            string = getopt.get_positional(0);
        }
        Native.allocSharedMemory();
        common.ignoreIfNoPlog();
        if (stringArray.length > 1) {
            string = stringArray[1];
        } else {
            string = PostGui.askForFile(".", "Enter errorlog.html file name");
            if (string == null) {
                return;
            }
        }
        try {
            Object object;
            DvKeyBlock dvKeyBlock = null;
            if (Fget.dir_exists(string)) {
                string = new File(string, "errorlog.html").getAbsolutePath();
            }
            fg = new Fget(string);
            while ((line = fg.get()) != null) {
                ++linecount;
                if (line.contains("op:")) {
                    DVPost.foundErrorLine();
                    continue;
                }
                if (line.contains("Time of first failure:")) {
                    object = line.split(" +");
                    first_failure_date = String.format("%s %s %s %s", object[6], object[7], object[8], object[9]);
                    continue;
                }
                if (!line.contains("dvpost:")) continue;
                dvKeyBlock = new DvKeyBlock();
                object = line.split(" +");
                dvKeyBlock.lun = object[3];
                dvKeyBlock.sd_wanted = object[4];
                dvKeyBlock.file_start_lba = Long.parseLong(((String)object[6]).substring(2), 16);
                dvKeyBlock.file_lba = Long.parseLong(((String)object[7]).substring(2), 16);
                dvKeyBlock.key_block_size = Integer.parseInt((String)object[8]);
                dvKeyBlock.key_wanted = Integer.parseInt(((String)object[12]).substring(2), 16);
                dvKeyBlock.sectors = new Sector[dvKeyBlock.key_block_size / 512];
                dvKeyBlock.logical_lba = dvKeyBlock.file_start_lba + dvKeyBlock.file_lba;
                if (first_failure_date != null) {
                    dvKeyBlock.block_first_seen = df.parse(first_failure_date + " " + (String)object[0]);
                }
                int n = Integer.parseInt(((String)object[9]).substring(2), 16) * 512;
                long l = ((String)object[10]).substring(2).equals("ffffffffffffffff") ? 0L : Long.parseLong(((String)object[10]).substring(2), 16);
                int n2 = Integer.parseInt(((String)object[11]).substring(2), 16);
                int n3 = Integer.parseInt(((String)object[13]).substring(2), 16);
                dvKeyBlock.dvpost_date = new Date(l / 1000L);
                if (lun_keyblock_map.get(dvKeyBlock.lun) == null) {
                    lun_keyblock_map.put(dvKeyBlock.lun, dvKeyBlock.key_block_size);
                }
                try {
                    if ((dvKeyBlock = DVPost.haveBadSector(dvKeyBlock, n)) != null) continue;
                }
                catch (Exception exception) {
                    common.ptod("Exception, treating it as end-of-file");
                    common.ptod(exception);
                    break;
                }
            }
            if (duplicates > 0) {
                common.failure("%d duplicate blocks found", duplicates);
            }
            if (bad_keyblock_map.size() == 0) {
                common.failure("No bad blocks found. No 'dvpost:' lines found?");
            }
            DVPost.reportSomeSectorStuff();
            if (!getopt.check('b')) {
                object = new PostGui(string, DVPost.sortBlocks("lun"), overview);
                ((Window)object).setVisible(true);
                ((Component)object).repaint();
                return;
            }
            for (String string2 : overview) {
                System.out.println(string2);
            }
        }
        catch (Exception exception) {
            DVPost.print("linecount: " + linecount);
            DVPost.print("line: " + line);
            common.failure(exception);
        }
    }

    private static DvKeyBlock haveBadSector(DvKeyBlock dvKeyBlock, int n) {
        int n2;
        Object object;
        String string = dvKeyBlock.lun + " " + dvKeyBlock.logical_lba;
        DvKeyBlock dvKeyBlock2 = bad_keyblock_map.get(string);
        if (dvKeyBlock2 == null) {
            dvKeyBlock2 = dvKeyBlock;
            bad_keyblock_map.put(string, dvKeyBlock2);
            if (dvKeyBlock2.first_dvpost_line_tod == null) {
                dvKeyBlock2.first_dvpost_line_tod = line.split(" ")[0];
            }
        }
        String string2 = line.split(" ")[0];
        String[] stringArray = DVPost.splitLine();
        dvKeyBlock2.raw_input.add("");
        dvKeyBlock2.raw_input.add(line);
        while ((line = fg.get()) != null) {
            ++linecount;
            if (line.contains("The sector below was written") && dvKeyBlock2.first_sector_written_tod == null) {
                dvKeyBlock2.first_sector_written_tod = DVPost.parseWrittenDate(line);
            }
            stringArray = DVPost.splitLine();
            dvKeyBlock2.raw_input.add(line);
            if (stringArray.length == 0) continue;
            if (line.contains("Time that this block")) {
                object = null;
                if (line.contains("read:")) {
                    dvKeyBlock2.last_valid_rw = "read";
                    object = line.substring(line.indexOf("read:") + 5).trim();
                } else {
                    dvKeyBlock2.last_valid_rw = "write";
                    object = line.substring(line.indexOf("write:") + 6).trim();
                }
                if (dvKeyBlock2.last_tod_valid == null) {
                    dvKeyBlock2.last_tod_valid = object;
                } else if (!((String)object).equalsIgnoreCase(dvKeyBlock2.last_tod_valid)) {
                    dvKeyBlock2.last_tod_valid = "mixed";
                }
                dvKeyBlock2.last_valid = DVPost.parseLastDate(dvKeyBlock2.last_tod_valid);
            }
            if (!stringArray[0].equals("0x000") && !stringArray[0].equals("0x000*")) continue;
        }
        object = new String[32];
        String[] stringArray2 = DVPost.splitLine();
        object[0] = line;
        int n3 = 1;
        for (int i = 16; i < 512 && (line = fg.get()) != null; i += 16) {
            ++linecount;
            dvKeyBlock2.raw_input.add(line.substring(26));
            stringArray = DVPost.splitLine();
            String string3 = String.format("0x%03x", i);
            if (!stringArray[0].startsWith(string3)) break;
            object[i / 16] = line;
            ++n3;
        }
        Sector sector = new Sector();
        sector.lba_wanted = dvKeyBlock2.logical_lba + (long)n;
        sector.tod_in_sector = dvKeyBlock2.dvpost_date;
        dvKeyBlock2.sectors[n / 512] = sector;
        ++dvKeyBlock2.sectors_reported;
        for (n2 = 0; n2 < n3; ++n2) {
            line = object[n2];
            stringArray = ((String)line).trim().split(" +");
            if (stringArray[3].equals("........")) {
                stringArray[4] = "33333333";
                stringArray[3] = "33333333";
            } else if (stringArray[1].indexOf("..") != -1) {
                stringArray[1] = stringArray[1].substring(0, 2) + "33" + stringArray[1].substring(4);
            }
            sector.expected[n2 * 4 + 0] = (int)Long.parseLong(stringArray[1], 16) >>> 32;
            sector.expected[n2 * 4 + 1] = (int)Long.parseLong(stringArray[2], 16) >>> 32;
            sector.expected[n2 * 4 + 2] = (int)Long.parseLong(stringArray[3], 16) >>> 32;
            sector.expected[n2 * 4 + 3] = (int)Long.parseLong(stringArray[4], 16) >>> 32;
            sector.was_read[n2 * 4 + 0] = (int)Long.parseLong(stringArray[5], 16) >>> 32;
            sector.was_read[n2 * 4 + 1] = (int)Long.parseLong(stringArray[6], 16) >>> 32;
            sector.was_read[n2 * 4 + 2] = (int)Long.parseLong(stringArray[7], 16) >>> 32;
            sector.was_read[n2 * 4 + 3] = (int)Long.parseLong(stringArray[8], 16) >>> 32;
            if (n2 != 0) continue;
            try {
                sector.lba_read = Long.parseLong(stringArray[5] + stringArray[6], 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                DVPost.print("Unparsable lba. Needs further investigation: %s %s", stringArray[5], stringArray[6]);
                sector.lba_read = -1L;
            }
        }
        sector.sd_wanted = dvKeyBlock2.sd_wanted;
        sector.sd_read = DVPost.xlateSD(sector.was_read[5], sector.was_read[6], dvKeyBlock2.sd_wanted, (String)object[1]);
        if (sector.sd_read.length() == 0) {
            common.ptod("line: " + line);
            common.failure("empty sd");
        }
        dvKeyBlock2.key_wanted = sector.key_wanted = sector.expected[4] >> 24;
        dvKeyBlock2.key_read = sector.key_read = sector.was_read[4] >> 24;
        dvKeyBlock2.different_words_in_block += sector.countDifferences();
        if (sector.lba_wanted != sector.lba_read) {
            sector.getBadLbaData();
        }
        for (n2 = 99990; n2 < 32; ++n2) {
            DVPost.print("              %08x %08x %08x %08x   %08x %08x %08x %08x ", sector.expected[n2 * 4 + 0], sector.expected[n2 * 4 + 1], sector.expected[n2 * 4 + 2], sector.expected[n2 * 4 + 3], sector.was_read[n2 * 4 + 0], sector.was_read[n2 * 4 + 1], sector.was_read[n2 * 4 + 2], sector.was_read[n2 * 4 + 3]);
        }
        return dvKeyBlock2;
    }

    private static void foundErrorLine() {
        String[] stringArray = line.trim().split(" +");
        long l = Long.parseLong(stringArray[8]);
        String string = stringArray[6];
        String string2 = string + " " + l;
        if (!stringArray[13].equals("60003")) {
            return;
        }
        if (data_block_map.get(string2) != null) {
            common.ptod("Duplicate i/o error reported: " + string2);
            ++duplicates;
            return;
        }
        DataBlock dataBlock = new DataBlock();
        data_block_map.put(string2, dataBlock);
        dataBlock.logical_lba = l;
        dataBlock.lun = string;
        dataBlock.key_blocksize = lun_keyblock_map.get(string);
        dataBlock.data_xfersize = Integer.parseInt(stringArray[11]);
        dataBlock.failure = stringArray[2];
        DvKeyBlock dvKeyBlock = bad_keyblock_map.get(string2);
        if (dvKeyBlock == null) {
            DVPost.print("Found an i/o error for an lba which was not reported by Data Validation:");
            DVPost.print("This can mean that the first Key block of a data block was NOT in error!");
            String string3 = common.replace(line, "  ", " ");
            DVPost.print(string3.substring(string3.indexOf("op:")));
            DVPost.print("");
            return;
        }
        dvKeyBlock.failed_operation = stringArray[4];
        dvKeyBlock.error_code = Integer.parseInt(stringArray[13]);
        if (dvKeyBlock.error_code != 60003 && dvKeyBlock.error_code != 803) {
            DVPost.bad("Invalid i/o error code: " + dvKeyBlock.error_code);
        }
    }

    private static String xlateSD(long l, long l2, String string, String string2) {
        if (l == 0L || l2 == 0L) {
            return "nulls";
        }
        if (l == -1L || l2 == -1L) {
            return "neg-1";
        }
        String string3 = "";
        string3 = string3 + (char)(l >>> 24 & 0xFFL);
        string3 = string3 + (char)(l >>> 16 & 0xFFL);
        string3 = string3 + (char)(l >>> 8 & 0xFFL);
        string3 = string3 + (char)(l >>> 0 & 0xFFL);
        string3 = string3 + (char)(l2 >>> 24 & 0xFFL);
        string3 = string3 + (char)(l2 >>> 16 & 0xFFL);
        string3 = string3 + (char)(l2 >>> 8 & 0xFFL);
        string3 = string3 + (char)(l2 >>> 0 & 0xFFL);
        if ((string3 = string3.trim()).equals(string)) {
            return string;
        }
        String string4 = "";
        for (int i = string3.length() - 1; i >= 0; --i) {
            string4 = string4 + string3.charAt(i);
        }
        if (string4.equals(string)) {
            return string;
        }
        if (string4.startsWith("sd") || string4.startsWith("SD")) {
            return string4;
        }
        if (string3.length() == 0) {
            return "'blanks'";
        }
        return string3;
    }

    private static void reportSomeSectorStuff() {
        name_mask = DVPost.getLunNameMask();
        DVPost.reportBadKeyBlockStatus();
        DVPost.reportDataBlockStuff();
        DVPost.reportErrorCodes();
        DVPost.reportHighDeltas();
        DVPost.reportWrongKeys();
        DVPost.reportTimestamps();
        DVPost.reportSingleBitErrors();
        DVPost.reportSdNameWrong();
        DVPost.reportWrongLbas();
    }

    private static DvKeyBlock[] sortBlocks(String string) {
        Object[] objectArray = bad_keyblock_map.values().toArray(new DvKeyBlock[0]);
        DvKeyBlock.sort_order = string;
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static void reportErrorCodes() {
        DvKeyBlock dvKeyBlock;
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            dvKeyBlock = dvKeyBlockArray[n];
            if (dvKeyBlock.error_code == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        DVPost.print("\n\n");
        DVPost.print("Blocks that have completed their error reporting: ");
        DVPost.print("%s %s", DvKeyBlock.header(), "error");
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            dvKeyBlock = dvKeyBlockArray[n];
            if (dvKeyBlock.error_code <= 0) continue;
            DVPost.print("%s %d", dvKeyBlock.print(), dvKeyBlock.error_code);
        }
    }

    private static void reportBadKeyBlockStatus() {
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        DVPost.print("\n\n");
        DVPost.print("Bad Key Block status:");
        DVPost.print("%s %s", DvKeyBlock.header(), "Errors");
        for (int i = 0; i < dvKeyBlockArray.length; ++i) {
            DvKeyBlock dvKeyBlock = dvKeyBlockArray[i];
            DVPost.print("%s %s", dvKeyBlock.print(), dvKeyBlock.getBlockStatusShort());
        }
    }

    private static void reportTimestamps() {
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        DVPost.print("\n\n");
        DVPost.print("Timestamps of 'last write' found in Key block:");
        DVPost.print("%s %s", DvKeyBlock.header(), "Timestamp found / last");
        HashMap hashMap = new HashMap(16);
        for (int i = 0; i < dvKeyBlockArray.length; ++i) {
            DvKeyBlock dvKeyBlock = dvKeyBlockArray[i];
            String string = dvKeyBlock.getTimestamps();
            if (dvKeyBlock.last_tod_valid != null) {
                string = string + " " + dvKeyBlock.last_tod_valid;
            }
            DVPost.print("%s %s", dvKeyBlock.print(), string);
        }
    }

    private static void reportWrongKeys() {
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            if (dvKeyBlockArray[n].getWrongKeys() == null) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Blocks that have at least one wrong key: ");
            DVPost.print("%s %s", DvKeyBlock.header(), "(Expected) read high_delta");
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                DvKeyBlock dvKeyBlock = dvKeyBlockArray[n];
                String string = dvKeyBlock.getWrongKeys();
                String string2 = "";
                int n3 = dvKeyBlock.getHighestKeyDelta();
                if (n3 > 1) {
                    string2 = "delta " + n3;
                }
                if (string == null) continue;
                DVPost.print("%s (%02x) %s %s", dvKeyBlock.print(), dvKeyBlock.key_wanted, string, string2);
            }
        }
    }

    private static void reportHighDeltas() {
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            if (dvKeyBlockArray[n].getWrongKeys() == null) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Key blocks that have at least TWO key delta: ");
            DVPost.print("%s %s", DvKeyBlock.header(), "(Expected) read");
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                int n3;
                DvKeyBlock dvKeyBlock = dvKeyBlockArray[n];
                String string = dvKeyBlock.getWrongKeys();
                if (string == null || (n3 = dvKeyBlock.getHighestKeyDelta()) < 2) continue;
                DVPost.print("%s (%02x) %s delta=%d", dvKeyBlock.print(), dvKeyBlock.key_wanted, string, n3);
            }
        }
    }

    private static void reportWrongLbas() {
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            if (dvKeyBlockArray[n].getWrongLbas() == null) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Key blocks that have at least one wrong lba in their data:");
            DVPost.print("%s %s", DvKeyBlock.header(), "bad lba");
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                DvKeyBlock dvKeyBlock = dvKeyBlockArray[n];
                String string = dvKeyBlock.getWrongLbas();
                if (string == null) continue;
                DVPost.print("%s %s", dvKeyBlock.print(), string);
            }
        }
    }

    private static void reportDataBlockStuff() {
        String string = name_mask + " %10s %10s %10s %9s %9s %5s %7s %5s %12s %7s";
        String string2 = name_mask + " %10x %10x %10x %9d %9d %5d %7d %5d %12s %7s";
        String string3 = String.format(string, "lun/file", "log_lba", "start_lba", "file_lba", "xfersize", "keyblocks", "(bad)", "sectors", "(bad)", "error_time", "flag");
        DVPost.print("");
        DVPost.print("Data block information. A data block is divided into 'n' Key blocks, each Key block is divided into 512-byte sectors");
        DVPost.print("");
        DVPost.print(string3);
        DVPost.print("");
        Object[] objectArray = data_block_map.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string4;
            DataBlock dataBlock = data_block_map.get(object);
            int n = dataBlock.data_xfersize / dataBlock.key_blocksize;
            int n2 = dataBlock.data_xfersize / 512;
            int n3 = 0;
            int n4 = 0;
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                string4 = dataBlock.lun + " " + (dataBlock.logical_lba + (long)(i * dataBlock.key_blocksize));
                DvKeyBlock dvKeyBlock = bad_keyblock_map.get(string4);
                if (dvKeyBlock == null) continue;
                l = dvKeyBlock.file_start_lba;
                ++n3;
                for (Sector sector : dvKeyBlock.sectors) {
                    if (sector == null) continue;
                    ++n4;
                }
            }
            String string5 = n2 == n4 ? "" : "partial";
            string4 = String.format(string2, dataBlock.lun, dataBlock.logical_lba, l, dataBlock.logical_lba - l, dataBlock.data_xfersize, n, n3, n2, n4, dataBlock.failure, string5);
            DVPost.print(string4);
        }
    }

    private static String getLunNameMask() {
        String[] stringArray;
        int n = 1;
        for (String string : stringArray = data_block_map.keySet().toArray(new String[0])) {
            n = Math.max(n, DVPost.data_block_map.get((Object)string).lun.length());
        }
        return "%-" + n + "s";
    }

    private static void reportSingleBitErrors() {
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            if (dvKeyBlockArray[n].countSingleBitWords() <= 0) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Single bit errors: Blocks that have single bit errors beyond the 32-byte header:");
            DVPost.print("(Single bit error: if any 32-bit word is only one bit off)");
            DVPost.print("%s", DvKeyBlock.header());
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                DvKeyBlock dvKeyBlock = dvKeyBlockArray[n];
                if (dvKeyBlock.countSingleBitWords() == 0) continue;
                DVPost.print("%s", dvKeyBlock.print());
            }
        }
    }

    private static void reportSdNameWrong() {
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            if (dvKeyBlockArray[n].getWrongSdNames() == null) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Mismatch in SD name:");
            DVPost.print("%s %s", DvKeyBlock.header(), "mismatch(es)");
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                DvKeyBlock dvKeyBlock = dvKeyBlockArray[n];
                String string = dvKeyBlock.getWrongSdNames();
                if (string == null) continue;
                DVPost.print("%-20s %s", dvKeyBlock.print(), string);
            }
        }
    }

    private static void reportAllSectorsBad() {
        DvKeyBlock dvKeyBlock;
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            dvKeyBlock = dvKeyBlockArray[n];
            if (dvKeyBlock.key_block_size / 512 != dvKeyBlock.sectors_reported) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Blocks that have differences in all sectors:");
            DVPost.print("%s", DvKeyBlock.header());
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                dvKeyBlock = dvKeyBlockArray[n];
                if (dvKeyBlock.key_block_size / 512 != dvKeyBlock.sectors_reported) continue;
                DVPost.print("%s", dvKeyBlock.print());
            }
        }
    }

    private static void reportSomeSectorsBad(boolean bl) {
        DvKeyBlock dvKeyBlock;
        int n;
        DvKeyBlock[] dvKeyBlockArray = DVPost.sortBlocks("lun");
        int n2 = 0;
        for (n = 0; n < dvKeyBlockArray.length; ++n) {
            dvKeyBlock = dvKeyBlockArray[n];
            if (bl && dvKeyBlock.failed_operation == null || !bl && dvKeyBlock.failed_operation != null || dvKeyBlock.key_block_size / 512 == dvKeyBlock.sectors_reported) continue;
            ++n2;
        }
        if (n2 > 0) {
            DVPost.print("\n\n");
            DVPost.print("Incomplete blocks that have differences in some sectors:");
            if (!bl) {
                DVPost.print("Since not all sectors have been reported by DV due to the data_errors= limit ");
                DVPost.print("this does not mean that these blocks may not have more bad sectors.");
                DVPost.print("(No 'op:' i/o error message was reported for this block).");
            }
            DVPost.print("%s %s", DvKeyBlock.header(), "sectors");
            for (n = 0; n < dvKeyBlockArray.length; ++n) {
                dvKeyBlock = dvKeyBlockArray[n];
                if (dvKeyBlock.key_block_size / 512 == dvKeyBlock.sectors_reported) continue;
                DVPost.print("%s %s", dvKeyBlock.print(), dvKeyBlock.getBadSectors());
            }
        }
    }

    private static void bad(String string) {
        DVPost.print("\n\n");
        DVPost.print("Last line read: " + linecount);
        DVPost.print("bad line:");
        DVPost.print(line);
        common.failure(string);
    }

    private static String[] splitLine() {
        line = line.substring(line.indexOf(": ") + 2).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(line.trim(), " ;'");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        for (int i = 99990; i < stringArray.length; ++i) {
            System.out.println("stuff: " + i + " " + stringArray[i]);
        }
        return stringArray;
    }

    public static Date parseLastDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE MMMM d HH:mm:ss zzz yyyy");
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date parseWrittenDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy HH:mm:ss.SSS zzz");
            String string2 = string.substring(string.indexOf(",") + 2);
            return simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy HH:mm:ss.SSS");
                String string3 = string.substring(string.indexOf(",") + 2);
                return simpleDateFormat.parse(string3);
            }
            catch (ParseException parseException2) {
                common.ptod(parseException2);
                return null;
            }
        }
    }

    static {
        overview = new ArrayList(256);
        name_mask = null;
        duplicates = 0;
        first_failure_date = null;
        df = new SimpleDateFormat("EEEE, MMMM d, yyyy HH:mm:ss.SSS");
    }
}

