/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Utils.OS_cmd;
import Vdb.BadDataBlock;
import Vdb.Dedup;
import Vdb.DedupBitMap;
import Vdb.Elapsed;
import Vdb.ErrorLog;
import Vdb.Fifo;
import Vdb.FileAnchor;
import Vdb.Jnl_entry;
import Vdb.MapFile;
import Vdb.MapUnbusyThread;
import Vdb.Native;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Timestamp;
import Vdb.Validate;
import Vdb.common;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;

public class DV_map {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String map_name;
    Jnl_entry journal = null;
    private int key_blksize;
    int map_status;
    long key_blocks;
    long map_length;
    long blocks_in_error = 0L;
    long blocks_busy = 0L;
    long blocks_known = 0L;
    private DedupBitMap flipflop_bitmap = null;
    private MapFile[] byte_maps;
    int map_busy = 0;
    public static final int DV_ERROR = 127;
    public static final int PENDING_KEY_0 = 128;
    public static final int PENDING_WRITE = 129;
    public static final int PENDING_KEY_ROLL = 130;
    public static final int PENDING_KEY_ROLL_DEDUP = 131;
    public static final int PENDING_KEY_REREAD = 132;
    private Timestamp timestamp_map = null;
    long[] pending_write_lbas = null;
    byte[] pending_write_flags = null;
    HashMap<Long, Byte> pending_map = null;
    FileAnchor recovery_anchor = null;
    private int bad_sectors_found = 0;
    private Dedup dedup = null;
    public HashMap<Long, BadDataBlock> bad_data_map = null;
    private Random start_key_randomizer = new Random();
    static Object print_lock = new Object();
    static long compression_seed = 0L;
    static boolean dv_headers_printed = false;
    public static long[] key_reads = new long[256];
    public static long[] key_writes = new long[256];
    private static HashMap<String, DV_map> all_maps = new HashMap(8);

    public DV_map(String string, String string2, long l, int n) {
        this.map_name = string2;
        int n2 = Fifo.getSizeNeeded(0);
        this.key_blksize = n;
        this.key_blocks = l;
        this.map_length = this.key_blocks + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (Validate.isContinueOldMap() && string == null) {
            common.failure("'validate=continue_old_map' also requires 'journal=xxx");
        }
        if (Validate.isRealValidate()) {
            this.byte_maps = Validate.isContinueOldMap() ? MapFile.openOldFile(string, this.map_name, this.map_length) : MapFile.createNewFile(string, this.map_name, this.map_length);
        } else {
            this.flipflop_bitmap = new DedupBitMap().createMapForFlipFlop(this.dedup, this.map_length, this.map_name);
        }
        if (Validate.isStoreTime()) {
            this.timestamp_map = new Timestamp(this.map_length);
        }
        if (Validate.isRealValidate()) {
            ErrorLog.plog("Allocating Data Validation map: %,d one-byte entries for each %,d-byte block.", this.map_length, n);
        }
    }

    public void setDedup(Dedup dedup) {
        this.dedup = dedup;
    }

    public Dedup getDedup() {
        return this.dedup;
    }

    public void deleteByteMapFile() {
        if (this.byte_maps != null) {
            for (MapFile mapFile : this.byte_maps) {
                mapFile.closeMapFile();
                boolean bl = new File(mapFile.getFilename()).delete();
            }
            this.byte_maps = null;
        } else {
            this.flipflop_bitmap = null;
        }
    }

    public synchronized int dv_get(long l) {
        int n = 0;
        if (this.byte_maps != null) {
            long l2 = l / (long)this.key_blksize;
            int n2 = (int)(l2 >> 30);
            int n3 = (int)(l2 & 0x3FFFFFFFL);
            n = this.byte_maps[n2].get(n3);
        } else {
            boolean bl = this.flipflop_bitmap.getBit(l / (long)this.key_blksize);
            n = bl ? 2 : 1;
        }
        return n;
    }

    public int dv_get_nolock(long l) {
        int n = 0;
        if (this.byte_maps != null) {
            long l2 = l / (long)this.key_blksize;
            int n2 = (int)(l2 >> 30);
            int n3 = (int)(l2 & 0x3FFFFFFFL);
            n = this.byte_maps[n2].get(n3);
        } else {
            boolean bl = this.flipflop_bitmap.getBit(l / (long)this.key_blksize);
            n = bl ? 1 : 0;
        }
        return n;
    }

    public synchronized void dv_set(long l, int n) {
        if (n >>> 8 != 0) {
            common.failure("Data validation key larger than 8 bits: %08x", n);
        }
        if (this.byte_maps != null) {
            long l2 = l / (long)this.key_blksize;
            int n2 = (int)(l2 >> 30);
            int n3 = (int)(l2 & 0x3FFFFFFFL);
            int n4 = this.byte_maps[n2].get(n3);
            this.byte_maps[n2].put(n3, n);
            if (n == 127) {
                ++this.blocks_in_error;
            }
        } else if (n == 2) {
            this.flipflop_bitmap.setBit(l / (long)this.key_blksize, true);
        } else {
            this.flipflop_bitmap.setBit(l / (long)this.key_blksize, false);
        }
    }

    public void dv_set_nolock(long l, int n) {
        if (n >>> 8 != 0) {
            common.failure("Data validation key larger than 8 bits: %08x", n);
        }
        if (this.byte_maps != null) {
            long l2 = l / (long)this.key_blksize;
            int n2 = (int)(l2 >> 30);
            int n3 = (int)(l2 & 0x3FFFFFFFL);
            int n4 = this.byte_maps[n2].get(n3);
            this.byte_maps[n2].put(n3, n & 0xFF);
        } else if (n == 0) {
            this.flipflop_bitmap.setBit(l / (long)this.key_blksize, false);
        } else {
            this.flipflop_bitmap.setBit(l / (long)this.key_blksize, true);
        }
    }

    public static DV_map allocateMap(String string, String string2, long l, int n) {
        DV_map dV_map = all_maps.get(string2);
        if (dV_map != null) {
            return dV_map;
        }
        if (l / (long)n == 0L) {
            common.failure("unexpected block count");
        }
        DV_map dV_map2 = new DV_map(string, string2, l / (long)n, n);
        all_maps.put(string2, dV_map2);
        dV_map2.map_name = string2;
        if (Validate.isRealValidate()) {
            ErrorLog.plog("Created new DV map: %s size: %,d bytes; key block size: %d; entries: %,d", string2, l, n, dV_map2.key_blocks);
        }
        return dV_map2;
    }

    public static DV_map findExistingMap(String string) {
        if (all_maps.size() == 0) {
            return null;
        }
        DV_map dV_map = all_maps.get(string);
        if (dV_map != null) {
            return dV_map;
        }
        return null;
    }

    public static DV_map[] getAllMaps() {
        return all_maps.values().toArray(new DV_map[0]);
    }

    public static void removeMap(String string) {
        DV_map dV_map = all_maps.get(string);
        if (dV_map == null) {
            common.failure("Trying to remove unknown map");
        }
        all_maps.remove(string);
    }

    public int getKeyBlockSize() {
        return this.key_blksize;
    }

    public int determineJnlRecoveryXfersize(int n) {
        int n2;
        int n3 = 131072;
        for (n2 = 0; n2 < n3; n2 += this.key_blksize) {
        }
        return n2;
    }

    public synchronized int getKeyAndSetBusy(long l) {
        int n = this.dv_get(l);
        if ((n & 0x7F) == 127) {
            this.map_busy = 0;
            return -1;
        }
        if ((n & 0x80) == 0) {
            this.dv_set(l, n |= 0x80);
            this.map_busy = 0;
            return n & 0x7F;
        }
        if (++this.map_busy > 100) {
            common.sleep_some(1L);
        }
        if (++this.map_busy > 10000) {
            common.failure("Too many 'busy' statuses reported. Likely caused because the target file/volume size is so small that ALL blocks are currently in use");
        }
        return -1;
    }

    public static void dv_set_all_unbusy(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            SD_entry sD_entry = (SD_entry)vector.elementAt(i);
            if (sD_entry.dv_map == null) continue;
            sD_entry.dv_map.setAllUnBusy();
        }
    }

    public synchronized void setAllUnBusy() {
        if (this.byte_maps == null) {
            return;
        }
        Elapsed elapsed = new Elapsed("DV_map.setAllUnbusy");
        ArrayList<MapUnbusyThread> arrayList = new ArrayList<MapUnbusyThread>(8);
        MapFile[] mapFileArray = this.byte_maps;
        int n = mapFileArray.length;
        for (int i = 0; i < n; ++i) {
            MapFile mapFile = mapFileArray[i];
            MapUnbusyThread mapUnbusyThread = new MapUnbusyThread(mapFile);
            arrayList.add(mapUnbusyThread);
            mapUnbusyThread.start();
        }
        while (true) {
            int n2 = 0;
            for (MapUnbusyThread mapUnbusyThread : arrayList) {
                if (!mapUnbusyThread.isAlive()) continue;
                ++n2;
            }
            if (n2 == 0) break;
            common.sleep_some(100L);
        }
        this.blocks_in_error = 0L;
        this.blocks_busy = 0L;
        this.blocks_known = 0L;
        for (MapFile mapFile : this.byte_maps) {
            this.blocks_in_error += mapFile.counter.bad_blocks;
            this.blocks_busy += mapFile.counter.blocks_busy;
            this.blocks_known += mapFile.counter.blocks_known;
        }
        elapsed.end(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dv_increment(int n, long l) {
        if (!Dedup.isDedup()) {
            if (n == 0) {
                return this.getRandomStartKey();
            }
            return n == 126 ? 1 : ++n;
        }
        if (!this.dedup.isFlipFlop() && Dedup.isDuplicate(l)) {
            common.failure("Duplicate set key value should never been incremented without flipflop");
        }
        if (Dedup.isUnique(l)) {
            if (n == 0) {
                return this.getRandomStartKey();
            }
            return n == 126 ? 1 : ++n;
        }
        Dedup dedup = this.dedup;
        synchronized (dedup) {
            ++this.dedup.flipflops;
        }
        if (n == 0) {
            return this.getRandomStartKey();
        }
        return n ^ 1;
    }

    private int getRandomStartKey() {
        int n = this.start_key_randomizer.nextInt();
        if (n == Integer.MIN_VALUE) {
            n = 0;
        }
        return Math.abs(n) % 126 + 1;
    }

    public synchronized int flipflop(int n) {
        ++this.dedup.flipflops;
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 1;
        }
        common.failure("Unexpected flipflop value: " + n);
        return -1;
    }

    public static int dv_decrement(int n) {
        if (n == 1) {
            return 0;
        }
        if (n == 0) {
            common.failure("Trying to decrement a key with a value of zero");
        }
        return n - 1;
    }

    public void eraseMap() {
        common.ptod("Erasing Data Validation map: " + this.map_name);
        for (long i = 0L; i < this.key_blocks; ++i) {
            this.dv_set(i * (long)this.key_blksize, 0);
        }
    }

    public long getLastTimestamp(long l) {
        if (this.timestamp_map == null) {
            return 0L;
        }
        long l2 = this.timestamp_map.getLastTime(l / (long)this.key_blksize);
        return l2;
    }

    public String getLastOperation(long l) {
        if (this.timestamp_map == null) {
            return "n/a";
        }
        String string = this.timestamp_map.getLastOperation(l / (long)this.key_blksize);
        return string;
    }

    public int getLastKey(long l) {
        if (this.timestamp_map == null) {
            return 0;
        }
        int n = this.timestamp_map.getLastKey(l / (long)this.key_blksize);
        return n;
    }

    public synchronized void dv_set_unbusy(long l, int n) throws Exception {
        int n2 = this.dv_get(l);
        if ((n2 & 0x80) == 0) {
            if ((n2 & 0x7F) == 127) {
                return;
            }
            String string = String.format("dv_set_unbusy(): entry not busy: lba: 0x%08x old: %2d new: %2d", l, n2, n);
            throw new Exception(string);
        }
        this.dv_set(l, n & 0x7F);
    }

    public synchronized void setUnbusy(long l) throws Exception {
        int n = this.dv_get(l);
        if ((n & 0x80) == 0) {
            if ((n & 0x7F) == 127) {
                return;
            }
            String string = String.format("dv_set_unbusy(): entry not busy: lba: 0x%08x key: %2d ", l, n);
            common.ptod("txt: " + string);
            throw new Exception(string);
        }
        this.dv_set(l, n & 0x7F);
    }

    public void save_timestamp(long l, long l2, long l3, long l4) {
        if (this.timestamp_map != null) {
            this.timestamp_map.storeTime(l / (long)this.key_blksize, l2, l3, l4);
        }
    }

    public void storeWriteXfer(long l, int n) {
        if (Validate.isXferHistory()) {
            this.timestamp_map.storeWriteXfer(l / (long)this.key_blksize, n);
        }
    }

    public int getWriteXfer(long l) {
        if (this.timestamp_map != null) {
            return this.timestamp_map.getLastXfersize(l / (long)this.key_blksize);
        }
        return 0;
    }

    public static void allocateSDMaps(Vector<SD_entry> vector) {
        for (SD_entry sD_entry : SD_entry.getRealSds(vector)) {
            sD_entry.dv_map = DV_map.findExistingMap(sD_entry.sd_name);
            if (sD_entry.dv_map == null) {
                sD_entry.dv_map = DV_map.allocateMap(sD_entry.jnl_dir_name, sD_entry.sd_name, sD_entry.end_lba, sD_entry.getKeyBlockSize());
                if (Validate.isJournaling() && sD_entry.dv_map.journal == null) {
                    sD_entry.dv_map.journal = new Jnl_entry(sD_entry.sd_name, sD_entry.jnl_dir_name, "sd");
                    sD_entry.dv_map.journal.storeMap(sD_entry.dv_map);
                }
            }
            sD_entry.dv_map.setDedup(sD_entry.dedup);
            if (!common.get_debug(common.ALWAYS_ERASE_MAPS)) continue;
            sD_entry.dv_map.eraseMap();
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        long l = Long.parseLong(string, 16);
        long l2 = Long.parseLong(string2, 16);
        long l3 = l << 32 | l2;
        common.ptod("tod: 0x%x", l3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE, MMMM d, yyyy HH:mm:ss.SSS zzz");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("PST"));
    }

    public boolean anyValidBlocks(long l, long l2) {
        long l3;
        long l4 = l3 + l2;
        for (l3 = l; l3 < l4; l3 += (long)this.key_blksize) {
            if (this.dv_get(l3) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean anyBadBlocks(long l, long l2) {
        long l3;
        long l4 = l3 + l2;
        for (l3 = l; l3 < l4; l3 += (long)this.key_blksize) {
            if (this.dv_get(l3) != 127) continue;
            return true;
        }
        return false;
    }

    public static void printCounters() {
        int n;
        if (!Validate.isRealValidate()) {
            return;
        }
        Vector<String> vector = new Vector<String>(16, 0);
        long l = 0L;
        vector.add("Data Validation counters: ");
        for (n = 0; n < key_reads.length; ++n) {
            if (key_reads[n] + key_writes[n] <= 0L) continue;
            if (n == 0) {
                vector.add(Format.f("Reads of blocks that were never written: %6d ", key_reads[n]));
            } else {
                vector.add(Format.f("Key %3d: ", n) + Format.f("reads: %8d ", key_reads[n]) + Format.f("writes: %8d ", key_writes[n]));
                l += key_reads[n];
            }
            DV_map.key_writes[n] = 0L;
            DV_map.key_reads[n] = 0L;
        }
        for (n = 0; n < vector.size(); ++n) {
            common.ptod(vector.elementAt(n));
        }
        if (Validate.ignoreZeroReads()) {
            return;
        }
        long l2 = 0L;
        for (DV_map dV_map : DV_map.getAllMaps()) {
            l2 += dV_map.blocks_in_error;
        }
        ErrorLog.ptod("Total amount of key blocks read and validated: %,8d; key blocks marked in error: %4d ", l, l2);
        if (l == 0L) {
            if (SlaveWorker.work.work_rd_name.startsWith(SD_entry.SD_FORMAT_NAME)) {
                return;
            }
            if (SlaveWorker.work.format_run) {
                return;
            }
            if (SlaveWorker.work.only_eof_writes) {
                return;
            }
            if (Validate.skipRead()) {
                return;
            }
            vector.removeAllElements();
            vector.add("No read validations done during a Data Validation run.");
            vector.add("This means very likely that your run was not long enough to");
            vector.add("access the same data block twice. ");
            vector.add("There are several solutions to this: ");
            vector.add("- increase elapsed time. ");
            vector.add("- use larger xfersize. ");
            vector.add("- use only a subset of your lun by using the 'sd=...,size=' ");
            vector.add("  parameter or the 'sd=...,range=' parameter.");
            vector.add("Or, you never did any writes so Vdbench does not know what to ");
            vector.add("compare the data with. In that case, change the rdpct= parameter.");
            SlaveJvm.sendMessageToConsole(vector);
            common.failure("No read validations done during a Data Validation run.");
        }
    }

    public static void checkDVStatus() {
        if (ErrorLog.getErrorCount() == 0) {
            return;
        }
        int n = Validate.getMaxErrorWait();
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l < ErrorLog.getLastErrorTod() + (long)(n * 1000)) {
            return;
        }
        common.ptod("*");
        common.ptod("It has been more than " + n + " seconds since the last Data Validation or I/O error.");
        common.ptod("Total Data Validation or I/O error count: " + ErrorLog.getErrorCount());
        common.ptod("*");
        ErrorLog.plog("Total Data Validation or I/O error count: " + ErrorLog.getErrorCount(), new Object[0]);
        ErrorLog.plog("*", new Object[0]);
        common.failure("Vdbench terminating due to Data Validation or I/O errors. See errorlog.html.");
    }

    public synchronized void countBadSectors() {
        ++this.bad_sectors_found;
    }

    public int getBadSectorCount() {
        return this.bad_sectors_found;
    }

    public static boolean anyBadSectorsFound() {
        DV_map[] dV_mapArray = DV_map.getAllMaps();
        for (int i = 0; i < dV_mapArray.length; ++i) {
            if (dV_mapArray[i].bad_sectors_found <= 0) continue;
            return true;
        }
        return false;
    }

    public static void xx_main(String[] stringArray) {
        String string = "/export/dedup/quick_vdbench_test";
        int n = 0x100000;
        int n2 = 40960;
        long l = Native.allocBuffer(n);
        int[] nArray = new int[n / 4];
        for (int i = 30; i < 100; i += 10) {
            long l2;
            new File(string).delete();
            Random random = new Random(0L);
            int n3 = n / 4 * i / 100;
            for (int j = 0; j < n3; ++j) {
                nArray[j] = 0;
            }
            Native.arrayToBuffer(nArray, l);
            long l3 = Native.openfile(string, 0, 1);
            for (int j = 0; j < n2; ++j) {
                long l4 = (long)j * (long)n;
                if (Native.writeFile(l3, l4, n, l) == 0L) continue;
                common.ptod("lba: " + l4);
                common.failure("write error");
            }
            if (common.onSolaris() && (l2 = Native.fsync(l3)) != 0L) {
                common.failure("Native.closeFile(fhandle): fsync failed, rc= " + l2);
            }
            Native.closeFile(l3);
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addText("zfs get compressratio pool-0/local/default/dedup");
            oS_cmd.execute(false);
            String[] stringArray2 = oS_cmd.getStdout();
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].indexOf("compressratio") == -1) continue;
                common.ptod("lines: %3d %8d %s", i, n3 * 4, stringArray2[j]);
            }
        }
    }

    public static void obsolete_fillLFSRSector(int[] nArray, long l, int n, String string) {
        if (nArray.length != 128) {
            common.failure("fillLFSRSector(): Invalid length. " + nArray.length);
        }
        Native.fillLfsrArray(nArray, l, n, string);
        for (int i = 0; i < 8; ++i) {
            nArray[i] = 0;
        }
    }
}

