/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Bin;
import Vdb.Bin_record;
import Vdb.GmtFormat;
import Vdb.common;
import java.util.Date;
import java.util.TimeZone;

class Date_record
extends Bin_record {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    Date start = null;
    Date end = null;
    static long timezone_offset = 0L;
    String timezone = "n/a";
    public static long dflt_timezone_offset = new Date().getTimezoneOffset() * 60 * 1000;
    private static String dflt_timezone = TimeZone.getDefault().getID();
    private static GmtFormat df = new GmtFormat("MMddyyyy-HH:mm:ss.SSS");
    static final byte record_version = 1;

    Date_record() {
        super((byte)1, (byte)1);
    }

    Date_record(Date date, Date date2) {
        super((byte)1, (byte)1);
        this.start = date;
        this.end = date2;
        timezone_offset = date.getTimezoneOffset();
    }

    @Override
    public void export(Bin bin) {
        bin.put_long(this.start.getTime());
        bin.put_long(this.end.getTime());
        bin.put_long(dflt_timezone_offset);
        bin.put_string(dflt_timezone);
        bin.write_record((byte)1, (byte)1);
    }

    @Override
    public void emport(Bin bin) {
        if (bin.record_type != 1) {
            common.failure("Date_record.emport(): Expecting record type 1, but reading " + bin.record_type + ".");
        }
        long l = bin.get_long();
        this.start = new Date(l);
        this.end = new Date(bin.get_long());
        timezone_offset = bin.get_long();
        this.timezone = bin.get_string();
    }

    public String toString() {
        return "d " + df.format(this.start) + " " + df.format(this.end);
    }
}

