/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.CommandOutput;
import Utils.Fget;
import Utils.OS_cmd;
import Vdb.Host;
import Vdb.RD_entry;
import Vdb.SlaveJvm;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

class Debug_cmds
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Vector<String> commands = new Vector(1);
    private String target = "log";
    private boolean master = false;
    private boolean abort = false;
    private HashMap<String, String> hosts = new HashMap(8);
    public static Debug_cmds starting_command = new Debug_cmds();
    public static Debug_cmds ending_command = new Debug_cmds();

    Debug_cmds() {
    }

    public Debug_cmds storeCommands(String[] stringArray) {
        if (this == RD_entry.dflt.start_cmd || this == RD_entry.dflt.end_cmd) {
            this.commands.clear();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("cons") || string.startsWith("sum") || string.startsWith("log")) {
                this.target = string;
                continue;
            }
            if (string.equalsIgnoreCase("master")) {
                this.master = true;
                continue;
            }
            if (string.equalsIgnoreCase("slave")) {
                this.master = false;
                continue;
            }
            if (string.equalsIgnoreCase("abort")) {
                this.abort = true;
                continue;
            }
            if (Host.isHostKnown(string)) {
                this.hosts.put(string, string);
                continue;
            }
            string = common.replace_string(string, "$output", Vdbmain.output_dir);
            this.commands.add(string);
        }
        return this;
    }

    public Object clone() {
        try {
            Debug_cmds debug_cmds = (Debug_cmds)super.clone();
            debug_cmds.commands = (Vector)this.commands.clone();
            return debug_cmds;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public boolean run_command() {
        if (SlaveJvm.isThisSlave() && this.master) {
            return true;
        }
        for (String string : this.commands) {
            String[] stringArray = string.split(" +", 2);
            String string2 = stringArray[0];
            String string3 = stringArray.length > 1 ? stringArray[1] : "";
            String string4 = common.findscript(string2);
            if (!Fget.file_exists(string2) && string4 != null) {
                string2 = string4;
            }
            string = string2 + " " + string3;
            common.ptod("Start/end command: executing '" + string + "'");
            if (SlaveJvm.isThisSlave()) {
                SlaveJvm.sendMessageToConsole("Start/end command: executing '" + string + "'");
            }
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addText(string);
            oS_cmd.setOutputMethod(new CommandOutput(){

                @Override
                public boolean newLine(String string, String string2, boolean bl) {
                    if (string2.equals("stdout")) {
                        if (Debug_cmds.this.target.startsWith("cons")) {
                            if (SlaveJvm.isThisSlave()) {
                                SlaveJvm.sendMessageToConsole("Cmd: %s", string);
                            } else {
                                common.ptod("Cmd: %s", string);
                            }
                        } else if (Debug_cmds.this.target.startsWith("sum")) {
                            common.psum("Cmd: %s ", string);
                        } else if (Debug_cmds.this.target.startsWith("log")) {
                            common.plog("Cmd: %s", string);
                        } else {
                            common.failure("Invalid target: " + Debug_cmds.this.target);
                        }
                    } else if (Debug_cmds.this.target.startsWith("cons")) {
                        if (SlaveJvm.isThisSlave()) {
                            SlaveJvm.sendMessageToConsole("Cmd: stderr %s", string);
                        } else {
                            common.ptod("Cmd: stderr %s", string);
                        }
                    } else if (Debug_cmds.this.target.startsWith("sum")) {
                        common.psum("Cmd: stderr %s", string);
                    } else if (Debug_cmds.this.target.startsWith("log")) {
                        common.plog("Cmd: stderr %s", string);
                    } else {
                        common.failure("Invalid target: " + Debug_cmds.this.target);
                    }
                    return true;
                }
            });
            oS_cmd.execute(true);
            if (!this.abort || oS_cmd.getRC()) continue;
            common.failure("Startcmd= or endcmd= call failed. Abort has been requested.");
        }
        return true;
    }

    public boolean masterOnly() {
        return this.master;
    }
}

