/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.Elapsed;
import Vdb.common;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;

public class DedupBitMap {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private BitSet[] bitsets = null;
    private long bits_needed;
    private long bits_allocated;
    private static final long MAX_BITS = 0x40000000L;
    private static final int BIT_SHIFT = 30;
    private static final long BIT_AND = 0x3FFFFFFFL;
    private static HashMap<String, DedupBitMap> unique_maps = new HashMap(8);
    private static HashMap<String, DedupBitMap> flipflop_maps = new HashMap(8);
    static int[] vd_polynomial_coefficients = new int[]{-1965513496, -1962774824, -1959238911, -1951048149, -1951037743, -1946236863, -1939738656, -1935849387, -1930698531, -1929015533, -1918052755, -1908615175, -1901355171, -1899986043, -1895966800, -1892985496, -1891449126, -1884035486, -1856087537, -1854092087, -1839144954, -1833064727, -1828855146, -1823682332, -1823643051, -1823616411, -1823185234, -1813810721, -1805201192, -1798633804, -1787072019, -1778875737, -1774857138, -1774373362, -1760906253, -1757869504, -1756172062, -1741606399, -1741479383, -1733357239, -1725723542, -1721097026, -1714064181, -1695051486, -1686185928, -1680192493, -1655478209, -1654656263, -1644799432, -1641619550, -1635864725, -1631709684, -1619670413, -1618575034, -1602635156, -1598833304, -1585243075, -1585025061, -1582627083, -1582157544, -1574421466, -1552448746, -1547642661, -1542391747, -1539452840, -1539127348, -1536031371, -1524180285, -1511528261, -1500981168, -1495907867, -1491489714, -1482444303, -1471538399, -1456963124, -1456604857, -1453905412, -1432523081, -1414084412, -1413780089, -1408659929, -1402741390, -1400384731, -1397224780, -1393120117, -1388238201, -1386983192, -1362042159, -1334409177, -1307684928, -1302173895, -1301344060, -1296903117, -1295123197, -1283219410, -1279535789, -1278277602, -1275983775, -1275830956, -1261401250, -1258489868, -1254497135, -1242305876, -1241983241, -1239613809, -1229278973, -1220663843, -1217172134, -1210494974, -1195414724, -1185008686, -1167781412, -1167302335, -1156754901, -1155985476, -1152041912, -1141829836, -1141728668, -1133051253, -1116050116, -1081564991, -1080676560, -1071835061, -1057319001, -1056689434, -1052453530, -1051826408, -1046432668};

    public static void addUniqueBitmap(DedupBitMap dedupBitMap, String string) {
        if (unique_maps.put(string, dedupBitMap) != null) {
            common.failure("Trying to create a second DedupBitMap for %s", string);
        }
    }

    public static DedupBitMap findUniqueBitmap(String string) {
        return unique_maps.get(string);
    }

    public DedupBitMap createMapForUniques(Dedup dedup, long l, String string) {
        this.bits_needed = l / (long)dedup.getDedupUnit();
        this.bits_allocated = this.bits_needed + 1L;
        int n = (int)((this.bits_allocated + 0x40000000L - 1L) / 0x40000000L);
        this.bitsets = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            this.bitsets[i] = new BitSet((int)Math.min(this.bits_allocated - (long)i * 0x40000000L, 0x40000000L));
        }
        double d = dedup.getAdjustedPct();
        long l2 = (long)((double)this.bits_needed * d / 100.0);
        common.ptod("Creating bitmap for unique blocks for %s. %d bitmaps for a total of %,d bits, identifying %,d unique blocks", string, n, this.bits_needed, l2);
        if (l2 > this.bits_needed) {
            common.failure("Oops, asking for %,d unique blocks but have only %,d blocks to choose from", l2, this.bits_needed);
        }
        if (dedup.getDedupRatio() == 1.0) {
            return this;
        }
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        Random random = new Random(string.hashCode());
        Elapsed elapsed = new Elapsed("createMapForUniques", 100000000L);
        long l6 = 0L;
        while (l3 < l2) {
            long l7 = Math.abs(random.nextLong() % this.bits_needed);
            l5 = Math.max(l5, l7);
            if (l7 >= dedup.hot_dedup_blocks) {
                long l8;
                for (int i = 0; i < 32 && l3 < l2 && (l8 = l7 + (long)i) < this.bits_needed; ++i) {
                    if (this.getBit(l8)) {
                        ++l4;
                        continue;
                    }
                    this.setBit(l8, true);
                    ++l3;
                }
            }
            ++l6;
        }
        elapsed.end(5);
        return this;
    }

    public DedupBitMap createMapForFlipFlop(Dedup dedup, long l, String string) {
        this.bits_needed = l;
        this.bits_allocated = this.bits_needed + 1L;
        int n = (int)((this.bits_allocated + 0x40000000L - 1L) / 0x40000000L);
        this.bitsets = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            this.bitsets[i] = new BitSet((int)Math.min(this.bits_allocated - (long)i * 0x40000000L, 0x40000000L));
        }
        common.ptod("Created flipflop bitmap for %s. %d bitmaps for a total of %,d bits.", string, n, this.bits_needed);
        return this;
    }

    public void setBit(long l, boolean bl) {
        int n = (int)(l >> 30);
        int n2 = (int)(l & 0x3FFFFFFFL);
        this.bitsets[n].set(n2, bl);
    }

    public boolean getBit(long l) {
        int n = (int)(l >> 30);
        int n2 = (int)(l & 0x3FFFFFFFL);
        return this.bitsets[n].get(n2);
    }

    public boolean isUnique(long l) {
        if (l >= this.bits_allocated) {
            common.failure("DedupBitMap.isUnique(): requested index too high: %d/%d", this.bits_needed, l);
        }
        return this.getBit(l);
    }

    public boolean isDuplicate(long l) {
        if (l >= this.bits_needed) {
            common.failure("DedupBitMap.isDuplicate(): requested index too high: %d/%d", this.bits_needed, l);
        }
        return !this.getBit(l);
    }

    public static long blockHash(long l) {
        return (int)(l ^ 37L * l >>> 32);
    }

    public static void main(String[] stringArray) {
        long l = 50L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((long)n3 < l) {
            long l2 = n3;
            long l3 = DedupBitMap.blockHash(l2);
            long l4 = l3 & 1L;
            common.ptod("which: %08x %08x %d", l2, l3, l4);
            if (l4 == 1L) {
                ++n;
            } else {
                ++n2;
            }
            ++n3;
        }
        double d = (double)n * 100.0 / (double)l;
        common.ptod("flips: " + n);
        common.ptod("flops: " + n2);
        common.ptod("flip_pct: %.3f", d);
    }
}

