/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;

public class DevicePieces {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    boolean valid = false;
    String dev;
    String controller_name;
    String target_name;
    String disk_name;
    String slice_name;
    int disk;
    int slice = -1;
    String error_txt;

    public DevicePieces(String string) {
        try {
            this.dev = string.toLowerCase();
            if (this.dev.startsWith("/dev/dsk/")) {
                this.dev = this.dev.substring(9);
            } else if (this.dev.startsWith("/dev/rdsk/")) {
                this.dev = this.dev.substring(10);
            }
            this.error_txt = "Not starting with 'c'";
            if (!this.dev.startsWith("c")) {
                return;
            }
            this.error_txt = "t or d missing or in the wrong place";
            if (this.dev.indexOf("t") == -1 && this.dev.indexOf("d") != -1) {
                this.controller_name = this.dev.substring(0, this.dev.indexOf("d"));
            } else {
                if (this.dev.indexOf("t") == -1 || this.dev.indexOf("d") == -1 || this.dev.indexOf("t") > this.dev.lastIndexOf("d")) {
                    return;
                }
                this.controller_name = this.dev.substring(0, this.dev.indexOf("t"));
                this.target_name = this.dev.substring(this.dev.indexOf("t"), this.dev.lastIndexOf("d"));
            }
            int n = this.dev.lastIndexOf("s");
            int n2 = this.dev.lastIndexOf("d");
            int n3 = this.dev.lastIndexOf("p");
            if (n != -1 && n > n2 || n3 != -1 && n3 > n2) {
                if (this.dev.lastIndexOf("s") != -1) {
                    this.disk_name = this.dev.substring(this.dev.lastIndexOf("d"), this.dev.lastIndexOf("s"));
                    this.slice_name = this.dev.substring(this.dev.lastIndexOf("s"));
                } else {
                    this.disk_name = this.dev.substring(this.dev.lastIndexOf("d"), this.dev.lastIndexOf("p"));
                    this.slice_name = this.dev.substring(this.dev.lastIndexOf("p"));
                }
            } else {
                this.disk_name = this.dev.substring(this.dev.lastIndexOf("d"));
                this.slice_name = "s2";
            }
            this.error_txt = "bad controller number";
            if (!DevicePieces.isDec(this.controller_name.substring(1))) {
                return;
            }
            this.error_txt = "bad target number";
            if (this.target_name != null && !DevicePieces.isHex(this.target_name.substring(1))) {
                return;
            }
            this.error_txt = "bad disk number";
            if (!DevicePieces.isDec(this.disk_name.substring(1))) {
                return;
            }
            this.error_txt = "bad slice number";
            this.slice = DevicePieces.translateSliceToNumber(this.slice_name);
            if (this.slice == -1) {
                return;
            }
            this.error_txt = null;
            this.valid = true;
        }
        catch (Exception exception) {
            this.error_txt = "Exception: " + exception.getMessage();
            common.ptod("this: " + this);
            common.ptod(exception);
        }
    }

    private static int translateSliceToNumber(String string) {
        char c;
        char c2 = string.charAt(string.length() - 2);
        if (c2 != 's' && c2 != 'p') {
            return -1;
        }
        if (c2 == 's') {
            if (string.indexOf("s") != string.length() - 2) {
                return -1;
            }
            c = string.charAt(string.length() - 1);
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
        }
        if (c2 == 'p') {
            if (string.indexOf("p") != string.length() - 2) {
                return -1;
            }
            c = string.charAt(string.length() - 1);
            if (c >= 'g' && c <= 'z') {
                return c - 97 + 10;
            }
        }
        return -1;
    }

    public String getNameNoSlice() {
        String string = "/dev/rdsk/" + this.controller_name;
        if (this.target_name != null) {
            string = string + this.target_name;
        }
        string = string + this.disk_name;
        return string;
    }

    public static final boolean isHexStringChar(char c) {
        return Character.isDigit(c) || "0123456789abcdefABCDEF".indexOf(c) >= 0;
    }

    public static final boolean isDecStringChar(char c) {
        return Character.isDigit(c) || "0123456789".indexOf(c) >= 0;
    }

    public static final boolean isHex(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (DevicePieces.isHexStringChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isDec(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (DevicePieces.isDecStringChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "DevicePieces(): " + this.dev + " " + (this.error_txt == null ? "" : "error: " + this.error_txt + "    ") + this.controller_name + " " + this.target_name + " " + this.disk_name + " " + this.slice_name;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        DevicePieces devicePieces = new DevicePieces(string);
        common.ptod("dp: " + devicePieces);
    }
}

