/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.OS_cmd;
import Vdb.DevicePieces;
import Vdb.InstanceXlate;
import Vdb.SlaveJvm;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class Devxlate {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String fullname;
    String instance;
    String special;
    long kstat_pointer;
    DevicePieces dev_pieces = null;
    int seqno;
    boolean kstat_active;
    private static String last_zpool_checked = "never_used_yet";
    private static String[] zfs_stdout = null;
    private static String[] cols = new String[40];
    private static int col = 0;
    private static Vector mnttab = null;
    private static Vector vfstab = null;
    private static Vector mcf = null;
    static Vector instance_list = new Vector(64, 0);
    public static Vector active_list;
    private static Vector search_list;
    private static int sequence_number;
    static boolean debug;

    public Devxlate(String string) {
        this.fullname = string.toLowerCase();
        this.seqno = sequence_number++;
    }

    private static boolean os_command(String string, Vector vector, Vector vector2) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        boolean bl = oS_cmd.execute(false);
        String[] stringArray = oS_cmd.getStdout();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        String[] stringArray2 = oS_cmd.getStderr();
        for (int i = 0; i < stringArray2.length; ++i) {
            vector2.add(stringArray2[i]);
        }
        return bl;
    }

    public static boolean get_vfstab(String string) {
        if (vfstab == null) {
            vfstab = Fget.read_file_to_vector("/etc/vfstab");
        }
        for (int i = 0; i < vfstab.size(); ++i) {
            String string2 = (String)vfstab.elementAt(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() < 4) continue;
            String string3 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (!string4.startsWith("/") || !string.startsWith(string4 + "/") || !string5.equalsIgnoreCase("samfs") && !string5.equalsIgnoreCase("qfs")) continue;
            Devxlate.get_qfs_list(string3);
            return true;
        }
        return false;
    }

    public static void clearMnttab() {
        mnttab = null;
    }

    public static String[] get_mnttab(String string, boolean bl) {
        if (mnttab == null) {
            Devxlate.readAndSortMnttab();
        }
        if (debug) {
            common.ptod("get_mnttab fname: %s use_mount_point: %b", string, bl);
        }
        for (int i = 0; i < mnttab.size(); ++i) {
            String string2 = (String)mnttab.elementAt(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            if (debug) {
                common.ptod("mount_point scan: " + string4 + " fstype: " + string5);
            }
            if (string4.equals("/")) {
                string4 = "";
            }
            if (!bl && string4.length() <= 1) continue;
            boolean bl2 = string.toLowerCase().startsWith(string4.toLowerCase() + "/");
            if (debug) {
                common.ptod("startsWith: " + bl2);
            }
            if (!bl2 || string5.compareTo("nfs") != 0 && string5.compareTo("ufs") != 0 && string5.compareTo("zfs") != 0 && string5.compareTo("qfs") != 0 && string5.compareTo("samfs") != 0) continue;
            if (debug) {
                common.ptod("line: " + string2);
            }
            stringTokenizer = new StringTokenizer(string6, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken();
                if (!string7.startsWith("dev=")) continue;
                int n = (int)Long.parseLong(string7.substring(4), 16);
                String string8 = string5 + (n & 0x3FFFF);
                String[] stringArray = new String[]{string8, string3, string5, string4};
                if (debug) {
                    common.ptod("get_mnttab: fname: " + string + " mountpoint: " + string4 + " instance: " + string8 + " special: " + string3 + " fstype: " + string5);
                }
                return stringArray;
            }
        }
        return null;
    }

    public static void not_used_list_dir(File file, String string) {
        String[] stringArray;
        File file2 = null;
        file2 = new File(file, string);
        if (file != null) {
            common.ptod("xListing directory: " + file.getAbsolutePath() + System.getProperty("file.separator") + string);
        }
        if ((stringArray = file2.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file2, stringArray[i]);
                if (file3.isDirectory()) {
                    Devxlate.not_used_list_dir(file2, stringArray[i]);
                    continue;
                }
                File file4 = new File(file, stringArray[i]);
                common.ptod(file.getAbsolutePath() + System.getProperty("file.separator") + string + System.getProperty("file.separator") + stringArray[i] + " length: " + file4.length());
                try {
                    common.ptod(file.getCanonicalPath() + System.getProperty("file.separator") + string + System.getProperty("file.separator") + stringArray[i] + " length: " + file4.length());
                    continue;
                }
                catch (Exception exception) {
                    common.failure(exception);
                }
            }
        }
    }

    private static void readAndSortMnttab() {
        mnttab = Fget.read_file_to_vector("/etc/mnttab");
        Vector vector = new Vector(mnttab.size());
        while (mnttab.size() > 0) {
            String string = (String)mnttab.firstElement();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 4) {
                common.plog("Short mnttab data1: " + string);
                mnttab.removeElementAt(0);
                continue;
            }
            stringTokenizer.nextToken();
            int n = 0;
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < mnttab.size(); ++i) {
                String string3 = (String)mnttab.elementAt(i);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
                if (stringTokenizer2.countTokens() < 4) {
                    common.plog("Short mnttab data2: " + string3);
                    mnttab.removeElementAt(i);
                    continue;
                }
                stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                if (string4.compareTo(string2) >= 0) continue;
                n = i;
            }
            vector.addElement(mnttab.elementAt(n));
            mnttab.removeElementAt(n);
        }
        mnttab = vector;
        if (debug) {
            for (int i = 0; i < mnttab.size(); ++i) {
                common.ptod("sorted: " + mnttab.elementAt(i));
            }
        }
    }

    public static void split_line(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        char[] cArray = string.toCharArray();
        col = 0;
        if (cArray[0] == ' ') {
            for (n = 0; n < n3 && cArray[n] == ' '; ++n) {
            }
            n2 = n;
        }
        while (n < n3) {
            while (n < n3 && cArray[n] != ' ') {
                ++n;
            }
            Devxlate.cols[Devxlate.col++] = string.substring(n2, n);
            while (n < n3 && cArray[n] == ' ') {
                ++n;
            }
            n2 = n;
        }
    }

    public static void getDeviceLookupData() {
        Vector vector = InstanceXlate.simulateLibdev();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            boolean bl = false;
            boolean bl2 = false;
            if (string3.indexOf(",") != -1) continue;
            Devxlate devxlate = new Devxlate(string2);
            devxlate.instance = string3;
            instance_list.add(devxlate);
            if (!debug) continue;
            common.ptod("getDeviceLookupData added: " + devxlate.fullname);
        }
    }

    public static Vector get_device_info(String string) {
        String[] stringArray;
        String string2;
        int n;
        if (debug) {
            common.ptod("get_device_info: " + string);
        }
        search_list = new Vector(64, 0);
        Devxlate.add_to_search(new File(string).getAbsolutePath());
        Vector<Object> vector = new Vector<Object>(64, 0);
        for (n = 0; n < search_list.size(); ++n) {
            string2 = (String)search_list.elementAt(n);
            if (debug) {
                common.ptod("search: " + string2);
            }
            if (string2.startsWith("/dev/zvol") && (stringArray = new StringTokenizer(string2, "/")).countTokens() == 5) {
                stringArray.nextToken();
                stringArray.nextToken();
                stringArray.nextToken();
                Devxlate.findZfsDevices(stringArray.nextToken());
            }
            if (string2.startsWith("/dev/dsk/") || string2.startsWith("/dev/rdsk/") || string2.startsWith("/dev/rmt/")) continue;
            if (string2.startsWith("/dev/vx/dsk/") || string2.startsWith("/dev/vx/rdsk/")) {
                Devxlate.get_vxvm_list(string2);
                search_list.setElementAt(null, n);
                continue;
            }
            if (string2.startsWith("/dev/md/") || string2.startsWith("/dev/md/")) {
                Devxlate.get_sds_list(string2);
                search_list.setElementAt(null, n);
                continue;
            }
            if (Devxlate.get_vfstab(string2)) continue;
            stringArray = Devxlate.get_mnttab(string2, false);
            if (stringArray == null && (stringArray = Devxlate.get_mnttab(string2, true)) == null) {
                Devxlate.kstat_error(string2);
                vector.add("get_device_info(): could not find: " + string2);
                return vector;
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (debug) {
                common.ptod("gdi: " + string3 + " " + string4 + " " + string5);
            }
            if (string4.startsWith("/dev/md")) {
                Devxlate.add_to_search(string4);
            } else if (string4.startsWith("/dev/vx")) {
                Devxlate.add_to_search(string4);
            } else if (string5.equals("samfs") || string5.equals("qfs")) {
                Devxlate.get_qfs_list(string4);
            } else if (string5.equals("ufs")) {
                vector.add(Devxlate.scan_fullname(string4));
            } else if (string5.equals("zfs")) {
                String string6 = string4.indexOf("/") != -1 ? string4.substring(0, string4.indexOf("/")) : string4;
                Devxlate.findZfsDevices(string6);
            } else {
                if (debug) {
                    System.out.println("adding from mnttab: " + string3 + "  " + string4 + "  " + string5 + "  " + string2);
                }
                vector.add(Devxlate.add_instance_to_list(string3, string2, string4));
            }
            search_list.setElementAt(null, n);
        }
        for (n = 0; n < search_list.size(); ++n) {
            string2 = (String)search_list.elementAt(n);
            if (string2 == null) continue;
            if (debug) {
                common.ptod("search_list name: " + string2);
            }
            if ((stringArray = Devxlate.scan_fullname(string2)) == null) continue;
            vector.add(stringArray);
        }
        if (vector.size() == 0) {
            Devxlate.kstat_error(string);
            vector.add("Unable to find Kstat information for " + string);
            return vector;
        }
        return vector;
    }

    private static void add_to_search(String string) {
        if (debug) {
            common.ptod("add_to_search(): " + string);
        }
        for (int i = 0; i < search_list.size(); ++i) {
            String string2 = (String)search_list.elementAt(i);
            if (string2 == null || string.compareTo(string2) != 0) continue;
            return;
        }
        if (debug) {
            if (search_list.size() == 0) {
                common.plog("Kstat search: starting search for: " + string);
            } else {
                common.plog("Kstat search: adding device: " + string);
            }
        }
        search_list.addElement(string);
    }

    private static void get_vxvm_list(String string) {
        Vector vector = new Vector(64, 0);
        Vector vector2 = new Vector(64, 0);
        Vector vector3 = new Vector(64, 0);
        String string2 = null;
        Vector<String> vector4 = new Vector<String>(64, 0);
        vector4.addElement(string);
        try {
            while (vector4.size() > 0) {
                String string3;
                StringTokenizer stringTokenizer;
                string2 = (String)vector4.firstElement();
                vector4.removeElementAt(0);
                if (debug) {
                    common.ptod("get_vxvm_list() looking for: " + string2);
                }
                if ((stringTokenizer = new StringTokenizer(string2, "/")).countTokens() < 4) {
                    return;
                }
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                } else {
                    string3 = string7;
                    string7 = "rootdg";
                }
                Devxlate.os_command("vxprint -ht -g " + string7 + " " + string3, vector, vector3);
                for (int i = 0; i < vector.size(); ++i) {
                    String string8 = (String)vector.elementAt(i);
                    common.plog("vxprint: " + string8);
                    if (!string8.startsWith("sd") && !string8.startsWith("s2") && !string8.startsWith("sv") || (stringTokenizer = new StringTokenizer(string8)).countTokens() < 4) continue;
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    if (string8.startsWith("sv")) {
                        if (debug) {
                            common.ptod("adding for vxprint: " + string3);
                        }
                        vector4.addElement(string4 + "/" + string5 + "/" + string6 + "/" + string7 + "/" + string3);
                        continue;
                    }
                    if (Devxlate.scan_fullname("/dev/rdsk/" + string3) != null) {
                        Devxlate.add_to_search("/dev/rdsk/" + string3);
                        continue;
                    }
                    Devxlate.os_command("vxdisk -g " + string7 + " list " + string3, vector2, vector3);
                    for (int j = 0; j < vector2.size(); ++j) {
                        string8 = (String)vector2.elementAt(j);
                        common.plog("vxdisk: " + string8);
                        if (!string8.startsWith("numpaths:") || (stringTokenizer = new StringTokenizer(string8)).countTokens() < 2) continue;
                        stringTokenizer.nextToken();
                        int n = Integer.valueOf(stringTokenizer.nextToken());
                        for (int k = 0; k < n; ++k) {
                            string8 = (String)vector2.elementAt(++j);
                            common.plog("numpaths: " + string8);
                            stringTokenizer = new StringTokenizer(string8);
                            String string9 = stringTokenizer.nextToken();
                            string9 = string9.substring(0, string9.lastIndexOf("s")) + "s4";
                            Devxlate.add_to_search("/dev/rdsk/" + string9);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            common.ptod("error while searching for VXVM volume '" + string2 + "'");
            common.ptod("Expecting volume name in the format of '/dev/vx/rdsk/group/volume'");
            Devxlate.kstat_error(string);
        }
    }

    private static void get_qfs_list(String string) {
        if (mcf == null) {
            if (new File("/etc/opt/SUNWsamfs/mcf").exists()) {
                mcf = Fget.read_file_to_vector("/etc/opt/SUNWsamfs/mcf");
            } else if (new File("/etc/opt/LSCsamfs/mcf").exists()) {
                mcf = Fget.read_file_to_vector("/etc/opt/LSCsamfs/mcf");
            }
        }
        for (int i = 0; i < mcf.size(); ++i) {
            StringTokenizer stringTokenizer;
            String string2 = (String)mcf.elementAt(i);
            if (string2.startsWith("#") || (stringTokenizer = new StringTokenizer(string2)).countTokens() < 4) continue;
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            if (string6.compareTo(string) != 0 || string3.compareTo(string) == 0) continue;
            Devxlate.add_to_search(string3);
        }
    }

    private static void get_sds_list(String string) {
        String string2;
        OS_cmd oS_cmd = new OS_cmd();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() < 4) {
            common.failure("get_sds_list() No meta device name in /dev/md/: " + string);
        }
        if (stringTokenizer.countTokens() == 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            oS_cmd.addText("/usr/sbin/metastat");
            oS_cmd.addText(string2);
            oS_cmd.execute();
        } else {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            oS_cmd.addText("/usr/sbin/metastat -s");
            oS_cmd.addText(string3);
            oS_cmd.addText(string2);
            oS_cmd.execute();
        }
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        if (stringArray2.length == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i].trim();
                if (!Devxlate.does_this_contain_ctds(string4)) continue;
                stringTokenizer = new StringTokenizer(string4);
                String string5 = stringTokenizer.nextToken();
                if (string5.startsWith("/dev/rdsk/")) {
                    string5 = string5.substring(10);
                } else if (string5.startsWith("/dev/dsk/")) {
                    string5 = string5.substring(9);
                }
                Devxlate.add_to_search("/dev/rdsk/" + string5);
            }
        }
    }

    private static boolean device_start_block(String string) {
        return string.toLowerCase().indexOf("device") != -1 && string.toLowerCase().indexOf("start") != -1 && string.toLowerCase().indexOf("block") != -1;
    }

    static boolean does_this_contain_ctds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        String string2 = stringTokenizer.nextToken().toLowerCase();
        int n = string2.indexOf(99);
        int n2 = string2.indexOf(116);
        int n3 = string2.lastIndexOf(100);
        int n4 = string2.indexOf(115);
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        return n < n2 && n2 < n3;
    }

    private static Devxlate add_instance_to_list(String string, String string2, String string3) {
        for (int i = 0; i < instance_list.size(); ++i) {
            Devxlate devxlate = (Devxlate)instance_list.elementAt(i);
            if (!devxlate.fullname.equalsIgnoreCase(string2)) continue;
            return devxlate;
        }
        Devxlate devxlate = new Devxlate(string2);
        devxlate.instance = string;
        devxlate.special = string3;
        if (debug) {
            common.ptod("add_instance_to_list: " + devxlate.fullname);
        }
        instance_list.addElement(devxlate);
        return devxlate;
    }

    public static void removeFromInstanceList(String string) {
        for (int i = 0; i < instance_list.size(); ++i) {
            Devxlate devxlate = (Devxlate)instance_list.elementAt(i);
            if (!devxlate.fullname.equalsIgnoreCase(string)) continue;
            instance_list.removeElementAt(i);
            break;
        }
    }

    private static Object scan_fullname(String string) {
        if (debug) {
            common.ptod("scan_fullname(): " + string);
        }
        DevicePieces devicePieces = new DevicePieces(string);
        string = devicePieces.getNameNoSlice();
        for (int i = 0; i < instance_list.size(); ++i) {
            Devxlate devxlate = (Devxlate)instance_list.elementAt(i);
            if (debug) {
                common.ptod("scan_fullname fullname: " + devxlate.fullname);
            }
            if (string.endsWith("/c1t0d0") && common.get_debug(common.FORCE_KSTAT_ERROR)) {
                return "Forcibily returning a Kstat failure for debugging: " + string;
            }
            if (!string.equalsIgnoreCase(devxlate.fullname)) continue;
            if (debug) {
                common.ptod("scan_fullname(): found " + string + " " + devxlate.instance);
            }
            return devxlate;
        }
        return null;
    }

    static void kstat_error(String string) {
        common.ptod("Kstat error: " + string);
        common.ptod("The following stack trace serves only for extra diagnostics for the message that is following:");
        Throwable throwable = new Throwable();
        throwable.printStackTrace(common.stdout);
        throwable.printStackTrace(common.log_html);
        common.ptod("");
        common.ptod("");
        common.ptod("Unable to retrieve native kstat information for " + string + ".");
        if (!debug) {
            common.ptod("This kstat information is needed to collect proper iostat-like data.");
            common.ptod("vdbench will continue without collecting kstat statistics.");
            common.ptod("");
            common.ptod("");
            InstanceXlate.printIostat();
            if (Vdbmain.kstat_console) {
                common.ptod("Using execution parameter '-k' without kstat being active.");
                common.ptod("The result is that no output would be reported on the console!");
                common.ptod("The '-nk' parameter has been reset and execution continues. ");
                Vdbmain.kstat_console = false;
            }
        }
        SlaveJvm.setKstatError();
    }

    private static void findZfsDevices(String string) {
        StringTokenizer stringTokenizer;
        String string2;
        if (!string.equals(last_zpool_checked)) {
            last_zpool_checked = string;
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addText("/usr/sbin/zpool status  " + string);
            oS_cmd.execute();
            if (debug) {
                common.ptod("findZfsDevices: " + string);
            }
            zfs_stdout = oS_cmd.getStdout();
        }
        int n = 0;
        for (n = 0; n < zfs_stdout.length; ++n) {
            string2 = zfs_stdout[n];
            stringTokenizer = new StringTokenizer(string2);
            if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equals(string)) continue;
            ++n;
            break;
        }
        while (n < zfs_stdout.length && !(string2 = zfs_stdout[n]).startsWith("errors")) {
            String string3;
            stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.hasMoreTokens() && !(string3 = stringTokenizer.nextToken()).equalsIgnoreCase("raidz") && !string3.equalsIgnoreCase("mirror")) {
                if (!string3.startsWith("/dev/")) {
                    Devxlate.add_to_search("/dev/rdsk/" + string3);
                    if (debug) {
                        common.ptod("ZFS 2 added to search: " + string3);
                    }
                } else {
                    Devxlate.add_to_search(string3);
                    if (debug) {
                        common.ptod("ZFS 3 added to search: " + string3);
                    }
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
    }

    static {
        sequence_number = 0;
        debug = common.get_debug(common.DEVXLATE);
    }
}

