/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.FileAnchor;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Operations;
import Vdb.Signal;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

class Directory
implements Serializable,
Comparable {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private FileAnchor anchor;
    private Directory parent = null;
    private Directory[] children = null;
    private int width = 0;
    private int depth = 0;
    protected int files_in_dir = 0;
    private boolean dir_busy = false;
    private boolean dir_exists = false;
    private boolean files_checked = false;
    private boolean this_is_anchor = false;
    private static Vector<Directory> temp_dir_list = null;
    private static boolean debug = common.get_debug(common.DIRECTORY_SET_BUSY);
    private static HashMap last_map;
    private static Directory last_checked_dir;
    private static int once;

    public Directory() {
        this.this_is_anchor = true;
    }

    public Directory(Directory directory, int n, int n2, FileAnchor fileAnchor, int n3, int n4) {
        this.anchor = fileAnchor;
        this.parent = directory;
        this.width = n;
        this.depth = n2;
        temp_dir_list.add(this);
        if (this.depth < n4) {
            this.children = new Directory[n3];
            for (int i = 0; i < n3; ++i) {
                this.children[i] = new Directory(this, i, this.depth + 1, fileAnchor, n3, n4);
            }
        } else {
            this.children = null;
            if (temp_dir_list.size() % 1000000 == 0) {
                common.ptod("Initializing directory structure for %s: %,d", fileAnchor.getAnchorName(), temp_dir_list.size());
            }
            for (int i = 99999990; i < temp_dir_list.size(); ++i) {
                Directory directory2 = temp_dir_list.elementAt(i);
                common.ptod("yy: " + directory2.getFullName());
                if (!directory2.getFullName().equals(this.getFullName())) continue;
                common.ptod("no: " + this.getFullName());
            }
        }
    }

    private File getDirPtr() {
        return new File(this.buildFullName());
    }

    public boolean hasFile(String string) {
        if (last_checked_dir != this) {
            if (this.files_checked) {
                common.failure("Recursive call to hasFile(): " + this.getFullName() + " " + string);
            }
            this.files_checked = true;
            last_checked_dir = this;
            String[] stringArray = this.getDirPtr().list();
            last_map = new HashMap(stringArray.length * 2);
            for (int i = 0; i < stringArray.length; ++i) {
                last_map.put(stringArray[i], stringArray[i]);
            }
        }
        if (last_map.size() == 0) {
            return false;
        }
        boolean bl = last_map.get(string) != null;
        return bl;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean exist() {
        return this.dir_exists;
    }

    public void setExists(boolean bl) {
        this.dir_exists = bl;
    }

    public synchronized int countFiles(int n, FileEntry fileEntry) {
        this.files_in_dir += n;
        if (this.files_in_dir < 0) {
            common.failure("negative file count");
        }
        return this.files_in_dir;
    }

    public synchronized boolean setBusy(boolean bl) {
        if (this.this_is_anchor) {
            return true;
        }
        if (debug) {
            common.ptod("Directory.setBusy: " + this.getFullName() + " " + this.dir_busy + " ===> " + bl);
        }
        if (bl && this.dir_busy) {
            return false;
        }
        if (!bl && !this.dir_busy) {
            common.failure("Directory.setBusy(false): entry not busy");
        }
        this.dir_busy = bl;
        if (!bl) {
            this.notifyAll();
        }
        return true;
    }

    public synchronized boolean isBusy() {
        return this.dir_busy;
    }

    public boolean isBusyNoSync() {
        return this.dir_busy;
    }

    public static void clearStaticDirectoryList() {
        temp_dir_list = new Vector(1024, 0);
    }

    public static Vector<Directory> getTempDirectoryList() {
        return temp_dir_list;
    }

    public Directory getParent() {
        return this.parent;
    }

    public String getFullName() {
        return this.buildFullName();
    }

    public String buildFullName() {
        String string = "";
        Directory directory = this;
        while (true) {
            string = directory.getDirName() + File.separator + string;
            if (directory.parent instanceof FileAnchor) {
                FileAnchor fileAnchor = (FileAnchor)directory.parent;
                string = fileAnchor.getAnchorName() + File.separator + string;
                return string;
            }
            directory = directory.parent;
        }
    }

    public Directory[] getChildren() {
        return this.children;
    }

    public boolean anyExistingChildren() {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].exist()) continue;
            return true;
        }
        return false;
    }

    public String getDirName() {
        String string = String.format(this.getAnchor().dir_mask, this.depth, this.width + 1);
        return string;
    }

    public Vector getReverseParentList() {
        Vector<Directory> vector = new Vector<Directory>(16, 0);
        Directory directory = this;
        while (true) {
            vector.insertElementAt(directory, 0);
            if (directory.parent instanceof FileAnchor) break;
            directory = directory.parent;
        }
        return vector;
    }

    public FileAnchor getAnchor() {
        return this.anchor;
    }

    public synchronized boolean createDir() {
        File file = this.getDirPtr();
        FwgThread fwgThread = (FwgThread)Thread.currentThread();
        if (this.dir_exists) {
            common.failure("Creating directory that already exists: " + file.exists() + " " + this.getFullName() + " " + ((FwgThread)Thread.currentThread()).tn.task_number);
        }
        if (fwgThread.fwg.shared && file.exists()) {
            this.setExists(true);
            this.getAnchor().countExistingDirectories(1);
            fwgThread.fwg.blocked.count(Blocked.DIR_CREATE_SHARED);
            return false;
        }
        long l = Native.get_simple_tod();
        if (!file.mkdir()) {
            if (fwgThread.fwg.shared) {
                Signal signal = new Signal(5);
                while (!file.exists()) {
                    common.sleep_some(10L);
                    fwgThread.fwg.blocked.count(Blocked.DIR_WAIT_SHARED);
                    if (!signal.go()) continue;
                }
                if (file.exists()) {
                    this.setExists(true);
                    this.getAnchor().countExistingDirectories(1);
                    fwgThread.fwg.blocked.count(Blocked.DIR_CREATE_SHARED);
                    return false;
                }
            }
            common.ptod("dir_exists:       " + this.dir_exists);
            common.ptod("dir_ptr.exists(): " + file.exists());
            common.ptod("file.exists():    " + new File(this.getFullName()).exists());
            Blocked.printCountersToLog();
            common.failure("Unable to create directory: " + this.getFullName());
        }
        FwdStats.count(Operations.MKDIR, l);
        this.setExists(true);
        this.getAnchor().countExistingDirectories(1);
        return true;
    }

    public synchronized void deleteDir(FwgEntry fwgEntry) {
        if (!this.dir_exists) {
            common.failure("Deleting directory that does not exist");
        }
        if (this.files_in_dir != 0) {
            common.ptod("dir.exists:       " + this.dir_exists);
            common.ptod("dir.full:         " + this.getFullName());
            common.ptod("dir_ptr.exists(): " + this.getDirPtr().exists());
            common.ptod("file.exists():    " + new File(this.getFullName()).exists());
            common.ptod("anyExistingChildren: " + this.anyExistingChildren());
            common.failure("Deleting directory that is not empty");
        }
        long l = Native.get_simple_tod();
        if (!this.getDirPtr().delete()) {
            common.ptod("dir.exists:       " + this.dir_exists);
            common.ptod("dir.full:         " + this.getFullName());
            common.ptod("dir_ptr.exists(): " + this.getDirPtr().exists());
            common.ptod("file.exists():    " + new File(this.getFullName()).exists());
            common.ptod("anyExistingChildren: " + this.anyExistingChildren());
            common.failure("Unable to delete directory: " + this.getFullName());
        }
        FwdStats.count(Operations.RMDIR, l);
        fwgEntry.blocked.count(Blocked.DIRECTORY_DELETES);
        this.setExists(false);
        this.getAnchor().countExistingDirectories(-1);
    }

    public int compareTo(Object object) {
        Directory directory = (Directory)object;
        if (this.depth != directory.depth) {
            return this.depth - directory.depth;
        }
        return this.width - directory.width;
    }

    public static void setDirectoryStatus(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Directory directory = (Directory)vector.elementAt(i);
            if (!directory.getAnchor().format_complete_used && !directory.parent.exist()) continue;
            if (directory.anchor.getControlFile().hasDirStatus()) {
                if (!directory.anchor.getControlFile().getDirStatus(i)) continue;
                directory.setExists(true);
                directory.getAnchor().countExistingDirectories(1);
                continue;
            }
            if (!directory.getAnchor().format_complete_used && !directory.getDirPtr().exists()) continue;
            directory.setExists(true);
            directory.getAnchor().countExistingDirectories(1);
        }
    }

    static {
        once = 0;
    }
}

