/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.DsimHash;
import Vdb.Native;
import Vdb.Request;
import Vdb.common;
import Vdb.dsim;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.Semaphore;

class DsimFile
extends Thread {
    private ArrayList<DsimHash> hash_workers = new ArrayList(5);
    protected Semaphore hash_get_sema = new Semaphore(0);
    protected Semaphore hash_put_sema = new Semaphore(16);
    protected Vector<Request> hash_queue = new Vector(10);
    String fname;
    long true_size;
    long rel_start_lba;
    long hash_elapsed = 0L;
    long hash_counts = 0L;
    long read_resptime = 0L;
    long read_counts = 0L;

    @Override
    public void run() {
        int[] nArray = new int[dsim.xfersize / 4];
        long l = Native.allocBuffer(dsim.xfersize);
        double d = 0.0;
        Thread.currentThread().setPriority(10);
        try {
            long l2;
            for (int i = 0; i < dsim.max_workers; ++i) {
                DsimHash dsimHash = new DsimHash(this);
                this.hash_workers.add(dsimHash);
                dsimHash.start();
            }
            long l3 = this.true_size;
            long l4 = Native.openfile(this.fname, 0, 0);
            dsim.countFiles();
            long l5 = dsim.start_lba;
            while (l5 < l3 && l5 < dsim.end_lba) {
                int n = dsim.xfersize;
                if (l3 - l5 < (long)dsim.xfersize && (n = (int)(l3 - l5)) % dsim.dedupunit != 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = 0;
                    }
                    Native.arrayToBuffer(nArray, l);
                }
                l2 = System.nanoTime();
                Native.readFile(l4, l5, n, l);
                ++this.read_counts;
                this.read_resptime += System.nanoTime() - l2;
                Native.buffer_to_array(nArray, l, n);
                ByteBuffer byteBuffer = ByteBuffer.allocate(dsim.xfersize);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(nArray);
                byte[] byArray = byteBuffer.array();
                int n2 = byArray.length;
                dsim.countReads(n2);
                int n3 = (n + dsim.dedupunit - 1) / dsim.dedupunit;
                for (int i = 0; i < n3; ++i) {
                    int n4 = i * (dsim.dedupunit / 4);
                    int n5 = nArray[n4 + 0];
                    int n6 = nArray[n4 + 1];
                    long l6 = (long)n5 << 32 | (long)n6;
                    long l7 = l5 + (long)(i * dsim.dedupunit);
                    Request request = new Request();
                    request.byte_buffer = byArray;
                    request.int_buffer = nArray;
                    request.offset = i * dsim.dedupunit;
                    request.buf_lba = l5;
                    request.rel_lba = l7;
                    request.unique = l6 == l5 + (long)request.offset;
                    request.word0 = n5;
                    request.word1 = n6;
                    if (!request.unique) {
                        request.setno = n6;
                    }
                    this.hash_put_sema.acquire();
                    this.hash_queue.add(request);
                    this.hash_get_sema.release();
                }
                l5 += (long)n2;
                d += (double)this.hash_queue.size();
            }
            for (DsimHash object : this.hash_workers) {
                this.hash_queue.add(null);
                this.hash_get_sema.release();
            }
            Native.closeFile(l4);
            while (this.hash_queue.size() > 0) {
                common.sleep_some(4L);
            }
            common.sleep_some(5L);
            int n = 0;
            do {
                n = 0;
                for (DsimHash dsimHash : this.hash_workers) {
                    if (!dsimHash.isAlive()) continue;
                    ++n;
                }
            } while (n != 0);
            double d2 = this.read_counts > 0L ? (double)(this.read_resptime / this.read_counts) / 1000000.0 : 0.0;
            l2 = this.hash_counts > 0L ? this.hash_elapsed / this.hash_counts / 1000L : 0L;
        }
        catch (Exception exception) {
            common.ptod("");
            common.failure(exception);
        }
        Native.freeBuffer(dsim.xfersize, l);
        dsim.active_files.remove(Thread.currentThread());
    }
}

