/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ErrnoLinux;
import Vdb.ErrnoSolaris;
import Vdb.Native;
import Vdb.common;

public class Errno {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static final String[] vdbench_table = new String[]{"  796 FORCED_ERROR     796 A debugging caused error                                      ", "  797 BAD_READ_RETURN  Read was successful, but data buffer contents not changed     ", "  798 INCORRECT_SIZE   Vdbench determined that not enough bytes were read or written ", "  799 ERRNO_ZERO       ERRNO contained zero after i/o error       ", "60003 60003            A Data Validation error was discovered     "};

    public static String xlate_errno(long l) {
        for (String string : vdbench_table) {
            String[] stringArray = string.trim().split(" +");
            if ((long)Integer.parseInt(stringArray[0]) != l) continue;
            return String.format("%s: '%s'", stringArray[1], string.substring(string.indexOf(stringArray[1]) + stringArray[1].length()).trim());
        }
        if (common.onWindows()) {
            String string = Native.getWindowsErrorText((int)l);
            if (string != null) {
                return String.format("Windows error %d: '%s'", l, string);
            }
            return "Unknown Windows error code: " + l;
        }
        if (common.onSolaris()) {
            return ErrnoSolaris.xlateErrno(l);
        }
        if (common.onLinux()) {
            return ErrnoLinux.xlateErrno(l);
        }
        if (common.onMac()) {
            return ErrnoLinux.xlateErrno(l);
        }
        common.ptod("Errno translation: No errno translation table available for this OS. Using Linux table");
        return ErrnoLinux.xlateErrno(l);
    }

    public static void main(String[] stringArray) {
        String string = Errno.xlate_errno(Integer.parseInt(stringArray[0]));
        common.ptod("txt: " + string);
    }
}

