/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SocketMessage;
import Vdb.Timeout;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class ErrorLog {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static PrintWriter pw = null;
    private static int errors = 0;
    private static long tod_last_dv_error = 0L;
    private static String NOCONSOLE = "noconsole";
    private static String header1 = "Error log. If there are no error messages beyond this line then there were no Data Validation or I/O errors.";
    private static String header2 = "(Memory map allocation messages for Data Validation and Dedup are just FYI.)";
    private static Vector<String> messages = new Vector(16);
    private static volatile int call_count = 0;
    private static OS_cmd ocmd = new OS_cmd();

    public static void create() {
        pw = Report.createHmtlFile("errorlog.html");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss MMM dd yyyy zzz");
        pw.printf("Vdbench error log, created %s \n", simpleDateFormat.format(new Date()));
        pw.println(header1);
        pw.println();
    }

    public static long getLastErrorTod() {
        return tod_last_dv_error;
    }

    public static void sendMessagesToMaster(Vector vector) {
        SlaveJvm.sendMessageToMaster(SocketMessage.ERROR_MESSAGE, vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ptodSlave(Slave slave, Vector<String> vector) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            for (String string : vector) {
                ErrorLog.ptod(slave.getLabel() + ": " + string, new Object[0]);
            }
        }
    }

    public static void ptod(String string, Object ... objectArray) {
        if (pw == null) {
            String string2 = objectArray.length == 0 ? common.tod() + " " + string : common.tod() + " " + String.format(string, objectArray);
            SlaveJvm.sendMessageToMaster(SocketMessage.ERROR_MESSAGE, string2);
            common.ptod(string2);
        } else {
            String string3 = objectArray.length == 0 ? common.tod() + " " + string : common.tod() + " " + String.format(string, objectArray);
            pw.println(string3);
            common.stdout.println(string3);
            common.plog(string3);
        }
    }

    public static void plog(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        if (pw == null) {
            SlaveJvm.sendMessageToMaster(SocketMessage.ERROR_LOG_MESSAGE, string2);
            common.ptod(string2);
        } else {
            pw.println(common.tod() + " " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String string, Object ... objectArray) {
        Vector<String> vector = messages;
        synchronized (vector) {
            messages.add(common.tod() + " " + String.format(string, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Vector<String> vector = messages;
        synchronized (vector) {
            if (messages.size() > 0) {
                SlaveJvm.sendMessageToMaster(SocketMessage.ERROR_MESSAGE, messages);
                common.ptod(messages);
                messages.clear();
            }
        }
    }

    public static int size() {
        return messages.size();
    }

    public static void countErrorsOnSlave(Integer n) {
        SlaveJvm.sendMessageToMaster(SocketMessage.COUNT_ERRORS, n);
    }

    public static void countErrorsOnMaster(String string, Integer n) {
        if (n > 1) {
            Timeout.callScriptForShutdown();
            Report.flushAllReports();
            common.failure("Shutdown of slave=%s took more than %d seconds. Run aborted.", string, n);
        }
        tod_last_dv_error = System.currentTimeMillis();
        if (++errors >= Validate.getMaxErrorCount()) {
            if (common.get_debug(common.NO_ERROR_ABORT)) {
                common.ptod("'data_error=%d (%d) requested", Validate.getMaxErrorCount(), errors);
                common.ptod("'NO_ERROR_ABORT' debug option requested. Shutting down run.");
                common.ptod("(You may get this message multiple times because of pending errors).");
                Vdbmain.setWorkloadDone(true);
            } else {
                common.failure("'data_errors=%d' requested. Abort rd=%s after last error.", Validate.getMaxErrorCount(), RD_entry.next_rd.rd_name);
            }
        }
    }

    public static void clearCount() {
        errors = 0;
    }

    public static int getErrorCount() {
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void runErrorCommand(String string, long l, long l2, long l3, String string2) {
        OS_cmd oS_cmd = ocmd;
        synchronized (oS_cmd) {
            int n;
            if (call_count++ > 0) {
                return;
            }
            String string3 = Validate.getErrorCommand();
            if (string3.startsWith("stop")) {
                common.failure("'data_error=stop' requested. Abort after first error");
            }
            string3 = common.replace(string3, "$output", Validate.getOutput());
            string3 = common.replace(string3, "$lun", string);
            string3 = common.replace(string3, "$lba", "" + l);
            string3 = common.replace(string3, "$size", "" + l3);
            string3 = common.replace(string3, "$sector", "" + l2);
            string3 = common.replace(string3, "$error", "" + string2);
            ocmd.addText(string3);
            ocmd.execute();
            String[] stringArray = ocmd.getStdout();
            String[] stringArray2 = ocmd.getStderr();
            for (n = 0; n < stringArray.length; ++n) {
                common.ptod("stdout: " + stringArray[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                common.ptod("stderr: " + stringArray2[n]);
            }
            common.sleep_some(1000L);
            common.failure("'data_errors='%s' requested. Abort after first error", string3);
        }
    }
}

