/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Fifo;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.WG_entry;
import Vdb.common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class FifoList {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Fifo[] fifos = null;
    private int fifo_length;
    long sleeps = 0L;
    private static final boolean spin = common.get_debug(common.SPIN);

    public FifoList(String string, int n, int n2) {
        this.fifo_length = n;
        this.fifos = new Fifo[n2];
        for (int i = 0; i < n2; ++i) {
            this.fifos[i] = new Fifo(string + "_prio_" + i, n);
        }
    }

    public static int countPriorities(ArrayList<WG_entry> arrayList) {
        int n;
        int n2;
        boolean bl = false;
        HashMap hashMap = new HashMap(32);
        for (int i = 0; i < arrayList.size(); ++i) {
            WG_entry wG_entry = arrayList.get(i);
            if (wG_entry.hasPriority()) {
                hashMap.put(new Integer(wG_entry.getpriority()), null);
                continue;
            }
            bl = true;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        if (!SlaveJvm.isThisSlave()) {
            n2 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                if ((Integer)objectArray[n] == n2++) continue;
                for (n = 0; n < objectArray.length; ++n) {
                    common.ptod("Priority: " + objectArray[n] + " " + 1);
                }
                common.failure("Workload priorities must be defined in numeric sequence starting at 1");
            }
        } else {
            n2 = 0;
            n = 0;
            while (n < objectArray.length) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    WG_entry wG_entry = arrayList.get(i);
                    if (!wG_entry.hasPriority() || wG_entry.getpriority() != ((Integer)objectArray[n]).intValue()) continue;
                    wG_entry.setPriority(n2);
                }
                ++n;
                ++n2;
            }
        }
        if (bl && SlaveJvm.isThisSlave()) {
            common.failure("FifoList.countPriorities(wg_list): not expecting default");
        }
        if (bl) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                WG_entry wG_entry = arrayList.get(n2);
                if (wG_entry.hasPriority()) continue;
                wG_entry.setPriority(objectArray.length);
                hashMap.put(new Integer(objectArray.length), null);
            }
        }
        return hashMap.size();
    }

    public int getArray(Object[] objectArray) throws InterruptedException {
        while (!SlaveJvm.isWorkloadDone()) {
            for (int i = 0; i < this.fifos.length; ++i) {
                int n = this.fifos[i].getArray(objectArray, false);
                if (n == 0) continue;
                return n;
            }
            if (this.fifos.length == 1) {
                objectArray[0] = this.fifos[0].get();
                return 1;
            }
            if (spin) {
                Thread.currentThread();
                Thread.yield();
                ++this.sleeps;
                continue;
            }
            common.sleep_some(1L);
            ++this.sleeps;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStats(SD_entry sD_entry) {
        Object object = common.ptod_lock;
        synchronized (object) {
            common.ptod("printStats for %s: getArray sleeps: %6d", sD_entry.sd_name, this.sleeps);
        }
    }

    public void put(Object object, int n) throws InterruptedException {
        this.fifos[n].put(object);
    }

    public void putQ(ArrayList arrayList, int n) throws InterruptedException {
        this.fifos[n].putQ(arrayList);
    }

    public void setThreadCount(int n) {
        for (int i = 0; i < this.fifos.length; ++i) {
            this.fifos[i].setThreadCount(n);
        }
    }

    public void waitForRoom(int n) throws InterruptedException {
        this.fifos[n].waitForRoom();
    }

    public void waitAndPut(Object object, int n) throws InterruptedException {
        this.waitForRoom(n);
        this.put(object, n);
    }

    public int getQueueDepth(int n) {
        return this.fifos[n].getQueueDepth();
    }

    public boolean isGettingFull(int n) {
        return this.fifos[n].isGettingFull();
    }
}

