/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Format;
import Utils.Fput;
import Vdb.AnchorReport;
import Vdb.BadDataBlock;
import Vdb.BoxPrint;
import Vdb.ControlFile;
import Vdb.CurlHandling;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.DedupBitMap;
import Vdb.Devxlate;
import Vdb.Directory;
import Vdb.ErrorLog;
import Vdb.FileEntry;
import Vdb.FormatCounter;
import Vdb.FsdEntry;
import Vdb.FwgEntry;
import Vdb.GcTracker;
import Vdb.Jnl_entry;
import Vdb.KeyMap;
import Vdb.OpFormat;
import Vdb.RD_entry;
import Vdb.Signal;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.Work;
import Vdb.common;
import Vdb.ownmath;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;

public class FileAnchor
extends Directory
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private boolean build_structure = true;
    private String anchor_name;
    private String windows_anchor_name;
    public String fsd_name_active;
    public String fsd_name_8bytes;
    public String time_initialized = null;
    private DV_map dv_map = null;
    private DedupBitMap dedup_bitmap;
    public String jnl_dir_name;
    private boolean reported_this_anchor = false;
    private boolean file_sharing = false;
    public int depth = -1;
    public int width = -1;
    public int files = -1;
    public String dist = "bottom";
    public double[] filesizes = null;
    public long total_size = -1L;
    public long working_set;
    public long relative_dedup_offset = 0L;
    private boolean delete_pending = false;
    private boolean once_message_sent = false;
    public boolean format_complete_used = false;
    private long delete_dir_count;
    private long delete_file_count;
    private long delete_start;
    private ControlFile control_file;
    public int total_directories = 0;
    public int maximum_file_count = 0;
    private int existing_dirs = 0;
    private int existing_files = 0;
    private int full_file_count = 0;
    private int round_robin_files = 0;
    private int round_robin_dirs = 0;
    private Vector dir_list = null;
    private Vector<FileEntry> file_list = null;
    private Vector<FileEntry> use_list = null;
    private Vector<FileEntry> wss_list = null;
    public long bytes_in_file_list = 0L;
    private long bytes_in_use_list = 0L;
    private long bytes_in_wss_list = 0L;
    private Random file_select_randomizer = new Random();
    private Random dir_select_randomizer = new Random();
    public Vector devxlate_list = null;
    private Random file_size_randomizer = null;
    private HashMap xfersizes_map = new HashMap(8);
    private HashMap filesizes_used = new HashMap(8);
    private int key_block_size = 0;
    private int dv_max_xfer_size = 0;
    public FormatCounter mkdir_threads_running;
    public FormatCounter create_threads_running;
    public int random_files_touched = 0;
    public int last_format_pct = -1;
    public boolean create_rw_log = false;
    public Fput rw_log = null;
    public String file_mask = null;
    public String dir_mask = null;
    public HashMap<Long, BadDataBlock> bad_data_map = null;
    public Dedup dedup = null;
    public HashMap<FileEntry, HashMap<Long, Long>> pending_file_lba_map = null;
    public ArrayList<FileEntry> pending_files = null;
    public CurlHandling curl = null;
    private static HashMap<String, Fput> open_rwlog_map = new HashMap(8);
    private static int dv_largest_xfer_size = 0;
    private static Vector<FileAnchor> anchor_list = new Vector(8);
    private static double KB = 1024.0;
    private static double MB = 1048576.0;
    private static double GB = 1.073741824E9;
    private static double TB = 1.099511627776E12;
    private static double PB = 1.125899906842624E15;
    Signal signal;
    private int[] select_counters;

    public FileAnchor() {
        if (common.get_debug(common.ANCHOR_FIXED_SEED)) {
            this.file_select_randomizer = new Random(0L);
            this.dir_select_randomizer = new Random(0L);
        }
        this.signal = null;
        this.select_counters = null;
    }

    public static Vector<FileAnchor> getAnchorList() {
        return anchor_list;
    }

    public static FileAnchor newFileAnchor(FsdEntry fsdEntry) {
        common.plog("Creating anchor for " + fsdEntry.dirname + ",fsd=" + fsdEntry.name);
        for (int i = 0; i < anchor_list.size(); ++i) {
            FileAnchor fileAnchor = anchor_list.elementAt(i);
            if (!fileAnchor.anchor_name.equals(fsdEntry.dirname)) continue;
            return fileAnchor;
        }
        FileAnchor fileAnchor = new FileAnchor();
        fileAnchor.anchor_name = fsdEntry.dirname;
        fileAnchor.jnl_dir_name = fsdEntry.jnl_dir_name;
        fileAnchor.dist = fsdEntry.dist;
        fileAnchor.create_rw_log = fsdEntry.create_rw_log;
        fileAnchor.file_mask = fsdEntry.file_mask;
        fileAnchor.dir_mask = fsdEntry.dir_mask;
        anchor_list.addElement(fileAnchor);
        fileAnchor.fsd_name_8bytes = (fsdEntry.name + "        ").substring(0, 8);
        fileAnchor.fsd_name_active = fsdEntry.name;
        fileAnchor.setExists(true);
        fileAnchor.windows_anchor_name = Work.unix2Windows(null, fileAnchor.anchor_name);
        return fileAnchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFileAnchor(FwgEntry fwgEntry) {
        Serializable serializable;
        this.time_initialized = common.tod();
        this.file_size_randomizer = new Random(0L);
        this.file_select_randomizer = new Random();
        this.file_sharing = fwgEntry.file_sharing;
        this.dedup = fwgEntry.dedup;
        this.random_files_touched = 0;
        this.working_set = fwgEntry.working_set;
        if (!Fget.dir_exists(this.anchor_name)) {
            common.failure("Anchor directory name does not exist: " + this.anchor_name);
        }
        if (this.depth != fwgEntry.depth || this.width != fwgEntry.width || this.files != fwgEntry.files || !this.dist.equals(fwgEntry.dist)) {
            common.ptod("Old depth: " + this.depth + " new depth: " + fwgEntry.depth);
            common.ptod("Old width: " + this.width + " new width: " + fwgEntry.width);
            common.ptod("Old files: " + this.files + " new files: " + fwgEntry.files);
            common.ptod("Old dist:  " + this.dist + " new dist:  " + fwgEntry.dist);
            common.ptod("existing_dirs: " + this.existing_dirs);
            common.ptod("existing_files: " + this.existing_files);
            if (this.existing_dirs + this.existing_files != 0) {
                common.ptod("");
                common.ptod("anchor=" + this.anchor_name);
                common.ptod("Changing directory structure while there are still existing directories and/or files");
                common.ptod("Old depth: " + this.depth + " new depth: " + fwgEntry.depth);
                common.ptod("Old width: " + this.width + " new width: " + fwgEntry.width);
                common.ptod("Old files: " + this.files + " new files: " + fwgEntry.files);
                common.ptod("Old dist:  " + this.dist + " new dist:  " + fwgEntry.dist);
                common.ptod("existing_dirs: " + this.existing_dirs);
                common.ptod("existing_files: " + this.existing_files);
                common.ptod("totalsize: " + this.total_size);
                common.ptod("wg.totalsize: " + fwgEntry.total_size);
                common.failure("Invalid parameter setting, or, insert a 'clean' workload");
            }
            this.build_structure = true;
        }
        if (!this.build_structure) {
            common.ptod("Reusing existing FileAnchor structure.");
            return;
        }
        this.calculateStructureSize(fwgEntry, false);
        this.build_structure = false;
        this.control_file = new ControlFile(this);
        if (this.control_file.exists() && !this.isDeletePending() && !fwgEntry.shared) {
            this.control_file.readControlFile(fwgEntry);
        }
        this.dir_list = this.createDirectoryList(this.anchor_name);
        for (int i = 999999990; i < this.dir_list.size(); ++i) {
            serializable = (Directory)this.dir_list.elementAt(i);
            common.ptod("dir_list: " + ((Directory)serializable).getFullName());
        }
        this.createFileList(this, this.dir_list, fwgEntry);
        this.createUsedList(fwgEntry);
        if (this.use_list != null) {
            if (this.use_list.size() == 0) {
                SlaveJvm.sendMessageToConsole("createUsedList could not find any available files using the current file selection options.");
                SlaveJvm.sendMessageToConsole("This Run Definition will be skipped.\n");
                SlaveJvm.setWorkloadDone(true);
                return;
            }
            common.ptod("Generated a use list of %d files", this.use_list.size());
        }
        if (!SlaveWorker.work.format_run) {
            this.createWorkingSetList();
        }
        if (Validate.isValidate()) {
            this.allocateDVMap();
        }
        this.matchFileAndXfersizes();
        if (!fwgEntry.shared) {
            if (!SlaveWorker.work.keep_controlfile) {
                this.control_file.writeControlFile(fwgEntry.shared, true);
            } else {
                common.ptod("No deletes and creates. Control file not cleared.");
            }
        }
        if (this.existing_dirs > 0) {
            common.ptod("During anchor creation for anchor=" + this.getAnchorName() + " there were " + this.existing_dirs + " directories and " + this.existing_files + " files");
        }
        this.control_file.clearStatus();
        if (common.get_debug(common.CREATE_READ_WRITE_LOG)) {
            this.setupReadWriteLog(fwgEntry.fsd_name);
        }
        if (this.curl != null) {
            CurlHandling curlHandling = this.curl;
            synchronized (curlHandling) {
                this.curl.getAuthorization();
                this.curl.listContainer();
            }
        }
        if (!SlaveWorker.work.format_run && !fwgEntry.selseq_start0) {
            Vector<FileEntry> vector = this.wss_list != null ? this.wss_list : (this.use_list != null ? this.use_list : this.file_list);
            serializable = new Random();
            this.round_robin_files = ((Random)serializable).nextInt(vector.size());
        }
    }

    public Vector createDirectoryList(String string) {
        Directory.clearStaticDirectoryList();
        if (SlaveWorker.work.format_flags != null) {
            this.format_complete_used = SlaveWorker.work.format_flags.format_complete;
            if (this.format_complete_used) {
                common.ptod("");
                common.ptod("'format=(no,complete)' has been used. Directory and file status will not be verified.");
                common.ptod("Results unpredictable if the file structure is NOT complete.");
                common.ptod("");
            }
        }
        for (int i = 0; i < this.width; ++i) {
            new Directory(this, i, 1, this, this.width, this.depth);
        }
        common.ptod("Completed the creation of the directory list for %s: %,d directories.", string, Directory.getTempDirectoryList().size());
        Vector<Directory> vector = Directory.getTempDirectoryList();
        Directory.clearStaticDirectoryList();
        long l = System.currentTimeMillis();
        Collections.sort(vector);
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (l2 > 10L) {
            common.ptod("Directory name sort took " + l2 + " seconds.");
        }
        if (!this.isDeletePending()) {
            Directory.setDirectoryStatus(vector);
        }
        return vector;
    }

    public void calculateFsdSize() {
        this.file_size_randomizer = new Random(0L);
        int n = Dedup.getDedupUnit();
        Directory.clearStaticDirectoryList();
        for (int i = 0; i < this.width; ++i) {
            new Directory(this, i, 1, this, this.width, this.depth);
        }
        Vector<Directory> vector = Directory.getTempDirectoryList();
        Directory.clearStaticDirectoryList();
        long l = System.currentTimeMillis();
        Collections.sort(vector);
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        if (l2 > 10L) {
            common.ptod("Directory name sort took " + l2 + " seconds.");
        }
        this.bytes_in_file_list = 0L;
        for (Directory directory : vector) {
            if (this.dist.equals("bottom") && directory.getChildren() != null) continue;
            for (int i = 0; i < this.files; ++i) {
                long l3 = this.getFileSize();
                this.bytes_in_file_list += l3;
            }
        }
        this.file_size_randomizer = new Random(0L);
    }

    private void createFileList(FileAnchor fileAnchor, Vector vector, FwgEntry fwgEntry) {
        Object object;
        Object object2;
        int n;
        this.file_list = null;
        Signal signal = new Signal(2);
        this.file_list = new Vector(this.maximum_file_count);
        int n2 = 0;
        int n3 = 0;
        int n4 = SlaveWorker.work.slave_number;
        int n5 = SlaveWorker.work.slave_count;
        int n6 = Dedup.getDedupUnit();
        boolean bl = Dedup.isDedup();
        this.bytes_in_file_list = 0L;
        for (n = 0; n < vector.size(); ++n) {
            object2 = (Directory)vector.elementAt(n);
            if (this.dist.equals("bottom") && ((Directory)object2).getChildren() != null) continue;
            for (int i = 0; i < this.files; ++i) {
                long l = this.getFileSize();
                if (fwgEntry.shared && n3++ % n5 != n4) continue;
                object = new FileEntry((Directory)object2, l, bl ? this.bytes_in_file_list : this.bytes_in_file_list, this.file_list.size());
                this.file_list.add((FileEntry)object);
                if ((long)(++n2) % 5000000L == 0L) {
                    common.ptod("Generated %,d file names; total anchor size: %s", n2, FileAnchor.whatSize(this.bytes_in_file_list));
                    SlaveJvm.sendMessageToConsole("Continuing the creation of internal file structure for anchor=%s: %,12d files.", this.getAnchorName(), n2);
                }
                this.bytes_in_file_list += l;
            }
        }
        common.ptod("Generated %,d file names; total anchor size: %s (%,d)", n2, FileAnchor.whatSize(this.bytes_in_file_list), this.bytes_in_file_list);
        if (signal.getAge() > 30) {
            SlaveJvm.sendMessageToConsole("Completing the creation of internal file structure for anchor=%s: %,d files.", this.getAnchorName(), n2);
        }
        if (this.file_list.size() == 0) {
            common.failure("No files available for this slave. Did you ask for more slaves than files?");
        }
        if (common.get_debug(common.CREATE_FILE_LIST)) {
            n = 0;
            for (FileEntry fileEntry : this.file_list) {
                n = Math.max(n, fileEntry.getFullName().length());
            }
            object2 = "%-" + fwgEntry.fsd_name.length() + "s %-" + n + "s";
            String string = String.format((String)object2 + " %12s %8s %12s %12s", "FSD", "file name", "size", "size", "loglba_start", "loglba_end+1");
            common.ptod("");
            common.ptod(string);
            for (FileEntry fileEntry : this.file_list) {
                object = String.format((String)object2 + " %12d %8s %12x %12x", fwgEntry.fsd_name, fileEntry.getFullName(), fileEntry.getReqSize(), common.whatSizeX(fileEntry.getReqSize(), 1), fileEntry.getFileStartLba(), fileEntry.getFileStartLba() + fileEntry.getReqSize());
                common.ptod((String)object);
            }
        }
    }

    private void createUsedList(FwgEntry fwgEntry) {
        this.use_list = null;
        Vector<FileEntry> vector = this.file_list;
        long l = this.bytes_in_file_list;
        if (fwgEntry.select_full || fwgEntry.select_empty || fwgEntry.select_nfull) {
            l = 0L;
            vector = new Vector(16384);
            for (FileEntry fileEntry : this.file_list) {
                if (!this.checkFileStatus(fileEntry, fwgEntry)) continue;
                l += fileEntry.getCurrentSize();
                vector.add(fileEntry);
            }
            if (this.total_size == 0L || this.total_size == Long.MAX_VALUE) {
                this.use_list = vector;
                return;
            }
        }
        if (this.total_size == 0L || this.total_size == Long.MAX_VALUE) {
            return;
        }
        if (this.total_size != Long.MAX_VALUE && this.total_size > l) {
            common.failure("A totalsize has been requested that is larger than the currently defined size for this anchor. \n\t\ttotalsize=" + FileAnchor.whatSize(this.total_size) + " anchor size: " + FileAnchor.whatSize(l));
        }
        long l2 = 0L;
        int n = 0;
        this.bytes_in_use_list = 0L;
        this.existing_files = 0;
        this.full_file_count = 0;
        Random random = new Random(0L);
        while (this.bytes_in_use_list < this.total_size) {
            int n2 = (int)(random.nextDouble() * (double)vector.size());
            FileEntry fileEntry = vector.elementAt(n2);
            if (fileEntry == null) {
                common.failure("Unable to create a totalsize= subset for anchor=" + this.getAnchorName());
            }
            if (!fileEntry.setFileBusyExc()) {
                if (l2++ <= 100000L) continue;
                if (this.total_size == Long.MAX_VALUE) break;
                common.failure("Unable to create a totalsize= subset for anchor=" + this.getAnchorName() + "; Too many busy blocks. " + FileAnchor.whatSize(this.bytes_in_use_list) + " " + n);
                continue;
            }
            this.bytes_in_use_list += fileEntry.getReqSize();
            ++n;
            l2 = 0L;
            if (fileEntry.exists()) {
                ++this.existing_files;
            }
            if (!fileEntry.isFull()) continue;
            ++this.full_file_count;
        }
        Vector<FileEntry> vector2 = new Vector<FileEntry>(16384);
        for (int i = 0; i < vector.size(); ++i) {
            FileEntry fileEntry = vector.elementAt(i);
            if (!fileEntry.isBusy()) continue;
            fileEntry.setUnBusy();
            vector2.add(fileEntry);
        }
        SlaveJvm.sendMessageToConsole("Created totalsize= %6s using %,12d of %,12d files for anchor=%s", FileAnchor.whatSize1(this.total_size), vector2.size(), vector.size(), this.getAnchorName());
        if (vector2.size() == 0) {
            common.failure("Subset creation failed. Zero files found.");
        }
        this.use_list = vector2;
    }

    private boolean checkFileStatus(FileEntry fileEntry, FwgEntry fwgEntry) {
        if (fwgEntry.select_empty) {
            boolean bl = !fileEntry.exists() || fileEntry.getCurrentSize() == 0L;
            return bl;
        }
        if (fwgEntry.select_full) {
            boolean bl = fileEntry.isFull();
            return bl;
        }
        if (fwgEntry.select_nfull) {
            boolean bl = !fileEntry.isFull();
            return bl;
        }
        return true;
    }

    private void createWorkingSetList() {
        FileEntry fileEntry;
        int n;
        Object object;
        int n2;
        boolean bl;
        this.wss_list = null;
        if (this.working_set == 0L) {
            return;
        }
        Vector<FileEntry> vector = this.use_list == null ? this.file_list : this.use_list;
        long l = this.use_list == null ? this.bytes_in_file_list : this.bytes_in_use_list;
        boolean bl2 = bl = this.working_set < 0L;
        if (bl) {
            this.working_set *= -1L;
        }
        if (this.working_set == 100L) {
            this.working_set = l;
        }
        if (this.working_set < 100L) {
            this.working_set = l * this.working_set / 100L;
        }
        if (this.working_set > l) {
            common.failure("A working set size has been requested that is larger than \n\t\tthe currently defined total size for this anchor. wss=" + FileAnchor.whatSize(this.working_set) + " totalsize=" + FileAnchor.whatSize(l));
        }
        this.bytes_in_wss_list = 0L;
        long l2 = 0L;
        this.existing_files = 0;
        this.full_file_count = 0;
        Random random = new Random(0L);
        while (this.bytes_in_wss_list < this.working_set) {
            n2 = (int)(random.nextDouble() * (double)vector.size());
            object = vector.elementAt(n2);
            if (object == null) {
                common.failure("Unable to create a working set size (wss) subset.");
            }
            if (!((FileEntry)object).setFileBusyExc()) {
                if (l2++ <= 1000000L) continue;
                common.failure("Unable to create a working set size (wss) subset.");
                continue;
            }
            l2 = 0L;
            this.bytes_in_wss_list += ((FileEntry)object).getReqSize();
            if (((FileEntry)object).exists()) {
                ++this.existing_files;
            }
            if (!((FileEntry)object).isFull()) continue;
            ++this.full_file_count;
        }
        n2 = (int)(this.working_set / l * (long)vector.size());
        object = new Vector(n2);
        for (n = 0; n < vector.size(); ++n) {
            fileEntry = vector.elementAt(n);
            if (fileEntry.isBusy()) {
                fileEntry.setUnBusy();
                if (bl) continue;
                ((Vector)object).add(fileEntry);
                continue;
            }
            if (!bl) continue;
            ((Vector)object).add(fileEntry);
        }
        SlaveJvm.sendMessageToConsole("Created workingset=%6s using %,12d of %,12d files for anchor=%s", FileAnchor.whatSize1(this.working_set), ((Vector)object).size(), vector.size(), this.getAnchorName());
        if (((Vector)object).size() == 0) {
            common.failure("Subset creation failed. Zero files found.");
        }
        this.wss_list = object;
        for (n = Integer.MAX_VALUE; n < this.wss_list.size(); ++n) {
            fileEntry = this.wss_list.elementAt(n);
            common.ptod("fe3: " + fileEntry.getFullName());
        }
    }

    public void startRoundRobin() {
        this.round_robin_dirs = 0;
        this.round_robin_files = 0;
    }

    public String getAnchorName() {
        return this.anchor_name;
    }

    public static FileAnchor findAnchor(String string) {
        FileAnchor fileAnchor;
        int n;
        Vector<FileAnchor> vector = FileAnchor.getAnchorList();
        boolean bl = false;
        for (n = 0; n < vector.size(); ++n) {
            fileAnchor = vector.elementAt(n);
            if (!fileAnchor.getAnchorName().equals(string)) continue;
            return fileAnchor;
        }
        common.ptod("anchors.size(): " + vector.size());
        for (n = 0; n < vector.size(); ++n) {
            fileAnchor = vector.elementAt(n);
            common.ptod("anchor.getAnchorName(): " + fileAnchor.getAnchorName());
        }
        common.failure("Unable to find anchor: " + string + "<<<");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupOldFiles(FwgEntry fwgEntry) {
        Object object;
        this.delete_file_count = 0L;
        this.delete_dir_count = 0L;
        this.delete_start = System.currentTimeMillis();
        this.signal = new Signal(30);
        if (!this.isDeletePending()) {
            return;
        }
        if (Thread.currentThread() instanceof OpFormat) {
            object = (OpFormat)Thread.currentThread();
            ((OpFormat)object).deletePendingLevel1Directories();
            this.waitForCleanups();
        }
        object = this;
        synchronized (object) {
            File file = new File(this.getAnchorName(), ControlFile.CONTROL_FILE);
            if (file.exists() && !file.delete()) {
                common.failure("Unable to delete control file: " + file.getAbsolutePath());
            }
            if (file.exists()) {
                common.failure("Control_file is sticking around????");
            }
        }
        this.existing_dirs = 0;
        if (this.getDVMap() != null) {
            this.getDVMap().eraseMap();
        }
    }

    public synchronized FileEntry getFile(FwgEntry fwgEntry) {
        boolean bl = false;
        if (bl) {
            common.ptod("getFile0 start: ");
        }
        Vector<FileEntry> vector = this.wss_list != null ? this.wss_list : (this.use_list != null ? this.use_list : this.file_list);
        if (Validate.isJournalRecovery() && this.pending_files != null) {
            if (this.pending_files.size() > 0) {
                FileEntry fileEntry = this.pending_files.get(0);
                fileEntry.pending_writes = true;
                this.pending_files.remove(fileEntry);
                if (bl) {
                    common.ptod("getFile1: " + fileEntry);
                }
                common.ptod("this file has pending writes: " + fileEntry);
                return fileEntry;
            }
            if (this.pending_files.size() == 0) {
                ErrorLog.plog("Verifying of pending writes for fsd=%s complete", this.fsd_name_active);
                this.pending_files = null;
            }
        }
        if (fwgEntry.select_random) {
            if (fwgEntry.select_once) {
                int n;
                FileEntry fileEntry;
                do {
                    if (this.random_files_touched < this.getFileCount()) continue;
                    if (!this.once_message_sent) {
                        SlaveJvm.sendMessageToSummary("Reached 'fileselect=once' for anchor %s", this.anchor_name);
                    }
                    this.once_message_sent = true;
                    if (bl) {
                        common.ptod("getFile2: null");
                    }
                    fwgEntry.work_done = true;
                    return null;
                } while ((fileEntry = vector.elementAt(n = this.file_select_randomizer.nextInt(vector.size()))).isSelected());
                fileEntry.setSelected();
                ++this.random_files_touched;
                if (bl) {
                    common.ptod("getFile3: " + fileEntry);
                }
                return fileEntry;
            }
            int n = fwgEntry.poisson_skew == 0.0 ? this.file_select_randomizer.nextInt(vector.size()) : (int)ownmath.distPoisson(vector.size(), fwgEntry.poisson_skew);
            FileEntry fileEntry = vector.get(n);
            if (bl) {
                common.ptod("getFile4: " + fileEntry);
            }
            return fileEntry;
        }
        if (this.round_robin_files >= vector.size()) {
            if (Validate.isJournalRecoveryActive()) {
                if (bl) {
                    common.ptod("getFile5: null");
                }
                return null;
            }
            if (SlaveWorker.work.format_run) {
                if (bl) {
                    common.ptod("getFile6: null");
                }
                return null;
            }
        }
        if (this.round_robin_files >= vector.size()) {
            if (fwgEntry.select_once) {
                if (!this.once_message_sent) {
                    SlaveJvm.sendMessageToSummary("Reached 'fileselect=once' for anchor %s", this.anchor_name);
                }
                this.once_message_sent = true;
                fwgEntry.work_done = true;
                if (bl) {
                    common.ptod("getFile7: null");
                }
                return null;
            }
            this.round_robin_files = 0;
        }
        FileEntry fileEntry = vector.elementAt(this.round_robin_files++);
        if (bl) {
            common.ptod("getFile8: " + fileEntry);
        }
        return fileEntry;
    }

    public synchronized boolean anyFilesToFormat() {
        Vector<FileEntry> vector = this.wss_list != null ? this.wss_list : (this.use_list != null ? this.use_list : this.file_list);
        return this.round_robin_files < vector.size();
    }

    public synchronized Directory getDir(boolean bl, boolean bl2) {
        Directory directory = null;
        if (bl) {
            int n = this.dir_select_randomizer.nextInt(this.dir_list.size());
            directory = (Directory)this.dir_list.elementAt(n);
        } else {
            do {
                if (this.round_robin_dirs >= this.dir_list.size()) {
                    this.round_robin_dirs = 0;
                    if (bl2) {
                        return null;
                    }
                }
                directory = (Directory)this.dir_list.elementAt(this.round_robin_dirs++);
            } while (bl2 && directory.getDepth() != 1);
        }
        return directory;
    }

    public synchronized boolean moreDirsToFormat() {
        return this.round_robin_dirs < this.dir_list.size();
    }

    public void getKstatForAnchor() {
        if (this.devxlate_list == null) {
            this.devxlate_list = Devxlate.get_device_info(this.anchor_name + File.separator + "tmp");
        }
    }

    public synchronized long countExistingFiles(int n, FileEntry fileEntry) {
        this.existing_files += n;
        if (this.existing_files < 0) {
            common.failure("negative file count");
        }
        return this.existing_files;
    }

    public synchronized void countFullFiles(int n, FileEntry fileEntry) {
        this.full_file_count += n;
        if (this.full_file_count < 0) {
            common.failure("negative file count for " + fileEntry.getFullName() + " " + fileEntry.getCurrentSize());
        }
    }

    public synchronized long countExistingDirectories(int n) {
        this.existing_dirs += n;
        return this.existing_dirs;
    }

    public synchronized long anyMoreDirectories() {
        if (this.total_directories - this.existing_dirs < 0) {
            common.ptod("total_directories: " + this.total_directories);
            common.ptod("existing_dirs: " + this.existing_dirs);
            common.failure("reached negative directory count");
        }
        return this.total_directories - this.existing_dirs;
    }

    public synchronized long anyMoreFilesToCreate() {
        long l = this.getFileCount() - this.existing_files;
        if (l < 0L) {
            common.ptod("anyMoreFilesToCreate: " + this.anchor_name + " getFileCount(): " + this.getFileCount() + " maximum_file_count: " + this.maximum_file_count + " existing_files: " + this.existing_files + " ret: " + l);
            common.failure("reached negative file count");
        }
        return l;
    }

    public int getExistingFileCount() {
        return this.existing_files;
    }

    public long getExistingDirCount() {
        return this.existing_dirs;
    }

    public static void printCounters() {
        if (anchor_list.size() > 0) {
            common.plog("Anchor counters:");
            for (int i = 0; i < anchor_list.size(); ++i) {
                FileAnchor fileAnchor = anchor_list.elementAt(i);
                common.plog("anchor=" + fileAnchor.anchor_name);
                common.plog("existing_dirs: " + fileAnchor.existing_dirs + " of " + fileAnchor.total_directories);
                common.plog("existing_files:       " + fileAnchor.existing_files + " of " + fileAnchor.maximum_file_count);
            }
        }
    }

    public long calculateStructureSize(FwgEntry fwgEntry, boolean bl) {
        this.depth = fwgEntry.depth;
        this.width = fwgEntry.width;
        this.files = fwgEntry.files;
        this.dist = fwgEntry.dist;
        this.total_size = fwgEntry.total_size;
        this.working_set = fwgEntry.working_set;
        this.existing_dirs = 0;
        this.existing_files = 0;
        long l = 0L;
        Vector<String> vector = new Vector<String>(8);
        this.total_directories = 0;
        for (int i = 0; i < this.depth; ++i) {
            this.total_directories = (int)((long)this.total_directories + (long)Math.pow(this.width, i + 1));
            if (this.total_directories >= 0) continue;
            this.total_directories = 0;
            for (i = 0; i < this.depth; ++i) {
                this.total_directories = (int)((long)this.total_directories + (long)Math.pow(this.width, i + 1));
                common.ptod("total_directories: %12d 0x%08x", this.total_directories, this.total_directories);
                if (this.total_directories >= 0) continue;
                common.failure("32-bit overflow trying to calculate the amount of directories. \n\tAre you requesting too many directories?");
            }
        }
        this.maximum_file_count = this.dist.equals("bottom") ? (int)Math.pow(this.width, this.depth) * this.files : this.total_directories * this.files;
        long l2 = 0x2000000L;
        long l3 = 0x8000000L;
        long l4 = l2;
        if (common.running64Bit() || Vdbmain.simulate) {
            l4 = l3;
        }
        if (common.get_debug(common.SMALL_FILE_COUNT)) {
            l4 = 100L;
        }
        if ((long)this.maximum_file_count > l4) {
            vector.add("");
            vector.add("New FileAnchor for directory '" + this.anchor_name + "'.");
            vector.add("depth=" + this.depth);
            vector.add("width=" + this.width);
            vector.add("files=" + this.files);
            vector.add("dist=" + this.dist);
            vector.add(String.format("There will be %,12d directories and %,12d files under this anchor.", this.total_directories, this.maximum_file_count));
            vector.add("Vdbench code currently supports only a maximum of " + l4 + " files.");
            vector.add("To work around this you can specify multiple smaller FSDs spread");
            vector.add("out over multiple JVMs.");
            if (!common.running64Bit()) {
                vector.add("Vdbench code for 64bit java supports " + l3 + " files.");
            }
            if (SlaveJvm.isThisSlave()) {
                SlaveJvm.sendMessageToConsole(vector);
            } else {
                common.ptod(vector);
            }
            common.failure("Too many files");
        }
        this.calculateFsdSize();
        vector.add(String.format("Anchor size: anchor=%s: dirs: %,12d; files: %,12d; bytes: %10s (%,d)", this.getAnchorName(), this.total_directories, this.maximum_file_count, common.whatSize(this.bytes_in_file_list), this.bytes_in_file_list));
        String string = "n/a";
        String string2 = "n/a";
        long l5 = this.total_directories + this.maximum_file_count;
        l += l5 * 100L;
        if (bl && !this.reported_this_anchor) {
            common.ptod(vector);
            this.reported_this_anchor = true;
        }
        if (this.total_size != Long.MAX_VALUE && this.total_size > this.bytes_in_file_list) {
            common.ptod("rd=" + RD_entry.next_rd.rd_name);
            common.failure("fwd=" + fwgEntry.getName() + ",fsd=" + fwgEntry.fsd_name + ": The requested totalsize=" + FileAnchor.whatSize(this.total_size) + " is greater than the estimated total anchor size of " + FileAnchor.whatSize(this.bytes_in_file_list));
        }
        if (this.working_set > this.bytes_in_file_list) {
            common.failure("fwd=" + fwgEntry.getName() + ",fsd=" + fwgEntry.fsd_name + ": The requested workingset=" + FileAnchor.whatSize(this.working_set) + " is greater than the estimated total anchor size of " + FileAnchor.whatSize(this.bytes_in_file_list));
        }
        if (fwgEntry.total_size > 0L && fwgEntry.working_set > fwgEntry.total_size) {
            common.ptod("fwg.total_size:  " + FileAnchor.whatSize(fwgEntry.total_size));
            common.ptod("fwg.working_set: " + FileAnchor.whatSize(fwgEntry.working_set));
            common.failure("fwd=" + fwgEntry.getName() + ",fsd=" + fwgEntry.fsd_name + ": The requested workingset=" + FileAnchor.whatSize(fwgEntry.working_set) + " is greater than the estimated totalsize=" + FileAnchor.whatSize(fwgEntry.total_size));
        }
        return l;
    }

    public static void reportCalculatedMemorySizes(Vector vector) {
        long l = 0L;
        HashMap<FileAnchor, FileAnchor> hashMap = new HashMap<FileAnchor, FileAnchor>(32);
        for (int i = 0; i < vector.size(); ++i) {
            RD_entry rD_entry = (RD_entry)vector.elementAt(i);
            for (int j = 0; j < rD_entry.fwgs_for_rd.size(); ++j) {
                FwgEntry fwgEntry = rD_entry.fwgs_for_rd.elementAt(j);
                if (hashMap.put(fwgEntry.anchor, fwgEntry.anchor) != null) continue;
                l += fwgEntry.anchor.calculateStructureSize(fwgEntry, false);
            }
        }
    }

    public Vector<FileEntry> getFileList() {
        return this.file_list;
    }

    public int getFileCount() {
        Vector<FileEntry> vector = this.wss_list != null ? this.wss_list : (this.use_list != null ? this.use_list : this.file_list);
        return vector.size();
    }

    public int getFullFileCount() {
        return this.full_file_count;
    }

    public synchronized boolean allFilesFull() {
        return this.getFullFileCount() == this.getFileCount();
    }

    public FileEntry getRelativeFile(int n) {
        return this.file_list.elementAt(n);
    }

    private long getFileSize() {
        int n;
        if (this.filesizes.length == 1) {
            return (long)this.filesizes[0];
        }
        if (this.filesizes.length == 2 && this.filesizes[1] == 0.0) {
            return this.calculateVarSize();
        }
        int n2 = this.file_size_randomizer.nextInt(100);
        int n3 = 0;
        for (n = 0; n < this.filesizes.length && n2 >= (n3 = (int)((double)n3 + this.filesizes[n + 1])); n += 2) {
        }
        long l = (long)this.filesizes[n];
        return l;
    }

    private long calculateVarSize() {
        int n = 0xA00000;
        int n2 = 0x100000;
        int n3 = 102400;
        int n4 = 10240;
        int n5 = 1024;
        int n6 = (int)this.filesizes[0];
        int n7 = n6 / 2;
        int n8 = this.file_size_randomizer.nextInt(n6);
        float f = n8 + n7;
        n6 = f >= (float)n ? Math.round(f / (float)n2) * n2 : (n6 >= n2 ? Math.round(f / (float)n3) * n3 : (n6 >= n3 ? Math.round(f / (float)n4) * n4 : Math.round(f / (float)n5) * n5));
        return n6;
    }

    public void allocateDVMap() {
        this.dv_map = DV_map.findExistingMap(this.fsd_name_active);
        if (this.dv_map != null && this.dv_map.getKeyBlockSize() != this.key_block_size) {
            common.ptod("");
            common.ptod(this.anchor_name + ": " + Format.f("Key block size from previous run: %7d", this.dv_map.getKeyBlockSize()));
            common.ptod(this.anchor_name + ": " + Format.f("Key block size for this run:      %7d", this.key_block_size));
            common.ptod("Data validation xfersize changed. Data validation map for lun will be cleared");
            if (Validate.isJournaling()) {
                common.failure("Data Validation with journaling requires that data transfer sizes used are identical");
            }
            DV_map.removeMap(this.anchor_name);
            this.dv_map = null;
            GcTracker.gc();
        }
        if (this.dv_map != null) {
            this.dv_map.setDedup(this.dedup);
        } else {
            this.dv_map = DV_map.allocateMap(this.jnl_dir_name, this.fsd_name_active, this.bytes_in_file_list, this.key_block_size);
            this.dv_map.setDedup(this.dedup);
            if (Validate.isJournaling() && this.dv_map.journal == null) {
                this.dv_map.journal = new Jnl_entry(this.fsd_name_active, this.jnl_dir_name, "fsd");
                this.dv_map.journal.storeMap(this.dv_map);
                if (Validate.isJournalRecoveryActive()) {
                    this.dv_map.journal.recovery_anchor = this;
                    this.dv_map = this.dv_map.journal.recoverOneMap(this.jnl_dir_name, this.fsd_name_active, this.bytes_in_file_list, this.getAnchorName());
                    this.key_block_size = this.dv_map.getKeyBlockSize();
                } else {
                    this.dv_map.journal.dumpOneMap(this.dv_map);
                }
            }
        }
        if (Dedup.isDedup()) {
            this.dedup_bitmap = DedupBitMap.findUniqueBitmap("fsd=" + this.fsd_name_active);
            if (this.dedup_bitmap == null) {
                this.dedup_bitmap = new DedupBitMap();
                this.dedup_bitmap.createMapForUniques(this.dedup, this.bytes_in_file_list, "fsd=" + this.fsd_name_active);
                DedupBitMap.addUniqueBitmap(this.dedup_bitmap, "fsd=" + this.fsd_name_active);
            }
        }
    }

    public void trackXfersizes(double[] dArray) {
        for (int i = 0; i < dArray.length; i += 2) {
            int n = (int)dArray[i];
            if (n == -1) continue;
            dv_largest_xfer_size = Math.max(dv_largest_xfer_size, n);
            Object var4_4 = this.xfersizes_map.put(new Integer(n), null);
            if (var4_4 != null) continue;
        }
    }

    public void trackFileSizes(double[] dArray) {
        for (int i = 0; i < dArray.length; i += 2) {
            this.filesizes_used.put(new Long((long)dArray[i]), null);
        }
    }

    public int getMaxXfersize() {
        return this.dv_max_xfer_size;
    }

    public static int getLargestXfersize() {
        return dv_largest_xfer_size;
    }

    public void calculateKeyBlockSize() {
        String string = Validate.isRealValidate() ? "Data validation" : "Dedup";
        Object[] objectArray = this.xfersizes_map.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        if (objectArray.length == 0) {
            common.failure("No 'xfersize=' parameters found for anchor=" + this.anchor_name + ". Are you sure this anchor is used?");
        }
        if (Validate.isValidateForDedup()) {
            this.key_block_size = Dedup.dedup_default.getDedupUnit();
            this.dv_max_xfer_size = (Integer)objectArray[objectArray.length - 1];
            return;
        }
        if (Dedup.isDedup()) {
            FileAnchor fileAnchor = this;
            this.key_block_size = fileAnchor.dedup.getDedupUnit();
        } else {
            this.key_block_size = (Integer)objectArray[0];
        }
        this.dv_max_xfer_size = (Integer)objectArray[objectArray.length - 1];
        for (int i = 0; i < objectArray.length; ++i) {
            int n = (Integer)objectArray[i];
            if (n % this.key_block_size == 0) continue;
            common.ptod("During " + string + " all data transfer sizes used for ");
            common.ptod("an FSD must be a multiple of the lowest xfersize.");
            common.ptod("(A format run may have added a transfer size of 128k).");
            common.ptod("(You may override the format xfersize using 'fwd=format,xfersize=nnn').   ");
            if (Dedup.isDedup()) {
                common.ptod("(Dedup may have added dedupunit=nnn)");
            }
            for (int j = 0; j < objectArray.length; ++j) {
                n = (Integer)objectArray[j];
                common.ptod("Xfersize used in parameter file: " + n);
            }
            common.failure("Xfersize error");
        }
    }

    public void matchFileAndXfersizes() {
        int n;
        if (!Validate.isValidate() && !Validate.isValidateForDedup()) {
            return;
        }
        Object[] objectArray = this.xfersizes_map.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        Long[] longArray = this.filesizes_used.keySet().toArray(new Long[0]);
        if (Validate.isDedup()) {
            FileAnchor fileAnchor = this;
            n = fileAnchor.dedup.getDedupUnit();
        } else {
            n = this.dv_map.getKeyBlockSize();
        }
        int n2 = n;
        for (int i = 0; i < longArray.length; ++i) {
            long l = longArray[i];
            if (l % (long)n2 == 0L) continue;
            BoxPrint boxPrint = new BoxPrint();
            common.ptod("");
            boxPrint.add("During Data validation all file sizes used for ", new Object[0]);
            boxPrint.add("an FSD must be a multiple of the lowest xfersize.", new Object[0]);
            boxPrint.add("(A format run may have added a transfer size of 128k).", new Object[0]);
            boxPrint.add("Data Validation Key block size or dedupunit: " + n2, new Object[0]);
            boxPrint.add("", new Object[0]);
            for (int j = 0; j < longArray.length; ++j) {
                l = longArray[j];
                if (l % (long)n2 == 0L) continue;
                boxPrint.add("Mismatched file size: %,12d", l);
            }
            boxPrint.print();
            common.failure("File size error");
        }
    }

    public KeyMap allocateKeyMap(long l) {
        KeyMap keyMap = new KeyMap(l, this.key_block_size, this.dv_max_xfer_size);
        return keyMap;
    }

    public DV_map getDVMap() {
        return this.dv_map;
    }

    public DedupBitMap getDedupBitMap() {
        return this.dedup_bitmap;
    }

    public DV_map getValidationMap() {
        return this.dv_map;
    }

    public ControlFile getControlFile() {
        return this.control_file;
    }

    public Vector<Directory> getDirList() {
        return this.dir_list;
    }

    public void clearControlFile() {
        this.control_file = null;
    }

    private void checkMemory() {
        int n = 100;
        int n2 = 0x100000;
        int n3 = (this.total_directories + this.maximum_file_count) / n2;
        Object object = new byte[n3][];
        common.ptod("checkMemory()");
        common.memory_usage();
        GcTracker.gc();
        common.memory_usage();
        try {
            for (int i = 0; i < n3; ++i) {
                object[i] = new byte[n2 * n];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            common.memory_usage();
            common.where();
            SlaveJvm.sendMessageToConsole("Pre-allocation check for memory needs for files failed.");
            SlaveJvm.sendMessageToConsole("Each file needs about %d bytes of memory for %,d files. Increase Java heap space.", n, this.maximum_file_count);
            SlaveJvm.sendMessageToConsole("Increase -Xmx value in Vdbench startup script for the Vdbench.SlaveJvm start.");
            object = null;
            common.failure("Not enough memory. See the message above.");
        }
        object = null;
        GcTracker.gc();
    }

    public void setDeletePending(boolean bl) {
        this.delete_pending = bl;
    }

    public boolean isDeletePending() {
        return this.delete_pending;
    }

    public void swapAnchorName() {
        this.anchor_name = this.windows_anchor_name;
    }

    public static String whatSize(double d) {
        if (d < KB) {
            return "" + (int)d;
        }
        String string = d < MB ? Format.f("%.3fk", d / KB) : (d < GB ? Format.f("%.3fm", d / MB) : (d < TB ? Format.f("%.3fg", d / GB) : (d < PB ? Format.f("%.3ft", d / TB) : Format.f("%.3fp", d / PB))));
        String string2 = string.substring(0, string.length() - 5);
        String string3 = string.substring(string.length() - 5);
        if (string3.startsWith(".000")) {
            string = string2 + string3.substring(4);
        }
        return string;
    }

    public static String whatSize1(double d) {
        if (d < 10.0 * KB) {
            return "" + (long)d;
        }
        if (d < MB) {
            return Format.f("%.1fk", d / KB);
        }
        if (d < GB) {
            return Format.f("%.1fm", d / MB);
        }
        if (d < TB) {
            return Format.f("%.1fg", d / GB);
        }
        if (d < PB) {
            return Format.f("%.1ft", d / TB);
        }
        return Format.f("%.1fp", d / PB);
    }

    public void reportSizes(long l, long l2, long l3, long l4, long l5) {
        AnchorReport anchorReport = new AnchorReport(this.getAnchorName(), this.getFileList().size(), this.dir_list.size(), this.bytes_in_file_list, this.use_list != null ? (long)this.use_list.size() : 0L, this.use_list != null ? (long)this.dir_list.size() : 0L, this.use_list != null ? this.bytes_in_use_list : 0L, this.wss_list != null ? (long)this.wss_list.size() : 0L, this.wss_list != null ? (long)this.dir_list.size() : 0L, this.wss_list != null ? this.bytes_in_wss_list : 0L, l, l2, l3, l4, l5);
    }

    public static void main2(String[] stringArray) {
        Random random = new Random(0L);
        double[] dArray = new double[]{1.048576E8, 0.0};
        long l = 0L;
        int n = Integer.parseInt(stringArray[0]);
        int n2 = 0xA00000;
        int n3 = 0x100000;
        int n4 = 102400;
        int n5 = 10240;
        int n6 = 1024;
        for (int i = 0; i < n; ++i) {
            int n7 = (int)dArray[0];
            int n8 = n7 / 2;
            int n9 = random.nextInt(n7);
            float f = n9 + n8;
            n7 = f >= (float)n2 ? Math.round(f / (float)n3) * n3 : (n7 >= n3 ? Math.round(f / (float)n4) * n4 : (n7 >= n4 ? Math.round(f / (float)n5) * n5 : Math.round(f / (float)n6) * n6));
            l += (long)n7;
        }
        common.ptod("Qverage: " + (int)dArray[0] + " " + (int)(l / (long)n));
    }

    public boolean fileSharing() {
        return this.file_sharing;
    }

    public static void printAnchorStatus() {
        Vector<FileAnchor> vector = FileAnchor.getAnchorList();
        boolean bl = false;
        for (FileAnchor fileAnchor : FileAnchor.getAnchorList()) {
            fileAnchor.printFileStatus();
        }
    }

    public void printFileStatus() {
        Vector<String> vector = new Vector<String>(16);
        for (Directory comparable : this.getDirList()) {
            if (!comparable.isBusyNoSync()) continue;
            vector.add(String.format("dir=%s,busy=%b", comparable.getFullName(), comparable.isBusyNoSync()));
        }
        for (FileEntry fileEntry : this.getFileList()) {
            if (!fileEntry.isBusy()) continue;
            vector.add(String.format("file=%s,busy=%b", fileEntry.getFullName(), fileEntry.isBusy()));
        }
        common.ptod(vector);
    }

    public void endOfRun() {
        String string = "****************************************************************************************************";
        if (this.select_counters == null) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < this.select_counters.length; ++i) {
            int n = this.select_counters[i];
            l += (long)n;
            l2 = Math.max(l2, (long)n);
        }
        common.ptod("Random file selection counters for anchor=%s", this.anchor_name);
        common.ptod("Total file selection count: %,d", l);
        double d = 0.0;
        long l3 = 0L;
        for (int i = 0; i < this.select_counters.length && i < 100; ++i) {
            int n = this.select_counters[i];
            double d2 = (double)n * 100.0 / (double)l;
            double d3 = (long)(n * 100) / l2;
            String string2 = string.substring(0, (int)(d3 * (double)string.length() / 100.0));
            String string3 = String.format("[%3d]: %8d %8d %5.2f%%  %6.2f%% %s", i, n, l3 += (long)n, d2, d += d2, string2);
            System.out.println(string3);
        }
        this.select_counters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupReadWriteLog(String string) {
        if (!Validate.isRealValidate()) {
            common.failure("Requesting read/write log while not using Data Validation");
        }
        if (!this.create_rw_log) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyy-HH:mm:ss.SSS zzz");
        String string2 = System.getProperty("java.io.tmpdir");
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            if (SlaveWorker.work.format_run) {
                Fput fput = open_rwlog_map.get(string);
                if (fput != null) {
                    fput.close();
                    open_rwlog_map.remove(string);
                    this.rw_log = null;
                }
                String string3 = new File(string2, string + ".files").getAbsolutePath();
                this.rw_log = new Fput(string3);
                this.rw_log.println("* ");
                this.rw_log.println("* Column description:");
                this.rw_log.println("* ");
                this.rw_log.println("* Column 1: File sequence number, unique per FSD");
                this.rw_log.println("* Column 2: File name");
                this.rw_log.println("* Column 3: Requested file size");
                this.rw_log.println("* Column 4+5: Logical file start lba, decimal and hex");
                this.rw_log.println("* Column 6+7: Logical file end lba, decimal and hex");
                this.rw_log.println("* ");
                this.rw_log.println("* This file is only created during a format.");
                this.rw_log.println("* ");
                this.rw_log.println("* This file was created at " + simpleDateFormat.format(new Date()));
                this.rw_log.println("* ");
                int n = 0;
                for (FileEntry fileEntry : this.file_list) {
                    n = Math.max(n, fileEntry.getFullName().length());
                }
                for (FileEntry fileEntry : this.file_list) {
                    this.rw_log.println("%7d %-" + n + "s %,9d %,12d (%012x) %,12d (%012x)", fileEntry.getFileNoInList(), fileEntry.getFullName(), fileEntry.getReqSize(), fileEntry.getFileStartLba(), fileEntry.getFileStartLba(), fileEntry.getFileStartLba() + fileEntry.getReqSize() - 1L, fileEntry.getFileStartLba() + fileEntry.getReqSize() - 1L);
                }
                this.rw_log.close();
                string3 = new File(string2, string + ".log").getAbsolutePath();
                this.rw_log = new Fput(string3);
                open_rwlog_map.put(string, this.rw_log);
                this.rw_log.println("* ");
                this.rw_log.println("* Column description:");
                this.rw_log.println("* ");
                this.rw_log.println("* Following data is per 'key block size', the smallest xfersize during a test.");
                this.rw_log.println("* ");
                this.rw_log.println("* Column 1: Timestamp: HH:mm:ss.SSS");
                this.rw_log.println("* ");
                this.rw_log.println("* Column 2: Read or write");
                this.rw_log.println("* ");
                this.rw_log.println("* Column 3: Data Validation key just read or written");
                this.rw_log.println("* ");
                this.rw_log.println("* (The following two fields next to each other to accomodate 'grep file# lba')");
                this.rw_log.println("* Column 4: File number, see 'fsdX.files'");
                this.rw_log.println("* Column 5: Logical byte address of 'key block'");
                this.rw_log.println("* ");
                this.rw_log.println("* Column 6: Relative logical byte address of 'key block' within FSD");
                this.rw_log.println("* ");
                this.rw_log.println("* ONLY when the file ends with 'Log properly closed' can we be assured this file is complete");
                this.rw_log.println("* and nothing has been left behind in either java buffers or file system cache.");
                this.rw_log.println("* There may be multiple occurrences of 'Log properly closed'.");
                this.rw_log.println("* The log file is cleared during a format.");
                this.rw_log.println("* ");
                this.rw_log.println("* This file was created at " + simpleDateFormat.format(new Date()));
                this.rw_log.println("* ");
            } else {
                this.rw_log = open_rwlog_map.get(string);
                if (this.rw_log != null) {
                    this.rw_log.println("* This file was continued at " + simpleDateFormat.format(new Date()));
                    return;
                }
                String string4 = new File(string2, string + ".log").getAbsolutePath();
                this.rw_log = new Fput(string4, true);
                open_rwlog_map.put(string, this.rw_log);
                this.rw_log.println("* This file was reopened at " + simpleDateFormat.format(new Date()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllLogs() {
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyy-HH:mm:ss.SSS zzz");
            for (String string : open_rwlog_map.keySet()) {
                Fput fput = open_rwlog_map.get(string);
                fput.println("* Log properly closed at " + simpleDateFormat.format(new Date()));
                fput.close();
            }
            open_rwlog_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAllLogs() {
        HashMap<String, Fput> hashMap = open_rwlog_map;
        synchronized (hashMap) {
            for (Fput fput : open_rwlog_map.values()) {
                fput.flush();
            }
        }
    }

    private void waitForCleanups() {
        block0: while (this.isDeletePending() && !SlaveJvm.isWorkloadDone()) {
            File[] fileArray;
            for (File file : fileArray = new File(this.getAnchorName()).listFiles()) {
                if (!file.getName().startsWith("vdb") || !file.isDirectory()) continue;
                common.sleep_some(100L);
                continue block0;
            }
            this.setDeletePending(false);
            if (this.curl == null) continue;
            this.curl.deleteContainer();
            this.curl.createContainer();
        }
    }

    public synchronized void countFileDeletes() {
        ++this.delete_file_count;
        if (this.delete_file_count > 0L && this.signal.go()) {
            double d = (double)(System.currentTimeMillis() - this.delete_start) / 1000.0;
            double d2 = d == 0.0 ? 0.0 : (double)this.delete_file_count / d;
            SlaveJvm.sendMessageToConsole("anchor=" + this.anchor_name + " deleted " + this.delete_file_count + " files; " + (int)d2 + "/sec");
        }
    }

    public synchronized void countDirDeletes() {
        ++this.delete_dir_count;
        if (this.delete_dir_count > 0L) {
            double d = (double)(System.currentTimeMillis() - this.delete_start) / 1000.0;
            double d2 = d == 0.0 ? 0.0 : (double)this.delete_dir_count / d;
            SlaveJvm.sendMessageToConsole("anchor=" + this.anchor_name + " deleted " + this.delete_dir_count + " directories; " + (int)d2 + "/sec");
        }
    }

    public static void main(String[] stringArray) {
        FileAnchor fileAnchor = new FileAnchor();
        fileAnchor.filesizes = new double[]{1.048576E8, 0.0};
        int n = Integer.parseInt(stringArray[0]);
        fileAnchor.file_size_randomizer = new Random(0L);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += fileAnchor.calculateVarSize();
        }
        common.ptod("Qverage: " + (int)fileAnchor.filesizes[0] + " " + (int)(l / (long)n));
    }
}

