/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Vdb.Blocked;
import Vdb.Directory;
import Vdb.ErrorLog;
import Vdb.FileAnchor;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.Native;
import Vdb.Operations;
import Vdb.Validate;
import Vdb.common;
import java.io.File;

public class FileEntry
implements Comparable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Directory parent = null;
    private long req_file_size = 0L;
    private long cur_file_size = 0L;
    private int file_no_in_list = 0;
    private int use_count = 0;
    private boolean file_opened = false;
    private boolean file_selected = false;
    private boolean file_exists = false;
    private boolean file_busy = false;
    private boolean bad_file = false;
    private boolean format_complete = false;
    private boolean marked_busy = false;
    private boolean parent_busy = false;
    private boolean file_copied = false;
    public boolean pending_writes = false;
    private long file_start_lba = 0L;
    private int bad_bytes = 0;
    private char bad_blocks = '\u0000';
    private long last_lba_used = 0L;
    private static boolean debug = common.get_debug(common.FILEENTRY_SET_BUSY);
    private static long queries = 0L;
    private static long found = 0L;
    private static long count = 0L;

    public FileEntry() {
    }

    public FileEntry(Directory directory, long l, long l2, int n) {
        this.parent = directory;
        this.req_file_size = l;
        this.file_start_lba = l2;
        this.file_no_in_list = n;
        if (this.file_no_in_list >= Integer.MAX_VALUE) {
            common.failure("Maximum file number reached, only 31 bits available.");
        }
        if (this.getAnchor().isDeletePending()) {
            return;
        }
        if (this.parent.exist()) {
            if (this.getAnchor().getControlFile().hasFileStatus()) {
                long l3 = this.getAnchor().getControlFile().getFileSize(this.file_no_in_list, this.req_file_size);
                if (l3 != -1L) {
                    this.file_exists = true;
                    this.parent.countFiles(1, this);
                    this.cur_file_size = l3;
                    if (this.cur_file_size == this.req_file_size) {
                        this.getAnchor().countFullFiles(1, this);
                    }
                }
            } else if (common.get_debug(common.ASSUME_FILE_EXISTS)) {
                this.file_exists = true;
                this.cur_file_size = this.req_file_size;
                this.getAnchor().countFullFiles(1, this);
                this.parent.countFiles(1, this);
            } else if (this.getAnchor().format_complete_used) {
                this.file_exists = true;
                this.cur_file_size = this.req_file_size;
                this.getAnchor().countFullFiles(1, this);
                this.parent.countFiles(1, this);
            } else {
                File file = new File(this.getFullName());
                this.file_exists = this.parent.hasFile(this.getShortName());
                if (++queries % 1000000L == 0L) {
                    common.ptod("FileEntry queries: " + queries + " " + found + " " + found * 100L / queries);
                }
                if (this.file_exists) {
                    this.cur_file_size = file.length();
                    if (this.cur_file_size == this.req_file_size) {
                        this.getAnchor().countFullFiles(1, this);
                    }
                    this.parent.countFiles(1, this);
                    ++found;
                }
            }
        }
        if (this.exists()) {
            this.getAnchor().countExistingFiles(1, this);
        }
    }

    public synchronized boolean setFileBusy() {
        if (debug) {
            common.ptod("setFileBusy: " + this.getFullName() + " " + this.file_busy);
        }
        if (!this.getAnchor().fileSharing()) {
            if (this.file_busy) {
                return false;
            }
            this.file_busy = true;
            return true;
        }
        ++this.use_count;
        this.file_busy = true;
        return true;
    }

    public synchronized boolean setFileBusyExc() {
        if (debug) {
            common.ptod("setFileBusyExc: " + this.getFullName() + " " + this.file_busy);
        }
        if (this.file_busy) {
            return false;
        }
        this.file_busy = true;
        this.use_count = 1;
        return true;
    }

    public synchronized void setUnBusy() {
        if (debug) {
            common.ptod("setUnBusy:   " + this.getFullName() + " " + this.file_busy);
        }
        if (!this.file_busy) {
            common.failure("setUnBusy(false): entry not busy: " + this.getFullName());
        }
        if (!this.getAnchor().fileSharing()) {
            this.file_busy = false;
            if (this.parent_busy) {
                this.parent.setBusy(false);
                this.parent_busy = false;
            }
        } else if (--this.use_count == 0) {
            this.file_busy = false;
            if (this.parent_busy) {
                this.parent.setBusy(false);
                this.parent_busy = false;
            }
        }
    }

    private synchronized boolean obsolete_setBusy(boolean bl) {
        if (debug) {
            common.ptod("FileEntry.setBusy: " + this.getFullName() + " " + this.file_busy + " ===> " + bl);
        }
        if (bl && this.file_busy) {
            return false;
        }
        if (!bl && !this.file_busy) {
            common.failure("FileEntry.setBusy(false): entry not busy: " + this.getFullName());
        }
        this.file_busy = bl;
        this.marked_busy = bl;
        return true;
    }

    public synchronized boolean setParentBusy(boolean bl) {
        boolean bl2 = this.parent.setBusy(bl);
        if (bl2) {
            this.parent_busy = bl;
        }
        return bl2;
    }

    public synchronized void cleanup() {
        this.setUnBusy();
        if (this.parent_busy) {
            this.parent.setBusy(false);
            this.parent_busy = false;
        }
    }

    public boolean isBusy() {
        return this.file_busy;
    }

    public boolean exists() {
        return this.file_exists;
    }

    public void setExists(boolean bl) {
        if (bl && this.file_exists) {
            common.failure("setExists(): file already exists: " + this.getFullName());
        }
        if (!bl && !this.file_exists) {
            common.failure("setExists(): file already does not exist: " + this.getFullName());
        }
        this.file_exists = bl;
    }

    public boolean isFull() {
        boolean bl = this.req_file_size == this.cur_file_size;
        return bl;
    }

    public void setOpened() {
        this.file_opened = true;
    }

    public boolean getOpened() {
        return this.file_opened;
    }

    public void setSelected() {
        this.file_selected = true;
    }

    public boolean isSelected() {
        return this.file_selected;
    }

    public void setCurrentSize(long l) {
        if (l == this.cur_file_size) {
            return;
        }
        if (l == this.req_file_size) {
            this.getAnchor().countFullFiles(1, this);
        } else if (this.cur_file_size == this.req_file_size) {
            this.getAnchor().countFullFiles(-1, this);
        }
        this.cur_file_size = l;
    }

    public long getCurrentSize() {
        return this.cur_file_size;
    }

    public void setBlockBad(int n) {
        this.bad_bytes += n;
        this.bad_blocks = (char)(this.bad_blocks + '\u0001');
        if (this.bad_file) {
            return;
        }
        if ((long)this.bad_bytes > this.getReqSize() / 100L) {
            String string = "setBlockBad(): more than 1%% of the file is marked bad. File no longer will be used: " + this.getFullName();
            ErrorLog.ptod(string, new Object[0]);
            this.setBadFile();
        } else if (this.bad_blocks > 'd') {
            String string = "setBlockBad(): more than 100 bad blocks in the file are marked bad. File no longer will be used: " + this.getFullName();
            ErrorLog.ptod(string, new Object[0]);
            this.setBadFile();
        }
    }

    private void setBadFile() {
        this.bad_file = true;
        ErrorLog.ptod("File marked bad: " + this.getFullName(), new Object[0]);
    }

    public boolean isBadFile() {
        return this.bad_file;
    }

    public long getReqSize() {
        return this.req_file_size;
    }

    public int getFileNoInList() {
        return this.file_no_in_list;
    }

    public void setFormatComplete(boolean bl) {
        this.format_complete = bl;
    }

    public boolean isFormatComplete() {
        return this.format_complete;
    }

    public String getFullName() {
        return this.parent.getFullName() + this.getShortName();
    }

    public String getShortName() {
        String string = String.format(this.getAnchor().file_mask, this.file_no_in_list);
        return string;
    }

    public Directory getParent() {
        return this.parent;
    }

    public String getParentName() {
        return this.parent.getFullName();
    }

    public FileAnchor getAnchor() {
        return this.getParent().getAnchor();
    }

    public long getFileStartLba() {
        return this.file_start_lba;
    }

    public void setLastLba(long l) {
        this.last_lba_used = l;
    }

    public long getLastLba() {
        return this.last_lba_used;
    }

    public boolean hasBeenCopied() {
        return this.file_copied;
    }

    public void setCopied(boolean bl) {
        this.file_copied = bl;
    }

    public void deleteFile(FwgEntry fwgEntry) {
        long l = Native.get_simple_tod();
        File file = new File(this.getFullName());
        if (!file.delete()) {
            common.failure("unable to delete file " + this.getFullName());
        }
        FwdStats.count(Operations.DELETE, l);
        this.parent.countFiles(-1, this);
        this.setExists(false);
        this.setCurrentSize(0L);
        fwgEntry.blocked.count(Blocked.FILE_DELETES);
        this.getAnchor().countExistingFiles(-1, this);
        if (Validate.isValidate()) {
            this.getAnchor().allocateKeyMap(this.file_start_lba).clearMapForFile(this.req_file_size, this.getAnchor().getDVMap());
        }
        if (debug) {
            common.ptod("deleted: " + this.getFullName());
        }
    }

    public int compareTo(Object object) {
        FileEntry fileEntry = (FileEntry)object;
        return this.getFullName().compareTo(fileEntry.getFullName());
    }

    public String toString() {
        return String.format("FileEntry: %s ex: %5b req: %6d cur: %6d", this.getFullName(), this.exists(), this.getReqSize(), this.getCurrentSize());
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]) * 1000;
        for (int i = 0; i < n; ++i) {
            Fput fput = new Fput("w:/temp/file1");
            fput.close();
            new File(fput.getName()).delete();
        }
    }
}

