/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ActiveFile;
import Vdb.SD_entry;
import Vdb.common;
import java.io.File;
import java.util.HashMap;

class File_handles {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String label = null;
    private SD_entry sd = null;
    private static HashMap<Long, Object> handle_map = new HashMap(256);

    File_handles() {
    }

    public static synchronized void addHandle(long l, SD_entry sD_entry) {
        if (handle_map.get(l) != null) {
            common.failure("File_handles.addHandle(): duplicate handle: " + sD_entry.sd_name);
        }
        if (handle_map.put(l, sD_entry) != null) {
            common.failure("Duplicate file handle %d for sd=%s", l, sD_entry.sd_name);
        }
    }

    public static synchronized void addHandle(long l, ActiveFile activeFile) {
        if (handle_map.get(l) != null) {
            common.failure("File_handles.addHandle(): duplicate handle: " + activeFile.getFileEntry().getFullName());
        }
        if (handle_map.put(l, activeFile) != null) {
            common.failure("Duplicate file handle %d for file=%s", l, activeFile.getFileEntry().getFullName());
        }
    }

    public static synchronized void addHandle(long l, String string) {
        if (handle_map.get(l) != null) {
            common.failure("File_handles.addHandle(): duplicate handle: " + string);
        }
        if (handle_map.put(l, string) != null) {
            common.failure("Duplicate file handle %d for label=%s", l, string);
        }
    }

    public static synchronized void remove(long l) {
        if (handle_map.remove(l) == null) {
            common.failure("File_handles.remove(): unknown handle: " + l);
        }
    }

    public static Object findHandle(long l) {
        Object object = handle_map.get(l);
        if (object == null) {
            common.failure("File_handles.findHandle(): unknown handle: " + l);
        }
        return object;
    }

    public static String getFileName(long l) {
        Object object = handle_map.get(l);
        if (object == null) {
            return "File_handles.getFileName(handle=" + l + ")";
        }
        if (object instanceof SD_entry) {
            SD_entry sD_entry = (SD_entry)object;
            return sD_entry.lun;
        }
        if (object instanceof ActiveFile) {
            ActiveFile activeFile = (ActiveFile)object;
            return activeFile.getFileEntry().getFullName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "File_handles.getFileName(" + l + ")";
    }

    public static String getLastName(long l) {
        String string = File_handles.getFileName(l);
        return new File(string).getName();
    }
}

