/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.For_loop;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.SD_entry;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.common;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class Flat {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String label;
    private String strval;
    private double dblval;
    private long longval;
    private int type;
    private String text;
    private static Vector flat_list = new Vector(32, 0);
    private static PrintWriter flatfile_html = null;
    private static boolean first_print = true;

    public static void createFlatFile() {
        flatfile_html = Report.createHmtlFile("flatfile.html");
    }

    private static void blanks(String string) {
        if (string.trim().indexOf(" ") != -1) {
            common.failure("No embedded blanks allowed in flat file labels or data: '" + string + "'");
        }
    }

    private static void add_col(String string, String string2) {
        Flat.blanks(string);
        Flat flat = new Flat();
        flat_list.addElement(flat);
        flat.label = string.trim();
        flat.type = 0;
        flat.text = string2;
    }

    private static Flat find_col(String string, int n) {
        Flat.blanks(string);
        for (int i = 0; i < flat_list.size(); ++i) {
            Flat flat = (Flat)flat_list.elementAt(i);
            if (string.trim().toLowerCase().compareTo(flat.label.toLowerCase()) != 0) continue;
            flat.type = n;
            return flat;
        }
        common.failure("Flatfile column reporting: column '" + string + "' not found");
        return null;
    }

    public static void put_col(String string, long l) {
        Flat.find_col((String)string, (int)1).longval = l;
    }

    public static void put_col(String string, double d) {
        Flat.find_col((String)string, (int)2).dblval = d;
    }

    public static void put_col(String string, String string2) {
        Flat.find_col((String)string, (int)3).strval = string2;
    }

    public static void put_col(String string) {
        Flat.find_col(string, 0);
    }

    private static void print_col_headers() {
        Flat flat;
        int n;
        String string = String.format("%12s %23s ", "tod", "timestamp");
        Flat.println("*");
        Flat.println("* 'flatfile.html' contains Vdbench generated information in a column by column ASCII format. ");
        Flat.println("* The first line in the file contains a one word 'column header name'; the rest of the file ");
        Flat.println("* contains data that belongs to each column. The objective of this file format is to allow ");
        Flat.println("* easy transfer of information to a spreadsheet and therefore the creation of performance ");
        Flat.println("* charts different from the performance charts that can be created by Sun StorageTek Workload ");
        Flat.println("* Analysis Tool (Swat) available for download from Sun.");
        Flat.println("* See also 'Selective flatfile parsing' in the documentation. ");
        Flat.println("*");
        for (n = 0; n < flat_list.size(); ++n) {
            flat = (Flat)flat_list.elementAt(n);
            flatfile_html.println("* " + Format.f("%-16s: ", flat.label) + flat.text);
        }
        flatfile_html.println("* 'n/a'           : Data not available, or conflicting data. eg. multiple different xfersize parameters used.");
        flatfile_html.println("* ");
        for (n = 0; n < flat_list.size(); ++n) {
            flat = (Flat)flat_list.elementAt(n);
            string = string + Format.f("%s ", flat.label);
        }
        flatfile_html.println(string);
    }

    public static void println(String string) {
        if (first_print) {
            first_print = false;
            Flat.print_col_headers();
        }
        flatfile_html.println(string);
    }

    public static void printInterval() {
        Object object;
        String string = "";
        if (first_print) {
            first_print = false;
            Flat.print_col_headers();
        }
        for (int i = 0; i < flat_list.size(); ++i) {
            object = (Flat)flat_list.elementAt(i);
            string = ((Flat)object).type == 1 ? string + Format.f("%d ", ((Flat)object).longval) : (((Flat)object).type == 2 ? string + Flat.removeTrail(((Flat)object).dblval) + " " : (((Flat)object).type == 3 ? string + Format.f("%s ", ((Flat)object).strval) : string + Format.f("%s ", "n/a")));
        }
        Date date = new Date();
        object = new SimpleDateFormat("HH:mm:ss.SSS");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy-HH:mm:ss-zzz ");
        String string2 = String.format("%12s %24s%s", ((DateFormat)object).format(date), simpleDateFormat.format(date), string);
        flatfile_html.println(string2);
    }

    private static String removeTrail(double d) {
        String string = Format.f("%6.4f", d);
        while (string.endsWith("0")) {
            string = string.substring(0, string.length() - 1);
        }
        while (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void define_column_headers() {
        if (Vdbmain.isWdWorkload()) {
            Flat.add_col("Run", "Name of run from RD=");
            Flat.add_col("Interval", "Reporting interval number");
            Flat.add_col("reqrate", "Requested i/o rate");
            Flat.add_col("rate", "Observed i/o rate");
            Flat.add_col("MB/sec", "Megabytes per second (MB=1024*1024)");
            Flat.add_col("bytes/io", "Average data transfersize");
            Flat.add_col("read%", "Observed read percentage");
            Flat.add_col("resp", "Observed response time");
            Flat.add_col("read_resp", "Observed read response time");
            Flat.add_col("write_resp", "Observed write response time");
            Flat.add_col("resp_max", "Observed maximum response time");
            Flat.add_col("read_max", "Observed maximum read response time");
            Flat.add_col("write_max", "Observed maximum write response time");
            Flat.add_col("resp_std", "Standard deviation response time");
            Flat.add_col("read_std", "Standard deviation reads");
            Flat.add_col("write_std", "Standard deviation writes");
            Flat.add_col("xfersize", "data transfer size requested");
            Flat.add_col("threads", "number of threads requested");
            Flat.add_col("rdpct", "read% requested");
            Flat.add_col("rhpct", "readhit% requested");
            Flat.add_col("whpct", "writehit% requested");
            Flat.add_col("seekpct", "seek% requested");
            Flat.add_col("lunsize", "Total amount of Gigabytes of all luns (GB= 1024*1024*1024)");
            Flat.add_col("version", "Vdbench version identifier");
            Flat.add_col("compratio", "Requested compression ratio");
            Flat.add_col("dedupratio", "Requested dedup ratio");
            Flat.add_col("queue_depth", "Vdbench calculated average i/o queue depth");
        } else {
            Flat.add_col("Run", "Name of run from RD=");
            Flat.add_col("Interval", "Reporting interval number");
            Flat.add_col("Xfersize", "data transfer size requested");
            Flat.add_col("Threads", "number of threads requested");
            Flat.add_col("Reqrate", "Requested FWD rate");
            Flat.add_col("Rate", "Requested operations per second");
            Flat.add_col("Rate_std", "Requested operations per second standard deviation");
            Flat.add_col("Rate_max", "Requested operations per second max");
            Flat.add_col("Resp", "Requested response time");
            Flat.add_col("Resp_std", "Requested response time standard deviation");
            Flat.add_col("Resp_max", "Requested response time max");
            Flat.add_col("MB/sec", "Megabytes per second (MB=1024*1024)");
            Flat.add_col("MB_read", "Megabytes read per second");
            Flat.add_col("MB_write", "Megabytes written per second");
            Flat.add_col("Read_rate", "Reads per second");
            Flat.add_col("Read_rate_std", "Reads per second stddev");
            Flat.add_col("Read_rate_max", "Reads per second max");
            Flat.add_col("Read_resp", "Read response time");
            Flat.add_col("Read_resp_std", "Read response time stddev");
            Flat.add_col("Read_resp_max", "Read response time max");
            Flat.add_col("Write_rate", "Writes per second");
            Flat.add_col("Write_rate_std", "Writes per second stddev");
            Flat.add_col("Write_rate_max", "Writes per second max");
            Flat.add_col("Write_resp", "Write response time");
            Flat.add_col("Write_resp_std", "Write response time stddev");
            Flat.add_col("Write_resp_max", "Write response time max");
            Flat.add_col("Mkdir_rate", "Mkdirs per second");
            Flat.add_col("Mkdir_rate_std", "Mkdirs per second stddev");
            Flat.add_col("Mkdir_rate_max", "Mkdirs per second max");
            Flat.add_col("Mkdir_resp", "Mkdir response time");
            Flat.add_col("Mkdir_resp_std", "Mkdir response time stddev");
            Flat.add_col("Mkdir_resp_max", "Mkdir response time max");
            Flat.add_col("Rmdir_rate", "Rmdirs per second");
            Flat.add_col("Rmdir_rate_std", "Rmdirs per second stddev");
            Flat.add_col("Rmdir_rate_max", "Rmdirs per second max");
            Flat.add_col("Rmdir_resp", "Rmdir response time");
            Flat.add_col("Rmdir_resp_std", "Rmdir response time stddev");
            Flat.add_col("Rmdir_resp_max", "Rmdir response time max");
            Flat.add_col("Create_rate", "Creates per second");
            Flat.add_col("Create_rate_std", "Creates per second stddev");
            Flat.add_col("Create_rate_max", "Creates per second max");
            Flat.add_col("Create_resp", "Create response time");
            Flat.add_col("Create_resp_std", "Create response time stddev");
            Flat.add_col("Create_resp_max", "Create response time max");
            Flat.add_col("Open_rate", "Opens per second");
            Flat.add_col("Open_rate_std", "Opens per second stddev");
            Flat.add_col("Open_rate_max", "Opens per second max");
            Flat.add_col("Open_resp", "Open response time");
            Flat.add_col("Open_resp_std", "Open response time stddev");
            Flat.add_col("Open_resp_max", "Open response time max");
            Flat.add_col("Close_rate", "Closes per second");
            Flat.add_col("Close_rate_std", "Closes per second stddev");
            Flat.add_col("Close_rate_max", "Closes per second max");
            Flat.add_col("Close_resp", "Close response time");
            Flat.add_col("Close_resp_std", "Close response time stddev");
            Flat.add_col("Close_resp_max", "Close response time max");
            Flat.add_col("Delete_rate", "Deletes per second");
            Flat.add_col("Delete_rate_std", "Deletes per second stddev");
            Flat.add_col("Delete_rate_max", "Deletes per second max");
            Flat.add_col("Delete_resp", "Delete response time");
            Flat.add_col("Delete_resp_std", "Delete response time stddev");
            Flat.add_col("Delete_resp_max", "Delete response time max");
            Flat.add_col("Getattr_rate", "Getattrs per second");
            Flat.add_col("Getattr_rate_std", "Getattrs per second stddev");
            Flat.add_col("Getattr_rate_max", "Getattrs per second max");
            Flat.add_col("Getattr_resp", "Getattr response time");
            Flat.add_col("Getattr_resp_std", "Getattr response time stddev");
            Flat.add_col("Getattr_resp_max", "Getattr response time max");
            Flat.add_col("Setattr_rate", "Setattrs per second");
            Flat.add_col("Setattr_rate_std", "Setattrs per second stddev");
            Flat.add_col("Setattr_rate_max", "Setattrs per second max");
            Flat.add_col("Setattr_resp", "Setattr response time");
            Flat.add_col("Setattr_resp_std", "Setattr response time stddev");
            Flat.add_col("Setattr_resp_max", "Setattr response time max");
            Flat.add_col("Access_rate", "Accesses per second");
            Flat.add_col("Access_rate_std", "Accesses per second stddev");
            Flat.add_col("Access_rate_max", "Accesses per second max");
            Flat.add_col("Access_resp", "Access response time");
            Flat.add_col("Access_resp_std", "Access response time stddev");
            Flat.add_col("Access_resp_max", "Access response time max");
            Flat.add_col("Compratio", "Requested compression ratio");
            Flat.add_col("Dedupratio", "Requested dedup ratio");
        }
    }

    public static void define_column_headers_kstat() {
        Flat.add_col("ks_rate", "kstat: i/o rate");
        Flat.add_col("ks_resp", "kstat: response time");
        Flat.add_col("ks_wait", "kstat: host wait time");
        Flat.add_col("ks_svct", "kstat: service time");
        Flat.add_col("ks_mb", "kstat: megabytes per second (MB=1024*1024)");
        Flat.add_col("ks_read%", "kstat: read percentage");
        Flat.add_col("ks_busy%", "kstat: busy percentage");
        Flat.add_col("ks_avwait", "kstat: #i/o's waiting in host");
        Flat.add_col("ks_avact", "kstat: #i/o's active");
        Flat.add_col("ks_bytes", "kstat: average transfer size");
    }

    public static void define_column_headers_cpu() {
        Flat.add_col("cpu_used", "kstat: cpu% user+sys");
        Flat.add_col("cpu_user", "kstat: cpu% user");
        Flat.add_col("cpu_kernel", "kstat: cpu% sys ");
        Flat.add_col("cpu_wait", "kstat: cpu% wait");
        Flat.add_col("cpu_idle", "kstat: cpu% idle");
    }

    public static void reportWgParameters(RD_entry rD_entry) {
        ArrayList<WG_entry> arrayList = rD_entry.getAllWorkloads();
        WG_entry wG_entry = arrayList.get(0);
        int n = wG_entry.getXfersizes().length > 0 ? (int)wG_entry.getXfersizes()[0] : 0;
        double d = wG_entry.rhpct;
        double d2 = wG_entry.whpct;
        double d3 = wG_entry.readpct;
        double d4 = wG_entry.seekpct;
        for (int i = 1; i < arrayList.size(); ++i) {
            wG_entry = arrayList.get(i);
            if (wG_entry.getXfersizes().length > 0 && (double)n != wG_entry.getXfersizes()[0]) {
                n = -1;
            }
            if (d != wG_entry.rhpct) {
                d = -1.0;
            }
            if (d2 != wG_entry.whpct) {
                d2 = -1.0;
            }
            if (d3 != wG_entry.readpct) {
                d3 = -1.0;
            }
            if (d4 == wG_entry.seekpct) continue;
            d4 = -1.0;
        }
        Flat.put_col("xfersize");
        Flat.put_col("rhpct");
        Flat.put_col("whpct");
        Flat.put_col("rdpct");
        Flat.put_col("threads");
        Flat.put_col("seekpct");
        if (n != -1) {
            Flat.put_col("xfersize", n);
        }
        if (d != -1.0) {
            Flat.put_col("rhpct", d);
        }
        if (d2 != -1.0) {
            Flat.put_col("whpct", d2);
        }
        if (d3 != -1.0) {
            Flat.put_col("rdpct", d3);
        }
        if (d4 != -1.0) {
            Flat.put_col("seekpct", d4);
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.elementAt(i);
            if (!sD_entry.isActive()) continue;
            if (l == 0L) {
                l = sD_entry.threads;
            }
            if (l != (long)sD_entry.threads) {
                l = -1L;
            }
            l2 += sD_entry.end_lba;
        }
        if (rD_entry.current_override.getThreads() != For_loop.NOVALUE) {
            Flat.put_col("threads", rD_entry.current_override.getThreads());
        } else {
            Flat.put_col("threads", l);
        }
        Flat.put_col("lunsize", (double)l2 / (double)Report.GB);
    }

    public static void reportFwgParameters(RD_entry rD_entry) {
        Flat.put_col("xfersize");
        Flat.put_col("threads");
        if (rD_entry.current_override.getThreads() != For_loop.NOVALUE) {
            Flat.put_col("Threads", rD_entry.current_override.getThreads());
        }
        if (rD_entry.current_override.getXfersize() != For_loop.NOVALUE) {
            Flat.put_col("Xfersize", rD_entry.current_override.getXfersize());
        }
    }
}

