/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Operations;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.Serializable;

public class FormatFlags
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public boolean format_requested = false;
    public boolean format_restart = false;
    public boolean format_clean = false;
    public boolean format_only_requested = false;
    public boolean format_dirs_requested = false;
    public boolean format_once_requested = false;
    public boolean format_limited = false;
    public boolean format_complete = false;
    public boolean one_format_done = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public void parseParameters(String[] stringArray) {
        int n;
        if (common.get_debug(common.RESTART_FILLING)) {
            this.format_restart = true;
        }
        for (String string : stringArray) {
            if (!"complete".equals(string)) continue;
            this.format_complete = true;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!"no".startsWith(stringArray[n])) continue;
            this.format_requested = false;
            if (Vdbmain.force_format_no) {
                this.format_requested = false;
            }
            if (Vdbmain.force_format_yes) {
                this.format_requested = true;
            }
            if (Vdbmain.force_format_only) {
                this.format_requested = true;
                this.format_only_requested = true;
            }
            if (this.format_requested && this.format_complete) {
                common.failure("'format=yes' and 'format=complete' are mutually exclusive.");
            }
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if ("directories".startsWith(stringArray[n])) {
                this.format_requested = true;
                this.format_dirs_requested = true;
                continue;
            }
            if ("restart".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_restart = true;
                continue;
            }
            if ("only".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_only_requested = true;
                continue;
            }
            if ("once".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_once_requested = true;
                continue;
            }
            if ("clean".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_clean = true;
                this.format_only_requested = true;
                continue;
            }
            if ("limited".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_limited = true;
                continue;
            }
            if ("complete".equals(stringArray[n])) {
                this.format_requested = true;
                this.format_complete = true;
                continue;
            }
            if ("yes".startsWith(stringArray[n])) {
                this.format_requested = true;
                continue;
            }
            common.failure("Invalid contents of 'format=' parameter: " + stringArray[n]);
        }
        if (Vdbmain.force_format_no) {
            this.format_requested = false;
        }
        if (Vdbmain.force_format_yes) {
            this.format_requested = true;
        }
        if (Vdbmain.force_format_only) {
            this.format_requested = true;
            this.format_only_requested = true;
        }
        if (this.format_requested && this.format_complete) {
            common.failure("'format=yes' and 'format=complete' are mutually exclusive.");
        }
        if (this.format_limited && !this.format_only_requested) {
            common.failure("The use of 'format=limited' requires the use of 'format=(only,limited)'");
        }
        if (this.format_requested && Validate.isJournalRecovery()) {
            common.failure("'format=yes' and Journal recovery are mutually exclusive");
        }
        if (this.format_requested) {
            Operations.getOperationIdentifier("rmdir");
            Operations.getOperationIdentifier("mkdir");
            Operations.getOperationIdentifier("delete");
            Operations.getOperationIdentifier("create");
            Operations.getOperationIdentifier("write");
        }
    }

    public String toString() {
        String string = "\n";
        string = string + "format_requested:      " + this.format_requested + "\n";
        string = string + "format_restart:        " + this.format_restart + "\n";
        string = string + "format_only_requested: " + this.format_only_requested + "\n";
        string = string + "format_dirs_requested: " + this.format_dirs_requested + "\n";
        string = string + "format_clean:          " + this.format_clean + "\n";
        string = string + "format_once_requested: " + this.format_once_requested + "\n";
        return string;
    }
}

