/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.OS_cmd;
import Vdb.AuxReport;
import Vdb.common;

public class FreeMem
extends AuxReport {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String[] parms = null;
    private boolean disabled = false;
    private OS_cmd ocmd = null;
    private static double free_bytes = -1.0;

    @Override
    public void parseParameters(String[] stringArray) {
        this.parms = stringArray;
    }

    @Override
    public void storeRunInfo(int n, int n2, int n3) {
        common.where();
    }

    @Override
    public String[] getSummaryHeaders() {
        String[] stringArray = new String[]{String.format("%8s ", "MemFree"), String.format("%8s ", "gb")};
        return stringArray;
    }

    @Override
    public String getSummaryData() {
        if (this.disabled) {
            return "disabled";
        }
        if (free_bytes >= 0.0) {
            String string = String.format("%8.3f ", free_bytes / 1.073741824E9);
            return string;
        }
        return String.format("%8s", "n/a");
    }

    @Override
    public String[] getReportHeader() {
        common.where();
        return null;
    }

    @Override
    public String getReportData() {
        common.where();
        return null;
    }

    @Override
    public void runStart() {
        common.where();
    }

    @Override
    public void collectIntervalData() {
        if (this.disabled) {
            return;
        }
        try {
            String[] stringArray;
            if (common.onLinux()) {
                for (String string : stringArray = Fget.readFileToArray("/proc/meminfo")) {
                    if (!string.startsWith("MemFree")) continue;
                    String[] stringArray2 = string.split(" +");
                    free_bytes = Double.parseDouble(stringArray2[1]) * 1024.0;
                    return;
                }
            }
            if (common.onSolaris()) {
                if (this.ocmd != null) {
                    common.ptod("FreeMem auxiliarly reporting is running behind. Request ignored.");
                    return;
                }
                this.ocmd = new OS_cmd();
                this.ocmd.addText("kstat -m unix -n system_pages -s freemem -p");
                this.ocmd.execute(false);
                if (!this.ocmd.getRC()) {
                    return;
                }
                stringArray = this.ocmd.getStdout();
                this.ocmd = null;
                for (String string : stringArray) {
                    if (!string.startsWith("unix:0:system_pages:freemem")) continue;
                    string = string.replace("\t", " ");
                    String[] stringArray3 = string.split(" +");
                    double d = Double.parseDouble(stringArray3[1]);
                    String string2 = System.getProperty("os.arch");
                    free_bytes = string2.equals("amd64") || string2.equals("x86") ? d * 4096.0 : d * 8192.0;
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            common.ptod("FreeMem auxiliarly reporting is being disabled.");
            common.ptod(exception);
            this.disabled = true;
            return;
        }
    }
}

