/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.FileAnchor;
import Vdb.Jnl_entry;
import Vdb.OpenFlags;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

class FsdEntry
implements Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String name = null;
    public double[] filesizes = new double[]{4096.0};
    public FileAnchor anchor = null;
    public String dirname = null;
    public String jnl_dir_name = null;
    public int width = 1;
    public int depth = 1;
    public int files = 10;
    public String dist = "bottom";
    public boolean cleanup_old = false;
    public OpenFlags open_flags = new OpenFlags();
    public int fsdcount = 0;
    public int fsdstart = 0;
    public long working_set = 0L;
    public long total_size = Long.MAX_VALUE;
    public boolean shared = false;
    public boolean create_rw_log = false;
    public Dedup dedup = null;
    public String file_mask = "vdb_f%04d.file";
    public String dir_mask = "vdb.%d_%d.dir";
    public String cloud_url = null;
    public String cloud_user = null;
    public String cloud_pwd = null;
    public boolean in_use;
    public boolean work_done;
    public static int max_fsd_name = 0;
    private static Vector<FsdEntry> fsd_list = new Vector(16);
    private static FsdEntry dflt = new FsdEntry();

    FsdEntry() {
    }

    public Object clone() {
        try {
            FsdEntry fsdEntry = (FsdEntry)super.clone();
            fsdEntry.filesizes = (double[])this.filesizes.clone();
            fsdEntry.open_flags = (OpenFlags)this.open_flags.clone();
            if (this.dedup != null) {
                fsdEntry.dedup = (Dedup)this.dedup.clone();
            }
            return fsdEntry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static Vector<FsdEntry> getFsdList() {
        return fsd_list;
    }

    public static String[] getFsdNames() {
        HashMap<String, FsdEntry> hashMap = new HashMap<String, FsdEntry>(64);
        for (int i = 0; i < fsd_list.size(); ++i) {
            FsdEntry fsdEntry = fsd_list.elementAt(i);
            hashMap.put(fsdEntry.name, fsdEntry);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    static String readParms(String string) {
        String string2 = string;
        FsdEntry fsdEntry = null;
        try {
            while (true) {
                Vdb_scan vdb_scan = Vdb_scan.parms_split(string2);
                if (!(vdb_scan.keyword.equals("rd") || vdb_scan.keyword.equals("wd") || vdb_scan.keyword.equals("fwd") || vdb_scan.keyword.equals("sd"))) {
                    if (vdb_scan.keyword.equals("fsd")) {
                        Vdbmain.setFwdWorkload();
                        if (vdb_scan.alphas[0].equals("default")) {
                            fsdEntry = dflt;
                        } else {
                            for (int i = 0; i < fsd_list.size(); ++i) {
                                fsdEntry = fsd_list.elementAt(i);
                                if (!fsdEntry.name.equalsIgnoreCase(vdb_scan.alphas[0]) || fsdEntry.fsdcount != 0) continue;
                                common.failure("Duplicate fsd name: " + fsdEntry.name);
                            }
                            fsdEntry = (FsdEntry)dflt.clone();
                            fsdEntry.name = vdb_scan.alphas[0];
                            fsd_list.addElement(fsdEntry);
                            max_fsd_name = Math.max(max_fsd_name, fsdEntry.name.length());
                            if (Vdbmain.sd_list.size() > 0) {
                                common.ptod("'fsd' and 'sd' parameters are mutually exclusive");
                            }
                            if (Validate.isRealValidate() && fsdEntry.name.length() > 8) {
                                common.failure("For Data Validation an FSD name may be only 8 characters or less: " + fsdEntry.name);
                            }
                        }
                    } else if ("anchor".startsWith(vdb_scan.keyword)) {
                        fsdEntry.dirname = vdb_scan.alphas[0];
                    } else if ("journal".startsWith(vdb_scan.keyword)) {
                        fsdEntry.jnl_dir_name = vdb_scan.alphas[0];
                    } else if ("host".startsWith(vdb_scan.keyword) || vdb_scan.keyword.equals("hd")) {
                        common.failure("No 'host=' parameter is allowed for a File System Definition (FSD)\nAn FSD is unique and can be used on only one host at the time.\nSpecify the 'host=' parameter in the File system Workload Definition (FWD)\nto target this FSD towards a specific host.");
                    } else if ("width".startsWith(vdb_scan.keyword)) {
                        fsdEntry.width = (int)vdb_scan.numerics[0];
                    } else if ("depth".startsWith(vdb_scan.keyword)) {
                        fsdEntry.depth = (int)vdb_scan.numerics[0];
                    } else if ("sizes".startsWith(vdb_scan.keyword)) {
                        fsdEntry.filesizes = vdb_scan.numerics;
                        if (vdb_scan.num_count == 0) {
                            common.failure("No NUMERIC parameters specified for 'sizes='");
                        }
                    } else if ("shared".startsWith(vdb_scan.keyword)) {
                        fsdEntry.shared = vdb_scan.alphas[0].toLowerCase().startsWith("y");
                    } else if ("wss".startsWith(vdb_scan.keyword) || "workingsetsize".startsWith(vdb_scan.keyword)) {
                        fsdEntry.working_set = (long)vdb_scan.numerics[0];
                        if (vdb_scan.num_count > 1) {
                            fsdEntry.working_set /= (long)vdb_scan.numerics[1];
                        }
                    } else if ("total_size".startsWith(vdb_scan.keyword) || "totalsize".startsWith(vdb_scan.keyword)) {
                        fsdEntry.total_size = (long)vdb_scan.numerics[0];
                        if (vdb_scan.num_count > 1) {
                            fsdEntry.total_size /= (long)vdb_scan.numerics[1];
                        }
                        if (fsdEntry.total_size < 0L) {
                            common.failure("A percentage value as a 'totalsize=' parameter is NOT allowed for an FSD; only for an RD.");
                        }
                    } else if ("files".startsWith(vdb_scan.keyword)) {
                        fsdEntry.files = (int)vdb_scan.numerics[0];
                    } else if ("distribution".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.alphas[0].equals("bottom")) {
                            fsdEntry.dist = vdb_scan.alphas[0];
                        } else if (vdb_scan.alphas[0].equals("all")) {
                            fsdEntry.dist = vdb_scan.alphas[0];
                        } else {
                            common.failure("FSD distribution, invalid value: " + vdb_scan.alphas[0]);
                        }
                    } else if ("cleanup".startsWith(vdb_scan.keyword)) {
                        common.failure("'cleanup=' parameter is obsolete");
                    } else if ("openflags".startsWith(vdb_scan.keyword)) {
                        fsdEntry.open_flags = new OpenFlags(vdb_scan.alphas, vdb_scan.numerics);
                    } else if (vdb_scan.keyword.equals("log")) {
                        fsdEntry.create_rw_log = vdb_scan.alphas[0].toLowerCase().startsWith("y");
                    } else if (vdb_scan.keyword.equals("mask")) {
                        fsdEntry.file_mask = vdb_scan.alphas[0];
                        if (vdb_scan.alpha_count > 1) {
                            fsdEntry.dir_mask = vdb_scan.alphas[1];
                        }
                        if (!fsdEntry.file_mask.startsWith("vdb")) {
                            common.failure("The file 'mask=%s' value MUST start with 'vdb'", fsdEntry.file_mask);
                        }
                        if (!fsdEntry.file_mask.endsWith(".file")) {
                            common.failure("The file 'mask=%s' value MUST end with '.file'", fsdEntry.file_mask);
                        }
                        if (!fsdEntry.dir_mask.startsWith("vdb")) {
                            common.failure("The directory 'mask=%s' value MUST start with 'vdb'", fsdEntry.dir_mask);
                        }
                        if (!fsdEntry.dir_mask.endsWith(".dir")) {
                            common.failure("The directory 'mask=%s' value MUST end with '.dir'", fsdEntry.dir_mask);
                        }
                        if (fsdEntry.file_mask.indexOf("%0") < 0) {
                            common.failure("The file 'mask=%s' value MUST contain ONE printf '%%0xxx' mask", fsdEntry.file_mask);
                        }
                        if (fsdEntry.dir_mask.indexOf("%0") == fsdEntry.dir_mask.lastIndexOf("%0")) {
                            common.failure("The dir 'mask=%s' value MUST contain two '%%0xxx' printf masks", fsdEntry.dir_mask);
                        }
                    } else if ("count".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.getNumCount() != 2) {
                            common.failure("'count=(start,count)' parameter requires two values");
                        }
                        fsdEntry.fsdstart = (int)vdb_scan.numerics[0];
                        if (vdb_scan.getNumCount() > 1) {
                            fsdEntry.fsdcount = (int)vdb_scan.numerics[1];
                            if (fsdEntry.fsdcount <= 0) {
                                common.failure("'count=(start,count)' parameter requires two values of which the second value must be greater than zero.");
                            }
                        }
                    } else if (vdb_scan.keyword.startsWith("dedup")) {
                        common.failure("FSD specific dedup parameters: some time in the future");
                    } else if (vdb_scan.keyword.equals("cloud")) {
                        if (vdb_scan.getAlphaCount() != 3) {
                            common.failure("'cloud=(url,user,password)' requires three parameters");
                        }
                        fsdEntry.cloud_url = vdb_scan.alphas[0];
                        fsdEntry.cloud_user = vdb_scan.alphas[1];
                        fsdEntry.cloud_pwd = vdb_scan.alphas[2];
                    } else {
                        common.failure("Unknown keyword: " + vdb_scan.keyword);
                    }
                    string2 = Vdb_scan.parms_get();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.failure("Exception during reading of input parameter file(s).");
        }
        if (fsd_list.size() == 0) {
            return string2;
        }
        FsdEntry.checkParameters();
        FsdEntry.checkJournals();
        FsdEntry.handleFsdCount(fsd_list);
        Dedup.checkFsdDedup();
        FsdEntry.finalizeSetup();
        return string2;
    }

    private static void checkParameters() {
        FsdEntry fsdEntry;
        int n;
        int n2;
        for (n2 = 0; n2 < fsd_list.size(); ++n2) {
            FsdEntry fsdEntry2 = fsd_list.elementAt(n2);
            if (fsdEntry2.dirname != null) continue;
            common.failure("Directory name required for fsd=" + fsdEntry2.name);
        }
        n2 = 0;
        for (n = 0; n < fsd_list.size(); ++n) {
            fsdEntry = fsd_list.elementAt(n);
            if (fsdEntry.create_rw_log) {
                ++n2;
            }
            for (int i = n + 1; i < fsd_list.size(); ++i) {
                FsdEntry fsdEntry3 = fsd_list.elementAt(i);
                if (fsdEntry.dirname.equals(fsdEntry3.dirname) || !(fsdEntry.dirname + File.separator).startsWith(fsdEntry3.dirname + File.separator) && !(fsdEntry3.dirname + File.separator).startsWith(fsdEntry.dirname + File.separator)) continue;
                common.ptod("");
                common.ptod("fsd=" + fsdEntry.name + ",dir=" + fsdEntry.dirname);
                common.ptod("fsd=" + fsdEntry3.name + ",dir=" + fsdEntry3.dirname);
                common.failure("Directory (anchor) names used in fsd parameters may not be parents or children of each other: ");
            }
        }
        if (common.get_debug(common.CREATE_READ_WRITE_LOG) && n2 == 0) {
            common.failure("Requesting read/write log, but no 'log=yes' found as FSD parameter");
        }
        if (common.get_debug(common.CREATE_READ_WRITE_LOG) && !Validate.isRealValidate()) {
            common.failure("Requesting read/write log, but not using Data Validation");
        }
        for (n = 0; n < fsd_list.size(); ++n) {
            fsdEntry = fsd_list.elementAt(n);
            if (fsdEntry.filesizes.length == 0 || fsdEntry.filesizes.length == 2 && fsdEntry.filesizes[1] == 0.0) continue;
            if (fsdEntry.files <= 0) {
                common.failure("'files=' parameter must be greater than zero");
            }
            if (fsdEntry.files > 10000000 && fsdEntry.files % 1000000 != 777) {
                common.failure("'anchor=%s,files=%d' File count is limited to 10 million in a single directory.", fsdEntry.dirname, fsdEntry.files);
            }
            if (fsdEntry.filesizes.length == 1) continue;
            if (fsdEntry.filesizes.length % 2 != 0) {
                common.ptod("");
                common.ptod("fsd=" + fsdEntry.name + ": 'filesizes=' parameter must either");
                common.ptod("contain a single value, or values defined in pairs, where");
                common.ptod("in each pair the first value contains a file size, and the");
                common.ptod("second value contains a percentage of distribution for this");
                common.ptod("file size. Percentages must add up to 100%");
                common.failure("Parameter error");
            }
            double d = 0.0;
            for (int i = 0; i < fsdEntry.filesizes.length; i += 2) {
                fsdEntry.filesizes[i] = (long)fsdEntry.filesizes[i];
                d += fsdEntry.filesizes[i + 1];
            }
            if ((int)d == 100) continue;
            common.ptod("");
            common.ptod("fsd=" + fsdEntry.name + ": 'filesizes=' parameter must either");
            common.ptod("contain a single value, or values defined in pairs, where");
            common.ptod("in each pair the first value contains a file size, and the");
            common.ptod("second value contains a percentage of distribution for this");
            common.ptod("file size. Percentages must add up to 100%");
            common.failure("Parameter error");
        }
    }

    private static void checkJournals() {
        for (int i = 0; i < fsd_list.size(); ++i) {
            FsdEntry fsdEntry = fsd_list.elementAt(i);
            if (!Jnl_entry.isRawJournal(fsdEntry.jnl_dir_name)) continue;
            for (int j = i; j < fsd_list.size(); ++j) {
                FsdEntry fsdEntry2 = fsd_list.elementAt(j);
                if (!Jnl_entry.isRawJournal(fsdEntry2.jnl_dir_name) || !fsdEntry2.jnl_dir_name.equals(fsdEntry.jnl_dir_name)) continue;
                common.failure("When using a raw device for journaling every FSD needs his own raw journal device: journal=" + fsdEntry.jnl_dir_name);
            }
        }
    }

    public static void finalizeSetup() {
        for (int i = 0; i < fsd_list.size(); ++i) {
            FsdEntry fsdEntry = fsd_list.elementAt(i);
            fsdEntry.anchor = FileAnchor.newFileAnchor(fsdEntry);
        }
    }

    public static void markKstatActive() {
        if (!common.onSolaris()) {
            return;
        }
        for (int i = 0; i < fsd_list.size(); ++i) {
            FsdEntry fsdEntry = fsd_list.elementAt(i);
            fsdEntry.anchor.getKstatForAnchor();
            if (fsdEntry.anchor.devxlate_list != null) continue;
            common.ptod("fsd=" + fsdEntry.name + ": Not all Kstat information available.");
            return;
        }
    }

    private static void handleFsdCount(Vector vector) {
        FsdEntry fsdEntry;
        int n;
        FsdEntry fsdEntry2;
        int n2;
        boolean bl = false;
        do {
            bl = false;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                fsdEntry2 = (FsdEntry)vector.elementAt(n2);
                for (n = 0; n < fsdEntry2.fsdcount; ++n) {
                    fsdEntry = (FsdEntry)fsdEntry2.clone();
                    fsdEntry.name = fsdEntry2.name.contains("%") ? String.format(fsdEntry2.name, n + fsdEntry2.fsdstart) : fsdEntry.name + (n + fsdEntry2.fsdstart);
                    fsdEntry.dirname = fsdEntry2.dirname.contains("%") ? String.format(fsdEntry2.dirname, n + fsdEntry2.fsdstart) : fsdEntry.dirname + (n + fsdEntry2.fsdstart);
                    fsdEntry.fsdcount = 0;
                    vector.add(fsdEntry);
                    max_fsd_name = Math.max(max_fsd_name, fsdEntry.name.length());
                    bl = true;
                    common.plog("'fsd=" + fsdEntry2.name + ",count=(start,count)' added " + fsdEntry.name + " " + fsdEntry.dirname);
                }
                if (fsdEntry2.fsdcount <= 0) continue;
                vector.remove(fsdEntry2);
            }
        } while (bl);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            fsdEntry2 = (FsdEntry)vector.elementAt(n2);
            for (n = n2 + 1; n < vector.size(); ++n) {
                fsdEntry = (FsdEntry)vector.elementAt(n);
                if (!fsdEntry.name.equals(fsdEntry2.name)) continue;
                common.failure("Duplicate FSD names not allowed: " + fsdEntry2.name);
            }
        }
    }

    public static FsdEntry findFsd(String string) {
        for (FsdEntry fsdEntry : fsd_list) {
            if (!fsdEntry.name.equals(string)) continue;
            return fsdEntry;
        }
        common.failure("fsd=" + string + " not found");
        return null;
    }
}

