/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.common;

public class FwdPrint {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    String hdr1 = null;
    String hdr2 = null;
    String fmt2 = null;
    int width2 = 0;
    String hdr2a = null;
    String hdr2b = null;
    String fmt2a = null;
    String fmt2b = null;
    int width2a = 0;
    int width2b = 0;

    public FwdPrint(String string, String string2, String string3) {
        this.hdr1 = string;
        this.hdr2 = string2;
        this.fmt2 = string3;
        this.width2 = FwdPrint.calcWidth(string3);
        if (this.width2 < this.hdr1.length()) {
            common.ptod("FwdPrint() hdr1: '" + this.hdr1 + "'");
            common.ptod("FwdPrint() hdr2: '" + this.hdr2 + "'");
            common.ptod("FwdPrint() fmt2: '" + this.fmt2 + "'");
            common.ptod("hdr1 length may not be longer than fmt2");
            common.failure("formatting error");
        }
    }

    public FwdPrint(String string, String string2, String string3, String string4, String string5) {
        this.hdr1 = string;
        this.hdr2a = string2;
        this.fmt2a = string3;
        this.width2a = FwdPrint.calcWidth(string3);
        if (this.width2a < string2.length()) {
            common.ptod("header1: " + this.hdr1);
            common.failure("FwdPrint(): header2 length (" + string2 + ") larger than column width (" + string3 + ")");
        }
        this.hdr2b = string4;
        this.fmt2b = string5;
        this.width2b = FwdPrint.calcWidth(string5);
        if (this.width2b < string4.length()) {
            common.ptod("header1: " + this.hdr1);
            common.failure("FwdPrint(): header2 length (" + string4 + ") larger than column width (" + string5 + ")");
        }
    }

    public String getHeader1() {
        if (this.hdr2 != null) {
            int n = this.width2 - this.hdr1.length();
            String string = "..................".substring(0, n / 2);
            String string2 = "..................".substring(0, n - string.length());
            String string3 = string + this.hdr1 + string2;
            return " " + string3;
        }
        int n = this.width2a + this.width2b - this.hdr1.length() + 1;
        String string = "..................".substring(0, n / 2);
        String string4 = "..................".substring(0, n - string.length());
        String string5 = string + this.hdr1 + string4;
        return " " + string5;
    }

    public String getHeader2() {
        if (this.hdr2 != null) {
            String string = Format.f(" %" + this.width2 + "s", this.hdr2);
            return string;
        }
        String string = Format.f(" %" + this.width2a + "s", this.hdr2a) + Format.f(" %" + this.width2b + "s", this.hdr2b);
        return string;
    }

    protected String getData(double d) {
        return Format.f(" %" + this.fmt2 + "F", d);
    }

    protected String getDataZ(double d) {
        if (d == 0.0) {
            return String.format(" %" + this.fmt2 + "s", "");
        }
        return Format.f(" %" + this.fmt2 + "F", d);
    }

    protected String getData(double d, double d2) {
        String string = Format.f(" %" + this.fmt2a + "F", d) + Format.f(" %" + this.fmt2b + "F", d2);
        return string;
    }

    protected String getDataZ(double d, double d2) {
        String string = d == 0.0 ? String.format(" %" + this.fmt2a + "s", "") : Format.f(" %" + this.fmt2a + "F", d);
        String string2 = d2 == 0.0 ? String.format(" %" + this.fmt2b + "s", "") : Format.f(" %" + this.fmt2b + "F", d2);
        return string + string2;
    }

    protected String getData(String string) {
        return Format.f(" %" + this.width2 + "s", string);
    }

    protected static int calcWidth(String string) {
        int n = Integer.parseInt(string.substring(0, string.indexOf(".")));
        return n;
    }

    public static void main(String[] stringArray) {
        FwdPrint fwdPrint = null;
        fwdPrint = new FwdPrint("hdr1", "hdr2", "12.1");
        common.ptod("one: " + fwdPrint.getHeader1());
        common.ptod("one: " + fwdPrint.getHeader2());
        common.ptod("one: " + fwdPrint.getData(5.5));
        common.ptod("");
        fwdPrint = new FwdPrint("hdr1", "7.1", "7.1", "7.1", "7.1");
        common.ptod("two: " + fwdPrint.getHeader1());
        common.ptod("two: " + fwdPrint.getHeader2());
        common.ptod("two: " + fwdPrint.getData(555555.55555, 666666.66666));
        FwdPrint fwdPrint2 = new FwdPrint("Operations", "7.1", "7.1");
        FwdPrint fwdPrint3 = new FwdPrint("Operations", "5.1", "5.1", "5.1", "5.1");
        common.ptod(fwdPrint2.getHeader1() + " " + fwdPrint3.getHeader1());
        common.ptod(fwdPrint2.getHeader2() + " " + fwdPrint3.getHeader2());
        common.ptod(fwdPrint2.getData(55555.0) + " " + fwdPrint3.getData(55555.0, 66666.0));
    }
}

