/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Utils.printf;
import Vdb.Blocked;
import Vdb.CurlHandling;
import Vdb.Dedup;
import Vdb.FileAnchor;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.OpenFlags;
import Vdb.Operations;
import Vdb.RD_entry;
import Vdb.Validate;
import Vdb.common;
import java.io.Serializable;
import java.util.Random;

class FwgEntry
implements Serializable,
Comparable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String fwg_name;
    public String fsd_name;
    public String host_name;
    public FileAnchor anchor;
    public FileAnchor target_anchor;
    public double[] filesizes;
    public double[] xfersizes;
    public boolean select_random;
    public boolean selseq_start0;
    public boolean select_once;
    public boolean select_full;
    public boolean select_empty;
    public boolean select_nfull;
    public double poisson_skew = 0.0;
    public boolean sequential_io;
    public boolean seq_io_start0;
    public boolean del_b4_write;
    public boolean file_sharing;
    public boolean shared;
    public long stopafter = Long.MAX_VALUE;
    public double skew;
    public int threads;
    public OpenFlags open_flags;
    public int width;
    public int depth;
    public int files;
    public long total_size;
    public long working_set;
    public String dist;
    public boolean work_done = false;
    private Random xfer_size_randomizer = new Random(0L);
    public Blocked blocked = new Blocked();
    private boolean shutting_down = false;
    private int operation;
    public double readpct = -1.0;
    public transient FwdEntry fwd_used;
    private static int sequence = 0;
    private int seqno = sequence++;
    public boolean create_rw_log = false;
    public Dedup dedup = null;

    public FwgEntry(FsdEntry fsdEntry, FwdEntry fwdEntry, RD_entry rD_entry, String string, int n) {
        this.fwd_used = fwdEntry;
        this.fwg_name = fwdEntry.fwd_name;
        this.host_name = string;
        this.xfersizes = fwdEntry.xfersizes;
        this.select_random = fwdEntry.select_random;
        this.select_once = fwdEntry.select_once;
        this.select_full = fwdEntry.select_full;
        this.select_empty = fwdEntry.select_empty;
        this.select_nfull = fwdEntry.select_nfull;
        this.selseq_start0 = fwdEntry.selseq_start0;
        this.poisson_skew = fwdEntry.poisson_skew;
        this.sequential_io = fwdEntry.sequential_io;
        this.seq_io_start0 = fwdEntry.seq_io_start0;
        this.file_sharing = fwdEntry.file_sharing;
        this.del_b4_write = fwdEntry.del_b4_write;
        this.stopafter = fwdEntry.stopafter;
        this.skew = fwdEntry.skew;
        this.threads = fwdEntry.threads;
        this.readpct = fwdEntry.readpct;
        this.fsd_name = fsdEntry.name;
        this.shared = fsdEntry.shared;
        this.filesizes = fsdEntry.filesizes;
        this.anchor = fsdEntry.anchor;
        this.width = fsdEntry.width;
        this.depth = fsdEntry.depth;
        this.files = fsdEntry.files;
        this.dist = fsdEntry.dist;
        this.working_set = fsdEntry.working_set;
        this.total_size = fsdEntry.total_size;
        this.operation = n;
        this.open_flags = fsdEntry.open_flags;
        this.create_rw_log = fsdEntry.create_rw_log;
        this.dedup = fsdEntry.dedup;
        if (this.xfersizes.length == 1 && this.xfersizes[0] == -1.0) {
            common.failure("No xfersize= specified for fwd=" + fwdEntry.fwd_name);
        }
        if (this.sequential_io && this.readpct >= 0.0) {
            common.failure("'fileio=sequential' and 'rdpct=' are mutually exclusive.");
        }
        if (fwdEntry.open_flags != null) {
            this.open_flags = fwdEntry.open_flags;
        }
        if (rD_entry.open_flags != null) {
            this.open_flags = rD_entry.open_flags;
        }
        if (fwdEntry.target_fsd != null) {
            this.setTargetFsd(this, fwdEntry);
        }
        if (this.operation < 0) {
            common.failure("Negative operation");
        }
        if (fsdEntry.cloud_url != null && this.anchor.curl == null) {
            this.anchor.curl = new CurlHandling(fsdEntry);
        }
    }

    public String getName() {
        return this.fwg_name;
    }

    public int getXferSize() {
        int n;
        if (Validate.isJournalRecoveryActive()) {
            return this.anchor.getDVMap().getKeyBlockSize();
        }
        if (this.xfersizes.length == 1) {
            return (int)this.xfersizes[0];
        }
        int n2 = this.xfer_size_randomizer.nextInt(100);
        int n3 = 0;
        for (n = 0; n < this.xfersizes.length && n2 >= (n3 = (int)((double)n3 + this.xfersizes[n + 1])); n += 2) {
        }
        int n4 = (int)this.xfersizes[n];
        return n4;
    }

    public int getMaxXfersize() {
        if (Validate.isJournalRecoveryActive()) {
            return this.anchor.getDVMap().getKeyBlockSize();
        }
        if (this.xfersizes.length == 1) {
            return (int)this.xfersizes[0];
        }
        double d = 0.0;
        for (int i = 0; i < this.xfersizes.length; i += 2) {
            d = Math.max(d, this.xfersizes[i]);
        }
        return (int)d;
    }

    public void setShutdown(boolean bl) {
        this.shutting_down = bl;
    }

    public boolean getShutdown() {
        return this.shutting_down;
    }

    public int getOperation() {
        if (this.operation < 0) {
            common.failure("Negative operation");
        }
        return this.operation;
    }

    public void setOperation(int n) {
        if (n < 0) {
            common.failure("Negative operation");
        }
        this.operation = n;
    }

    public boolean compareSizes(double[] dArray) {
        if (this.filesizes == null || dArray == null) {
            return false;
        }
        if (this.filesizes.length != dArray.length) {
            return false;
        }
        for (int i = 0; i < this.filesizes.length; ++i) {
            if (this.filesizes[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    private void setTargetFsd(FwgEntry fwgEntry, FwdEntry fwdEntry) {
        if (fwdEntry.target_fsd != null) {
            for (int i = 0; i < FsdEntry.getFsdList().size(); ++i) {
                FsdEntry fsdEntry = FsdEntry.getFsdList().elementAt(i);
                if (!fwdEntry.target_fsd.equals(fsdEntry.name)) continue;
                fwgEntry.target_anchor = fsdEntry.anchor;
                if (fsdEntry.depth != this.depth || fsdEntry.width != this.width || fsdEntry.files != this.files || fsdEntry.filesizes.length != this.filesizes.length) {
                    common.failure("FSD structure must be identical for anchor=" + this.anchor.getAnchorName() + " and 'target=" + fwdEntry.target_fsd + "'");
                }
                for (int j = 0; j < fsdEntry.filesizes.length; ++j) {
                    if (fsdEntry.filesizes[j] == this.filesizes[j]) continue;
                    common.failure("FSD structure must be identical for anchor=" + this.anchor.getAnchorName() + " and 'target=" + fwdEntry.target_fsd + "'");
                }
                return;
            }
            common.failure("'target=" + fwdEntry.target_fsd + "'. FSD not found");
        }
    }

    public String toString() {
        printf printf2 = new printf("fwg=%-8s op=%-6s sel=%-4s sq=%-4s sk=%3d th=%2d an=%-8s wd=%4d dp=%4d fl=%4d to=%d");
        printf2.add(this.fwg_name);
        printf2.add(Operations.getOperationText(this.operation));
        printf2.add(this.select_random);
        printf2.add(this.sequential_io);
        printf2.add(this.skew);
        printf2.add(this.threads);
        printf2.add(this.anchor.getAnchorName());
        printf2.add(this.width);
        printf2.add(this.depth);
        printf2.add(this.files);
        printf2.add(this.total_size);
        return Format.f("fwg:%4d ", this.seqno) + printf2.text;
    }

    public int compareTo(Object object) {
        return this.fwg_name.compareTo(((FwgEntry)object).fwg_name);
    }
}

