/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FwgEntry;
import Vdb.FwgWaiter;
import Vdb.Native;
import Vdb.RD_entry;
import Vdb.common;
import Vdb.ownmath;
import java.util.Random;
import java.util.concurrent.Semaphore;

class FwgQueue {
    long inter_arrival;
    long next_arrival;
    double fwd_rate;
    int seq;
    int distribution;
    boolean suspended = false;
    FwgEntry fwg;
    boolean max_rate_requested = false;
    private static int MAX_QUEUE_SEMA_SIZE = 2000;
    Semaphore work_avail_sema = new Semaphore(0);
    Semaphore max_queue_sema = new Semaphore(MAX_QUEUE_SEMA_SIZE);
    int releases = 0;
    private static boolean bypass_waiter = common.get_debug(common.BYPASS_FWGWAITER);

    public FwgQueue(FwgEntry fwgEntry, double d, int n, int n2) {
        this.fwg = fwgEntry;
        this.distribution = n;
        this.fwd_rate = d;
        this.seq = n2;
    }

    public void initialize() {
        if (this.fwd_rate == (double)RD_entry.MAX_RATE || this.fwd_rate == (double)RD_entry.CURVE_RATE) {
            this.fwd_rate = 9.9999999E7;
        }
        this.inter_arrival = (long)(1.0E11 / this.fwg.skew / this.fwd_rate);
        if (this.distribution == 0) {
            this.next_arrival = (long)ownmath.exponential(this.inter_arrival);
        } else if (this.distribution == 1) {
            this.next_arrival = (long)ownmath.uniform(0.0, this.inter_arrival * 2L);
        } else {
            Random random = new Random(10000 * this.seq);
            this.next_arrival = (long)((double)this.inter_arrival * random.nextDouble());
        }
        this.next_arrival += Native.get_simple_tod() * 1000L;
        this.max_rate_requested = this.fwd_rate == (double)RD_entry.MAX_RATE;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void suspendFwg() {
        this.suspended = true;
        this.work_avail_sema.release(1);
        this.max_queue_sema.release(1);
    }

    public synchronized void restartFwg() {
        this.work_avail_sema.drainPermits();
        this.max_queue_sema.drainPermits();
        this.max_queue_sema.release(MAX_QUEUE_SEMA_SIZE);
        this.suspended = false;
    }

    public void calculateNextStartTime() {
        long l = this.next_arrival;
        if (this.distribution == 0) {
            long l2 = (long)ownmath.exponential(this.inter_arrival);
            this.next_arrival += l2;
        } else if (this.distribution == 1) {
            long l3 = (long)ownmath.uniform(0.0, this.inter_arrival * 2L);
            this.next_arrival += l3;
        } else {
            this.next_arrival += this.inter_arrival;
        }
    }

    public int getPermit() throws InterruptedException {
        if (bypass_waiter) {
            return 0;
        }
        int n = this.max_queue_sema.availablePermits();
        FwgWaiter.getUntilDone(this.work_avail_sema, "work_avail_sema " + this.fwg.fsd_name);
        this.max_queue_sema.release();
        return n;
    }
}

