/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.Blocked;
import Vdb.FileAnchor;
import Vdb.FormatCounter;
import Vdb.FsdEntry;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.FwgWaiter;
import Vdb.OpAccess;
import Vdb.OpClose;
import Vdb.OpCopy;
import Vdb.OpCreate;
import Vdb.OpDelete;
import Vdb.OpFormat;
import Vdb.OpGetAttr;
import Vdb.OpGetCloud;
import Vdb.OpMkdir;
import Vdb.OpMove;
import Vdb.OpOpen;
import Vdb.OpPutCloud;
import Vdb.OpRead;
import Vdb.OpReadWrite;
import Vdb.OpRmdir;
import Vdb.OpSetAttr;
import Vdb.OpWrite;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.Task_num;
import Vdb.Vdbmain;
import Vdb.Work;
import Vdb.common;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

class FwgRun {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static Vector threads_started = null;
    private static HashMap first_time_map = new HashMap(16);

    FwgRun() {
    }

    public static Vector getThreads() {
        return threads_started;
    }

    public static void startFwg(Work work) {
        FwgEntry fwgEntry;
        int n;
        threads_started = new Vector(256);
        Vector<FwgEntry> vector = work.fwgs_for_slave;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Blocked.resetCounters();
        for (n = 0; n < vector.size(); ++n) {
            fwgEntry = vector.elementAt(n);
            fwgEntry.anchor.swapAnchorName();
        }
        for (n = 0; n < vector.size(); ++n) {
            fwgEntry = vector.elementAt(n);
            if (first_time_map.get(fwgEntry.anchor.getAnchorName()) == null && work.force_fsd_cleanup) {
                common.ptod("Deleting old file structure because of forced cleanupOldFiles ('-c').");
                fwgEntry.anchor.setDeletePending(true);
            }
            first_time_map.put(fwgEntry.anchor.getAnchorName(), fwgEntry.anchor.getAnchorName());
        }
        for (n = 0; n < vector.size(); ++n) {
            fwgEntry = vector.elementAt(n);
            if (!fwgEntry.anchor.exist()) {
                common.failure("Anchor directory does not exist yet: " + fwgEntry.anchor.getAnchorName());
            }
            if (work.format_run && !work.format_flags.format_restart) {
                common.ptod("Deleting old file structure.");
                fwgEntry.anchor.setDeletePending(true);
            } else if (work.format_run && work.format_flags.format_clean) {
                common.ptod("Deleting old file structure. (format=clean)");
                fwgEntry.anchor.setDeletePending(true);
            }
            fwgEntry.anchor.trackXfersizes(fwgEntry.xfersizes);
            fwgEntry.anchor.trackFileSizes(fwgEntry.filesizes);
        }
        SlaveJvm.getMasterSocket().putMessage(new SocketMessage(SocketMessage.STARTING_FILE_STRUCTURE));
        for (n = 0; n < vector.size(); ++n) {
            long l = System.currentTimeMillis();
            FwgEntry fwgEntry2 = vector.elementAt(n);
            common.ptod("Starting initializeFileAnchor for rd=%s anchor=%s", SlaveWorker.work.work_rd_name, fwgEntry2.fsd_name);
            fwgEntry2.anchor.initializeFileAnchor(fwgEntry2);
            if (fwgEntry2.target_anchor != null) {
                fwgEntry2.target_anchor.initializeFileAnchor(fwgEntry2);
            }
            common.ptod("Completed initializeFileAnchor for %s: %.2f", fwgEntry2.fsd_name, (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        SlaveJvm.getMasterSocket().putMessage(new SocketMessage(SocketMessage.ENDING_FILE_STRUCTURE));
        FsdEntry.markKstatActive();
        FwgRun.calcSkew(vector);
        if (work.fwd_rate < 0.0) {
            work.fwd_rate = Vdbmain.observed_iorate * -1.0 * work.fwd_rate / 100.0;
        }
        if (work.fwd_rate <= 0.0) {
            common.ptod("");
            common.ptod("Filesystem Workload (fwd) requested");
            common.ptod("but no 'fwdrate' parameter is used");
            common.failure("missing 'fwdrate' parameter");
        }
        if (work.format_run) {
            FwgRun.setupFormatCounters(vector);
        }
        FwgWaiter fwgWaiter = new FwgWaiter(new Task_num("FwgWaiter"), vector, work.fwd_rate, work.distribution);
        fwgWaiter.start();
        int n2 = 0;
        ArrayList<File> arrayList = null;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry3 = vector.elementAt(i);
            fwgEntry3.setShutdown(false);
            if (work.format_run) {
                arrayList = FwgRun.getDirCleanupList(fwgEntry3.anchor);
            }
            ArrayList<OpFormat> arrayList2 = new ArrayList<OpFormat>(8);
            for (int j = 0; j < fwgEntry3.threads; ++j) {
                FwgThread fwgThread = null;
                int n3 = fwgEntry3.getOperation();
                String string = work.format_run ? "OpFormat" : Operations.getOperationText(n3);
                Task_num task_num = new Task_num("FwgThread " + string + " " + fwgEntry3.anchor.getAnchorName());
                if (work.format_run) {
                    fwgThread = new OpFormat(task_num, fwgEntry3);
                    arrayList2.add((OpFormat)fwgThread);
                    fwgThread.setFormatThreadNumber(j);
                } else if (fwgEntry3.readpct >= 0.0) {
                    fwgThread = new OpReadWrite(task_num, fwgEntry3);
                } else if (n3 == Operations.MKDIR) {
                    fwgThread = new OpMkdir(task_num, fwgEntry3);
                } else if (n3 == Operations.CREATE) {
                    fwgThread = new OpCreate(task_num, fwgEntry3);
                } else if (n3 == Operations.READ) {
                    fwgThread = new OpRead(task_num, fwgEntry3);
                } else if (n3 == Operations.WRITE) {
                    fwgThread = new OpWrite(task_num, fwgEntry3);
                } else if (n3 == Operations.GETATTR) {
                    fwgThread = new OpGetAttr(task_num, fwgEntry3);
                } else if (n3 == Operations.SETATTR) {
                    fwgThread = new OpSetAttr(task_num, fwgEntry3);
                } else if (n3 == Operations.ACCESS) {
                    fwgThread = new OpAccess(task_num, fwgEntry3);
                } else if (n3 == Operations.OPEN) {
                    fwgThread = new OpOpen(task_num, fwgEntry3);
                } else if (n3 == Operations.CLOSE) {
                    fwgThread = new OpClose(task_num, fwgEntry3);
                } else if (n3 == Operations.DELETE) {
                    fwgThread = new OpDelete(task_num, fwgEntry3);
                } else if (n3 == Operations.RMDIR) {
                    fwgThread = new OpRmdir(task_num, fwgEntry3);
                } else if (n3 == Operations.COPY) {
                    fwgThread = new OpCopy(task_num, fwgEntry3);
                } else if (n3 == Operations.MOVE) {
                    fwgThread = new OpMove(task_num, fwgEntry3);
                } else if (n3 == Operations.PUT) {
                    fwgThread = new OpPutCloud(task_num, fwgEntry3);
                } else if (n3 == Operations.GET) {
                    fwgThread = new OpGetCloud(task_num, fwgEntry3);
                } else {
                    common.failure("Operation not supported (yet?): " + n3);
                }
                ++n2;
                fwgThread.start();
                threads_started.add(fwgThread);
            }
            if (!work.format_run) {
                common.ptod("Started " + fwgEntry3.threads + " threads for " + "fwd=" + fwgEntry3.getName() + ",fsd=" + fwgEntry3.fsd_name + ",operation=" + Operations.getOperationText(fwgEntry3.getOperation()));
            } else {
                common.ptod("Started " + fwgEntry3.threads + " threads for " + "fwd=" + fwgEntry3.getName() + ",fsd=" + fwgEntry3.fsd_name);
            }
            if (!work.format_run) continue;
            FwgRun.giveDirnamesToClean(arrayList2, arrayList);
        }
        common.plog("Started " + n2 + " FwgThreads for rd=" + work.work_rd_name);
    }

    public static void calcSkew(Vector vector) {
        FwgEntry fwgEntry;
        int n;
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            fwgEntry = (FwgEntry)vector.elementAt(n);
            if (fwgEntry.skew != 0.0) {
                d += fwgEntry.skew;
                continue;
            }
            ++n2;
        }
        if (n2 != 0) {
            double d2 = (100.0 - d) / (double)n2;
            for (n = 0; n < vector.size(); ++n) {
                fwgEntry = (FwgEntry)vector.elementAt(n);
                if (fwgEntry.skew != 0.0) continue;
                fwgEntry.skew = d2;
                d += fwgEntry.skew;
            }
        }
        for (n = 999990; n < vector.size(); ++n) {
            fwgEntry = (FwgEntry)vector.elementAt(n);
            common.plog("Skew for fwd=" + fwgEntry.getName() + ",fsd=" + fwgEntry.fsd_name + Format.f(",operation=%-8s ", Operations.getOperationText(fwgEntry.getOperation()) + ":") + fwgEntry.skew);
        }
        if (vector.size() != 0 && (d < 99.9999 || d > 100.0001)) {
            common.failure("Total skew must add up to 100: " + d);
        }
    }

    private static void setupFormatCounters(Vector vector) {
        Integer[] integerArray;
        HashMap<FileAnchor, Integer> hashMap = new HashMap<FileAnchor, Integer>(32);
        for (int i = 0; i < vector.size(); ++i) {
            integerArray = (Integer[])vector.elementAt(i);
            hashMap.put(integerArray.anchor, new Integer(integerArray.threads));
        }
        if (vector.size() != hashMap.size()) {
            common.ptod("FwgEntry count does not match FileAnchor count: " + vector.size() + "/" + hashMap.size());
        }
        FileAnchor[] fileAnchorArray = hashMap.keySet().toArray(new FileAnchor[0]);
        integerArray = hashMap.values().toArray(new Integer[0]);
        for (int i = 0; i < fileAnchorArray.length; ++i) {
            fileAnchorArray[i].mkdir_threads_running = new FormatCounter(integerArray[i]);
            fileAnchorArray[i].create_threads_running = new FormatCounter(integerArray[i]);
        }
    }

    private static ArrayList<File> getDirCleanupList(FileAnchor fileAnchor) {
        ArrayList<File> arrayList = new ArrayList<File>(8);
        for (File file : new File(fileAnchor.getAnchorName()).listFiles()) {
            if (!file.getName().startsWith("vdb") || !file.isDirectory()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private static void giveDirnamesToClean(ArrayList<OpFormat> arrayList, ArrayList<File> arrayList2) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n = i % arrayList.size();
            OpFormat opFormat = arrayList.get(n);
            opFormat.storeCleanDir(arrayList2.get(i));
        }
    }

    public static void endOfRun(Work work) {
        for (FwgEntry fwgEntry : work.fwgs_for_slave) {
            fwgEntry.anchor.endOfRun();
        }
    }
}

