/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FwgEntry;
import Vdb.FwgQueue;
import Vdb.Native;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.common;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class FwgWaiter
extends Thread {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static Task_num tn;
    private static HashMap queues_map;
    private static FwgQueue[] queues;
    private static int distribution;
    private static boolean format;

    public FwgWaiter(Task_num task_num, Vector vector, double d, int n) {
        this.setName("FwgWaiter");
        tn = task_num;
        distribution = n;
        format = SlaveWorker.work.format_run;
        queues_map = new HashMap(64);
        for (int i = 0; i < vector.size(); ++i) {
            FwgQueue fwgQueue;
            FwgEntry fwgEntry = (FwgEntry)vector.elementAt(i);
            if (queues_map.put(fwgEntry, fwgQueue = new FwgQueue(fwgEntry, d, distribution, queues_map.size())) == null) continue;
            common.failure("Duplicate FwgEntry");
        }
        queues = queues_map.values().toArray(new FwgQueue[0]);
        tn.task_set_start_pending();
    }

    public static void initialize() {
        for (int i = 0; i < queues.length; ++i) {
            queues[i].initialize();
        }
    }

    public static void clearStuff() {
        queues = null;
        queues_map = null;
    }

    @Override
    public void run() {
        try {
            tn.task_set_start_complete();
            tn.waitForMasterGo();
            FwgWaiter.initialize();
            long l = Native.get_simple_tod();
            while (!SlaveJvm.isWorkloadDone()) {
                FwgQueue fwgQueue = null;
                for (int i = 0; i < queues.length; ++i) {
                    if (queues[i].isSuspended() || fwgQueue != null && FwgWaiter.queues[i].next_arrival >= fwgQueue.next_arrival) continue;
                    fwgQueue = queues[i];
                }
                if (fwgQueue == null) {
                    common.sleep_some(10L);
                    continue;
                }
                while (l < fwgQueue.next_arrival / 1000L) {
                    common.sleep_some_usecs(Math.min(100000L, fwgQueue.next_arrival / 1000L - l));
                    l = Native.get_simple_tod();
                }
                try {
                    if (!fwgQueue.isSuspended()) {
                        FwgWaiter.getUntilDone(fwgQueue.max_queue_sema, "max_queue_sema " + fwgQueue.fwg.fsd_name);
                        fwgQueue.work_avail_sema.release();
                    } else {
                        common.sleep_some_usecs(10L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                fwgQueue.calculateNextStartTime();
            }
            tn.task_set_terminating(0.0);
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    public static FwgQueue getMyQueue(FwgEntry fwgEntry) {
        FwgQueue fwgQueue = (FwgQueue)queues_map.get(fwgEntry);
        if (fwgQueue == null) {
            common.failure("Unknown FwgEntry");
        }
        return fwgQueue;
    }

    public static void printQueues() {
        for (int i = 0; i < queues.length; ++i) {
            common.ptod("printQueues: " + FwgWaiter.queues[i].fwg.fsd_name + " max " + FwgWaiter.queues[i].max_queue_sema.availablePermits() + " work " + FwgWaiter.queues[i].work_avail_sema.availablePermits());
        }
    }

    public static void getUntilDone(Semaphore semaphore, String string) throws InterruptedException {
        do {
            boolean bl;
            if (!(bl = semaphore.tryAcquire(1, 100L, TimeUnit.MILLISECONDS))) continue;
            return;
        } while (!SlaveJvm.isWorkloadDone());
        throw new InterruptedException();
    }

    static {
        queues_map = null;
        queues = null;
        distribution = 0;
    }
}

